/* large_sqr.c */
/*
 * Modified by National Institute of Informatics in Japan, 2013-2016.
 *
 */
/*
 * Copyright (C) 1998-2002
 * Akira Iwata & Takuto Okuno
 * Akira Iwata Laboratory,
 * Nagoya Institute of Technology in Japan.
 *
 * All rights reserved.
 *
 * This software is written by Takuto Okuno(usapato@anet.ne.jp)
 * And if you want to contact us, send an email to Kimitake Wakayama
 * (wakayama@elcom.nitech.ac.jp)
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * 3. All advertising materials mentioning features or use of this software must
 *    display the following acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *    Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *     Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 *   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *   AKIRA IWATA LABORATORY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 *   SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 *   IN NO EVENT SHALL AKIRA IWATA LABORATORY BE LIABLE FOR ANY SPECIAL,
 *   INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
 *   FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 *   NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION
 *   WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

#include "aiconfig.h"

#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <string.h>
#include <aicrypto/large_num.h>
#include <aicrypto/ok_err.h>

/*-----------------------------------------------
  ret = x ^ 2
-----------------------------------------------*/
int LN_sqr(LNm *x, LNm *ret){
	if((x->top<<1)>LN_MAX){
		OK_set_error(ERR_ST_LNM_BUFOVERFLOW,ERR_LC_LNM,ERR_PT_LNMSQR,NULL);
		return -1;
	}
#ifndef USE_PTHREAD
	if(x->top > KARATSUBA_TH)
		/* x have enough bit length */
		LN_sqr_kara(x,ret);
	else
#endif
		/* x have small bit length */
		LN_sqr_std(x,ret);
	return 0;
}


/*-----------------------------------------------
  ret = x ^ 2
-----------------------------------------------*/
void LN_sqr_std(LNm *x,LNm *ret){
	uint32_t *xn,*rn;
	int i,k = 0,r,xmin;

	rn = ret->num;
	memset(rn,0,sizeof(uint32_t)*LN_MAX);
	
	xmin =x->top;
	if(xmin==0){
		ret->top=0;
		return;
	}

	xmin = LN_MAX -xmin;
	xn = x->num;
	i = LN_MAX-1;
	r = i;

	do{
		uint32_t d,p,tmp;
		uint64_t o;
		int j;

		p=xn[i]; o= (uint64_t) p * p; o+=rn[r];

		rn[r]=(uint32_t)o;
		d=(uint32_t)(o>>32);

		j=i-1;
		k=r-1;
		tmp=0;

		while(j>=xmin){
			uint64_t c;

			c=tmp;
			o=(uint64_t)p * xn[j];

			(o&0x8000000000000000LL)?(tmp=1):(tmp=0);
			o<<=1;
			c<<=32; c+=rn[k]; c+=d; c+=o;
			if(o > c) tmp=1; /* carry up */

			rn[k]=(uint32_t)c;
			d=(uint32_t)(c>>32);

			k--;
			j--;
		};

		rn[k]+=d;
		if(d > rn[k]) tmp = 1; /* carry up */
		rn[k-1]+=tmp;

		i--;
		r-=2;
	}while(i>=xmin);

	ret->neg = 0;
	/* last rn[k-1] must be 0 so... */
	if(rn[k])
		ret->top = LN_MAX-k;
	else
		ret->top = LN_MAX-k-1;
}
