/* hkdftest.h */
/*
 * Copyright (c) 2017 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/index.html.
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */

#ifndef INCLUSION_GUARD_UUID_68C50546_B8AD_11E7_86BE_3F5B5AA06254
#define INCLUSION_GUARD_UUID_68C50546_B8AD_11E7_86BE_3F5B5AA06254

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * Basic test case with SHA-256
 *
 * Perform tests using test vectors described in Appendix A.1 of RFC5869
 */
int test_A1();

/**
 * Test with SHA-256 and longer inputs/outputs
 *
 * Perform tests using test vectors described in Appendix A.2 of RFC5869
 */
int test_A2();

/**
 * Test with SHA-256 and zero-length salt/info
 *
 * Perform tests using test vectors described in Appendix A.3 of RFC5869
 */
int test_A3();

/**
 * Basic test case with SHA-1
 *
 * Perform tests using test vectors described in Appendix A.4 of RFC5869
 */
int test_A4();

/**
 * Test with SHA-1 and longer inputs/outputs
 *
 * Perform tests using test vectors described in Appendix A.5 of RFC5869
 */
int test_A5();

/**
 * Test with SHA-1 and zero-length salt/info
 *
 * Perform tests using test vectors described in Appendix A.6 of RFC5869
 */
int test_A6();

/**
 * Test with SHA-1, salt not provided (defaults to HashLen zero octets),
 * zero-length info
 *
 * Perform tests using test vectors described in Appendix A.7 of RFC5869
 */
int test_A7();

#ifdef  __cplusplus
}
#endif

#endif	/* INCLUSION_GUARD_UUID_68C50546_B8AD_11E7_86BE_3F5B5AA06254 */
