/* hmactestfc.c */
/*
 * Modified by National Institute of Informatics in Japan, 2012-2017.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <aicrypto/ok_hmac.h>
#include <aicrypto/ok_sha2.h>
#include <aicrypto/nrg_sha3.h>

int test_hmac_md5(){
    unsigned char ret[20],inp[256];
    unsigned char md5_ans[3][16]={
	{0x92,0x94,0x72,0x7a,0x36,0x38,0xbb,0x1c,
	 0x13,0xf4,0x8e,0xf8,0x15,0x8b,0xfc,0x9d},
	{0x75,0x0c,0x78,0x3e,0x6a,0xb0,0xb5,0x03,
	 0xea,0xa8,0x6e,0x31,0x0a,0x5d,0xb7,0x38},
	{0x56,0xbe,0x34,0x52,0x1d,0x14,0x4c,0x88,
	 0xdb,0xb8,0xc7,0x33,0xf0,0xe8,0xb3,0xf6}};

    unsigned char key[3][16]={
	{0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
	 0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b},
	{"Jefe"},
	{0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
	 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa}};
    char in[2][28]={
	{"Hi There"},
	{"what do ya want for nothing?"}};
    int	i;

    for(i=0;i<11;i++){
	HMAC_MD5(8,in[0],16,key[0],ret);
	if(memcmp(ret,md5_ans[0],16)){
	    printf("test HMAC_MD5 (1) -- error!\n");
	    return -1;
	}

	HMAC_MD5(28,in[1],4,key[1],ret);
	if(memcmp(ret,md5_ans[1],16)){
	    printf("test HMAC_MD5 (2) -- error!\n");
	    return -1;
	}

	memset(inp,0xdd,64);
	HMAC_MD5(50,inp,16,key[2],ret);
	if(memcmp(ret,md5_ans[2],16)){
	    printf("test HMAC_MD5 (3) -- error!\n");
	    return -1;
        }
	if((i%5)==0)printf("test HMAC_MD5 -- ok : %d\n",i);
    }

    return 0;
}

int test_hmac_sha1(){
    unsigned char ret[20],inp[256];
    unsigned char sha1_ans[3][20]={
	{0xb6,0x17,0x31,0x86,0x55,0x05,0x72,0x64,0xe2,0x8b,
	 0xc0,0xb6,0xfb,0x37,0x8c,0x8e,0xf1,0x46,0xbe,0x00},
	{0xef,0xfc,0xdf,0x6a,0xe5,0xeb,0x2f,0xa2,0xd2,0x74,
	 0x16,0xd5,0xf1,0x84,0xdf,0x9c,0x25,0x9a,0x7c,0x79},
	{0x12,0x5d,0x73,0x42,0xb9,0xac,0x11,0xcd,0x91,0xa3,
	 0x9a,0xf4,0x8a,0xa1,0x7b,0x4f,0x63,0xf1,0x75,0xd3}};

    unsigned char key[3][20]={
	{0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
	 0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b},
	{"Jefe"},
	{0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
	 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa}};
    char in[2][28]={
	{"Hi There"},
	{"what do ya want for nothing?"}};
    int	i;

    for(i=0;i<11;i++){
	HMAC_SHA1(8,in[0],20,key[0],ret);
	if(memcmp(ret,sha1_ans[0],20)){
	    printf("test HMAC_SHA1 (1) -- error!\n");
	    return -1;
	}

	HMAC_SHA1(28,in[1],4,key[1],ret);
	if(memcmp(ret,sha1_ans[1],20)){
	    printf("test HMAC_SHA1 (2) -- error!\n");
	    return -1;
	}

	memset(inp,0xdd,64);
	HMAC_SHA1(50,inp,20,key[2],ret);
	if(memcmp(ret,sha1_ans[2],20)){
	    printf("test HMAC_SHA1 (3) -- error!\n");
	    return -1;
        }
	if((i%5)==0)printf("test HMAC_SHA1 -- ok : %d\n",i);
    }

    return 0;
}

int test_hmac_sha224(){
    unsigned char ret[SHA224_DIGESTSIZE],inp[256];
    unsigned char sha224_ans[3][SHA224_DIGESTSIZE]={
	{0x89,0x6f,0xb1,0x12,0x8a,0xbb,0xdf,0x19,
	 0x68,0x32,0x10,0x7c,0xd4,0x9d,0xf3,0x3f,
	 0x47,0xb4,0xb1,0x16,0x99,0x12,0xba,0x4f,
	 0x53,0x68,0x4b,0x22},
	{0xa3,0x0e,0x01,0x09,0x8b,0xc6,0xdb,0xbf,
	 0x45,0x69,0x0f,0x3a,0x7e,0x9e,0x6d,0x0f,
	 0x8b,0xbe,0xa2,0xa3,0x9e,0x61,0x48,0x00,
	 0x8f,0xd0,0x5e,0x44},
	{0x7f,0xb3,0xcb,0x35,0x88,0xc6,0xc1,0xf6,
	 0xff,0xa9,0x69,0x4d,0x7d,0x6a,0xd2,0x64,
	 0x93,0x65,0xb0,0xc1,0xf6,0x5d,0x69,0xd1,
	 0xec,0x83,0x33,0xea}};

    unsigned char key[3][20]={
	{0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
	 0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b},
	{"Jefe"},
	{0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
	 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa}};
    char in[2][28]={
	{"Hi There"},
	{"what do ya want for nothing?"}};
    int	i;

    for(i=0;i<11;i++){
	HMAC_SHA224(8,in[0],20,key[0],ret);
	if(memcmp(ret,sha224_ans[0],SHA224_DIGESTSIZE)){
	    printf("test HMAC_SHA224 (1) -- error!\n");
	    return -1;
	}

	HMAC_SHA224(28,in[1],4,key[1],ret);
	if(memcmp(ret,sha224_ans[1],SHA224_DIGESTSIZE)){
	    printf("test HMAC_SHA224 (2) -- error!\n");
	    return -1;
	}

	memset(inp,0xdd,64);
	HMAC_SHA224(50,inp,20,key[2],ret);
	if(memcmp(ret,sha224_ans[2],SHA224_DIGESTSIZE)){
	    printf("test HMAC_SHA224 (3) -- error!\n");
	    return -1;
        }
	if((i%5)==0)printf("test HMAC_SHA224 -- ok : %d\n",i);
    }

    return 0;
}

int test_hmac_sha256(){
    unsigned char ret[SHA256_DIGESTSIZE],inp[256];
    unsigned char sha256_ans[3][SHA256_DIGESTSIZE]={
	{0xb0,0x34,0x4c,0x61,0xd8,0xdb,0x38,0x53,
	 0x5c,0xa8,0xaf,0xce,0xaf,0x0b,0xf1,0x2b,
	 0x88,0x1d,0xc2,0x00,0xc9,0x83,0x3d,0xa7,
	 0x26,0xe9,0x37,0x6c,0x2e,0x32,0xcf,0xf7},
	{0x5b,0xdc,0xc1,0x46,0xbf,0x60,0x75,0x4e,
	 0x6a,0x04,0x24,0x26,0x08,0x95,0x75,0xc7,
	 0x5a,0x00,0x3f,0x08,0x9d,0x27,0x39,0x83,
	 0x9d,0xec,0x58,0xb9,0x64,0xec,0x38,0x43},
	{0x77,0x3e,0xa9,0x1e,0x36,0x80,0x0e,0x46,
	 0x85,0x4d,0xb8,0xeb,0xd0,0x91,0x81,0xa7,
	 0x29,0x59,0x09,0x8b,0x3e,0xf8,0xc1,0x22,
	 0xd9,0x63,0x55,0x14,0xce,0xd5,0x65,0xfe}};

    unsigned char key[3][20]={
	{0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
	 0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b},
	{"Jefe"},
	{0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
	 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa}};
    char in[2][28]={
	{"Hi There"},
	{"what do ya want for nothing?"}};
    int	i;

    for(i=0;i<11;i++){
	HMAC_SHA256(8,in[0],20,key[0],ret);
	if(memcmp(ret,sha256_ans[0],SHA256_DIGESTSIZE)){
	    printf("test HMAC_SHA256 (1) -- error!\n");
	    return -1;
	}

	HMAC_SHA256(28,in[1],4,key[1],ret);
	if(memcmp(ret,sha256_ans[1],SHA256_DIGESTSIZE)){
	    printf("test HMAC_SHA256 (2) -- error!\n");
	    return -1;
	}

	memset(inp,0xdd,64);
	HMAC_SHA256(50,inp,20,key[2],ret);
	if(memcmp(ret,sha256_ans[2],SHA256_DIGESTSIZE)){
	    printf("test HMAC_SHA256 (3) -- error!\n");
	    return -1;
        }
	if((i%5)==0)printf("test HMAC_SHA256 -- ok : %d\n",i);
    }

    return 0;
}

int test_hmac_sha384(){
    unsigned char ret[SHA384_DIGESTSIZE],inp[256];
    unsigned char sha384_ans[3][SHA384_DIGESTSIZE]={
	{0xaf,0xd0,0x39,0x44,0xd8,0x48,0x95,0x62,
	 0x6b,0x08,0x25,0xf4,0xab,0x46,0x90,0x7f,
	 0x15,0xf9,0xda,0xdb,0xe4,0x10,0x1e,0xc6,
	 0x82,0xaa,0x03,0x4c,0x7c,0xeb,0xc5,0x9c,
	 0xfa,0xea,0x9e,0xa9,0x07,0x6e,0xde,0x7f,
	 0x4a,0xf1,0x52,0xe8,0xb2,0xfa,0x9c,0xb6},
	{0xaf,0x45,0xd2,0xe3,0x76,0x48,0x40,0x31,
	 0x61,0x7f,0x78,0xd2,0xb5,0x8a,0x6b,0x1b,
	 0x9c,0x7e,0xf4,0x64,0xf5,0xa0,0x1b,0x47,
	 0xe4,0x2e,0xc3,0x73,0x63,0x22,0x44,0x5e,
	 0x8e,0x22,0x40,0xca,0x5e,0x69,0xe2,0xc7,
	 0x8b,0x32,0x39,0xec,0xfa,0xb2,0x16,0x49},
	{0x88,0x06,0x26,0x08,0xd3,0xe6,0xad,0x8a,
	 0x0a,0xa2,0xac,0xe0,0x14,0xc8,0xa8,0x6f,
	 0x0a,0xa6,0x35,0xd9,0x47,0xac,0x9f,0xeb,
	 0xe8,0x3e,0xf4,0xe5,0x59,0x66,0x14,0x4b,
	 0x2a,0x5a,0xb3,0x9d,0xc1,0x38,0x14,0xb9,
	 0x4e,0x3a,0xb6,0xe1,0x01,0xa3,0x4f,0x27}};

    unsigned char key[3][20]={
	{0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
	 0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b},
	{"Jefe"},
	{0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
	 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa}};
    char in[2][28]={
	{"Hi There"},
	{"what do ya want for nothing?"}};
    int	i;

    for(i=0;i<11;i++){
	HMAC_SHA384(8,in[0],20,key[0],ret);
	if(memcmp(ret,sha384_ans[0],SHA384_DIGESTSIZE)){
	    printf("test HMAC_SHA384 (1) -- error!\n");
	    return -1;
	}

	HMAC_SHA384(28,in[1],4,key[1],ret);
	if(memcmp(ret,sha384_ans[1],SHA384_DIGESTSIZE)){
	    printf("test HMAC_SHA384 (2) -- error!\n");
	    return -1;
	}

	memset(inp,0xdd,64);
	HMAC_SHA384(50,inp,20,key[2],ret);
	if(memcmp(ret,sha384_ans[2],SHA384_DIGESTSIZE)){
	    printf("test HMAC_SHA384 (3) -- error!\n");
	    return -1;
        }
	if((i%5)==0)printf("test HMAC_SHA384 -- ok : %d\n",i);
    }

    return 0;
}

int test_hmac_sha512(){
    unsigned char ret[SHA512_DIGESTSIZE],inp[256];
    unsigned char sha512_ans[3][SHA512_DIGESTSIZE]={
	{0x87,0xaa,0x7c,0xde,0xa5,0xef,0x61,0x9d,
	 0x4f,0xf0,0xb4,0x24,0x1a,0x1d,0x6c,0xb0,
	 0x23,0x79,0xf4,0xe2,0xce,0x4e,0xc2,0x78,
	 0x7a,0xd0,0xb3,0x05,0x45,0xe1,0x7c,0xde,
	 0xda,0xa8,0x33,0xb7,0xd6,0xb8,0xa7,0x02,
	 0x03,0x8b,0x27,0x4e,0xae,0xa3,0xf4,0xe4,
	 0xbe,0x9d,0x91,0x4e,0xeb,0x61,0xf1,0x70,
	 0x2e,0x69,0x6c,0x20,0x3a,0x12,0x68,0x54},
	{0x16,0x4b,0x7a,0x7b,0xfc,0xf8,0x19,0xe2,
	 0xe3,0x95,0xfb,0xe7,0x3b,0x56,0xe0,0xa3,
	 0x87,0xbd,0x64,0x22,0x2e,0x83,0x1f,0xd6,
	 0x10,0x27,0x0c,0xd7,0xea,0x25,0x05,0x54,
	 0x97,0x58,0xbf,0x75,0xc0,0x5a,0x99,0x4a,
	 0x6d,0x03,0x4f,0x65,0xf8,0xf0,0xe6,0xfd,
	 0xca,0xea,0xb1,0xa3,0x4d,0x4a,0x6b,0x4b,
	 0x63,0x6e,0x07,0x0a,0x38,0xbc,0xe7,0x37},
	{0xfa,0x73,0xb0,0x08,0x9d,0x56,0xa2,0x84,
	 0xef,0xb0,0xf0,0x75,0x6c,0x89,0x0b,0xe9,
	 0xb1,0xb5,0xdb,0xdd,0x8e,0xe8,0x1a,0x36,
	 0x55,0xf8,0x3e,0x33,0xb2,0x27,0x9d,0x39,
	 0xbf,0x3e,0x84,0x82,0x79,0xa7,0x22,0xc8,
	 0x06,0xb4,0x85,0xa4,0x7e,0x67,0xc8,0x07,
	 0xb9,0x46,0xa3,0x37,0xbe,0xe8,0x94,0x26,
	 0x74,0x27,0x88,0x59,0xe1,0x32,0x92,0xfb}};

    unsigned char key[3][20]={
	{0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
	 0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b},
	{"Jefe"},
	{0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
	 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa}};
    char in[2][28]={
	{"Hi There"},
	{"what do ya want for nothing?"}};
    int	i;

    for(i=0;i<11;i++){
	HMAC_SHA512(8,in[0],20,key[0],ret);
	if(memcmp(ret,sha512_ans[0],SHA512_DIGESTSIZE)){
	    printf("test HMAC_SHA512 (1) -- error!\n");
	    return -1;
	}

	HMAC_SHA512(28,in[1],4,key[1],ret);
	if(memcmp(ret,sha512_ans[1],SHA512_DIGESTSIZE)){
	    printf("test HMAC_SHA512 (2) -- error!\n");
	    return -1;
	}

	memset(inp,0xdd,64);
	HMAC_SHA512(50,inp,20,key[2],ret);
	if(memcmp(ret,sha512_ans[2],SHA512_DIGESTSIZE)){
	    printf("test HMAC_SHA512 (3) -- error!\n");
	    return -1;
        }
	if((i%5)==0)printf("test HMAC_SHA512 -- ok : %d\n",i);
    }

    return 0;
}

/* http://www.wolfgang-ehrhardt.de/hmac-sha3-testvectors.html  */
int test_hmac_sha3_224(){
	int j;
    unsigned char ret[SHA3_224_DIGESTSIZE],inp[256];
    unsigned char sha3_224_ans[3][SHA3_224_DIGESTSIZE]={
	{0x3b,0x16,0x54,0x6b,0xbc,0x7b,0xe2,0x70,
	 0x6a,0x03,0x1d,0xca,0xfd,0x56,0x37,0x3d,
	 0x98,0x84,0x36,0x76,0x41,0xd8,0xc5,0x9a,
	 0xf3,0xc8,0x60,0xf7},
	{0x7f,0xdb,0x8d,0xd8,0x8b,0xd2,0xf6,0x0d,
	 0x1b,0x79,0x86,0x34,0xad,0x38,0x68,0x11,
	 0xc2,0xcf,0xc8,0x5b,0xfa,0xf5,0xd5,0x2b,
	 0xba,0xce,0x5e,0x66},
	{0x67,0x6c,0xfc,0x7d,0x16,0x15,0x36,0x38,
	 0x78,0x03,0x90,0x69,0x2b,0xe1,0x42,0xd2,
	 0xdf,0x7c,0xe9,0x24,0xb9,0x09,0xc0,0xc0,
	 0x8d,0xbf,0xdc,0x1a}};

    unsigned char key[3][20]={
	{0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
	 0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b},
	{"Jefe"},
	{0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
	 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa}};
    char in[2][28]={
	{"Hi There"},
	{"what do ya want for nothing?"}};
    int	i;

    for(i=0;i<11;i++){
	HMAC_SHA3_224(8,in[0],20,key[0],ret);
	if(memcmp(ret,sha3_224_ans[0],SHA3_224_DIGESTSIZE)){
	    printf("test HMAC_SHA3_224 (1) -- error!\n");
	    return -1;
	}

	HMAC_SHA3_224(28,in[1],4,key[1],ret);
	if(memcmp(ret,sha3_224_ans[1],SHA3_224_DIGESTSIZE)){
	    printf("test HMAC_SHA3_224 (2) -- error!\n");
	    return -1;
	}

	memset(inp,0xdd,64);
	HMAC_SHA3_224(50,inp,20,key[2],ret);
	if(memcmp(ret,sha3_224_ans[2],SHA3_224_DIGESTSIZE)){
	    printf("test HMAC_SHA3_224 (3) -- error!\n");
	    return -1;
        }
	if((i%5)==0)printf("test HMAC_SHA3_224 -- ok : %d\n",i);
    }

    return 0;
}

int test_hmac_sha3_256(){
    unsigned char ret[SHA3_256_DIGESTSIZE],inp[256];
    unsigned char sha3_256_ans[3][SHA3_256_DIGESTSIZE]={
	{0xba,0x85,0x19,0x23,0x10,0xdf,0xfa,0x96,
	 0xe2,0xa3,0xa4,0x0e,0x69,0x77,0x43,0x51,
	 0x14,0x0b,0xb7,0x18,0x5e,0x12,0x02,0xcd,
	 0xcc,0x91,0x75,0x89,0xf9,0x5e,0x16,0xbb},
	{0xc7,0xd4,0x07,0x2e,0x78,0x88,0x77,0xae,
	 0x35,0x96,0xbb,0xb0,0xda,0x73,0xb8,0x87,
	 0xc9,0x17,0x1f,0x93,0x09,0x5b,0x29,0x4a,
	 0xe8,0x57,0xfb,0xe2,0x64,0x5e,0x1b,0xa5},
	{0x84,0xec,0x79,0x12,0x4a,0x27,0x10,0x78,
	 0x65,0xce,0xdd,0x8b,0xd8,0x2d,0xa9,0x96,
	 0x5e,0x5e,0xd8,0xc3,0x7b,0x0a,0xc9,0x80,
	 0x05,0xa7,0xf3,0x9e,0xd5,0x8a,0x42,0x07}};

    unsigned char key[3][20]={
	{0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
	 0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b},
	{"Jefe"},
	{0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
	 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa}};
    char in[2][28]={
	{"Hi There"},
	{"what do ya want for nothing?"}};
    int	i;

    for(i=0;i<11;i++){
	HMAC_SHA3_256(8,in[0],20,key[0],ret);
	if(memcmp(ret,sha3_256_ans[0],SHA3_256_DIGESTSIZE)){
	    printf("test HMAC_SHA3_256 (1) -- error!\n");
	    return -1;
	}

	HMAC_SHA3_256(28,in[1],4,key[1],ret);
	if(memcmp(ret,sha3_256_ans[1],SHA3_256_DIGESTSIZE)){
	    printf("test HMAC_SHA3_256 (2) -- error!\n");
	    return -1;
	}

	memset(inp,0xdd,64);
	HMAC_SHA3_256(50,inp,20,key[2],ret);
	if(memcmp(ret,sha3_256_ans[2],SHA3_256_DIGESTSIZE)){
	    printf("test HMAC_SHA3_256 (3) -- error!\n");
	    return -1;
        }
	if((i%5)==0)printf("test HMAC_SHA3_256 -- ok : %d\n",i);
    }

    return 0;
}

int test_hmac_sha3_384(){
    unsigned char ret[SHA3_384_DIGESTSIZE],inp[256];
    unsigned char sha3_384_ans[3][SHA3_384_DIGESTSIZE]={
	{0x68,0xd2,0xdc,0xf7,0xfd,0x4d,0xdd,0x0a,0x22,0x40,
	 0xc8,0xa4,0x37,0x30,0x5f,0x61,0xfb,0x73,0x34,0xcf,
	 0xb5,0xd0,0x22,0x6e,0x1b,0xc2,0x7d,0xc1,0x0a,0x2e,
	 0x72,0x3a,0x20,0xd3,0x70,0xb4,0x77,0x43,0x13,0x0e,
	 0x26,0xac,0x7e,0x3d,0x53,0x28,0x86,0xbd},
	{0xf1,0x10,0x1f,0x8c,0xbf,0x97,0x66,0xfd,0x67,0x64,
	 0xd2,0xed,0x61,0x90,0x3f,0x21,0xca,0x9b,0x18,0xf5,
	 0x7c,0xf3,0xe1,0xa2,0x3c,0xa1,0x35,0x08,0xa9,0x32,
	 0x43,0xce,0x48,0xc0,0x45,0xdc,0x00,0x7f,0x26,0xa2,
	 0x1b,0x3f,0x5e,0x0e,0x9d,0xf4,0xc2,0x0a},
	{0x27,0x5c,0xd0,0xe6,0x61,0xbb,0x8b,0x15,0x1c,0x64,
	 0xd2,0x88,0xf1,0xf7,0x82,0xfb,0x91,0xa8,0xab,0xd5,
	 0x68,0x58,0xd7,0x2b,0xab,0xb2,0xd4,0x76,0xf0,0x45,
	 0x83,0x73,0xb4,0x1b,0x6a,0xb5,0xbf,0x17,0x4b,0xec,
	 0x42,0x2e,0x53,0xfc,0x31,0x35,0xac,0x6e}};

    unsigned char key[3][20]={
	{0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
	 0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b},
	{"Jefe"},
	{0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
	 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa}};
    char in[2][28]={
	{"Hi There"},
	{"what do ya want for nothing?"}};
    int	i;

    for(i=0;i<11;i++){
	HMAC_SHA3_384(8,in[0],20,key[0],ret);
	if(memcmp(ret,sha3_384_ans[0],SHA3_384_DIGESTSIZE)){
	    printf("test HMAC_SHA3_384 (1) -- error!\n");
	    return -1;
	}

	HMAC_SHA3_384(28,in[1],4,key[1],ret);
	if(memcmp(ret,sha3_384_ans[1],SHA3_384_DIGESTSIZE)){
	    printf("test HMAC_SHA3_384 (2) -- error!\n");
	    return -1;
	}

	memset(inp,0xdd,64);
	HMAC_SHA3_384(50,inp,20,key[2],ret);
	if(memcmp(ret,sha3_384_ans[2],SHA3_384_DIGESTSIZE)){
	    printf("test HMAC_SHA3_384 (3) -- error!\n");
	    return -1;
        }
	if((i%5)==0)printf("test HMAC_SHA3_384 -- ok : %d\n",i);
    }

    return 0;
}

int test_hmac_sha3_512(){
    unsigned char ret[SHA3_512_DIGESTSIZE],inp[256];
    unsigned char sha3_512_ans[3][SHA3_512_DIGESTSIZE]={
	{0xeb,0x3f,0xbd,0x4b,0x2e,0xaa,0xb8,0xf5,0xc5,0x04,
	 0xbd,0x3a,0x41,0x46,0x5a,0xac,0xec,0x15,0x77,0x0a,
	 0x7c,0xab,0xac,0x53,0x1e,0x48,0x2f,0x86,0x0b,0x5e,
	 0xc7,0xba,0x47,0xcc,0xb2,0xc6,0xf2,0xaf,0xce,0x8f,
	 0x88,0xd2,0x2b,0x6d,0xc6,0x13,0x80,0xf2,0x3a,0x66,
	 0x8f,0xd3,0x88,0x8b,0xb8,0x05,0x37,0xc0,0xa0,0xb8,
	 0x64,0x07,0x68,0x9e},
	{0x5a,0x4b,0xfe,0xab,0x61,0x66,0x42,0x7c,0x7a,0x36,
	 0x47,0xb7,0x47,0x29,0x2b,0x83,0x84,0x53,0x7c,0xdb,
	 0x89,0xaf,0xb3,0xbf,0x56,0x65,0xe4,0xc5,0xe7,0x09,
	 0x35,0x0b,0x28,0x7b,0xae,0xc9,0x21,0xfd,0x7c,0xa0,
	 0xee,0x7a,0x0c,0x31,0xd0,0x22,0xa9,0x5e,0x1f,0xc9,
	 0x2b,0xa9,0xd7,0x7d,0xf8,0x83,0x96,0x02,0x75,0xbe,
	 0xb4,0xe6,0x20,0x24},
	{0x30,0x9e,0x99,0xf9,0xec,0x07,0x5e,0xc6,0xc6,0xd4,
	 0x75,0xed,0xa1,0x18,0x06,0x87,0xfc,0xf1,0x53,0x11,
	 0x95,0x80,0x2a,0x99,0xb5,0x67,0x74,0x49,0xa8,0x62,
	 0x51,0x82,0x85,0x1c,0xb3,0x32,0xaf,0xb6,0xa8,0x9c,
	 0x41,0x13,0x25,0xfb,0xcb,0xcd,0x42,0xaf,0xcb,0x7b,
	 0x6e,0x5a,0xab,0x7e,0xa4,0x2c,0x66,0x0f,0x97,0xfd,
	 0x85,0x84,0xbf,0x03}};

    unsigned char key[3][20]={
	{0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
	 0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b},
	{"Jefe"},
	{0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
	 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa}};
    char in[2][28]={
	{"Hi There"},
	{"what do ya want for nothing?"}};
    int	i;

    for(i=0;i<11;i++){
	HMAC_SHA3_512(8,in[0],20,key[0],ret);
	if(memcmp(ret,sha3_512_ans[0],SHA3_512_DIGESTSIZE)){
	    printf("test HMAC_SHA3_512 (1) -- error!\n");
	    return -1;
	}

	HMAC_SHA3_512(28,in[1],4,key[1],ret);
	if(memcmp(ret,sha3_512_ans[1],SHA3_512_DIGESTSIZE)){
	    printf("test HMAC_SHA3_512 (2) -- error!\n");
	    return -1;
	}

	memset(inp,0xdd,64);
	HMAC_SHA3_512(50,inp,20,key[2],ret);
	if(memcmp(ret,sha3_512_ans[2],SHA3_512_DIGESTSIZE)){
	    printf("test HMAC_SHA3_512 (3) -- error!\n");
	    return -1;
        }
	if((i%5)==0)printf("test HMAC_SHA3_512 -- ok : %d\n",i);
    }

    return 0;
}
