/* edctest.h */
/*
 * Copyright (c) 2019 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/index.html.
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */

#ifndef INCLUSION_GUARD_UUID_C6779B3A_71ED_40E8_98B0_6EAEFFBC3AC9
#define INCLUSION_GUARD_UUID_C6779B3A_71ED_40E8_98B0_6EAEFFBC3AC9

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * The test case of the X25519 function.
 *
 * Perform test using first test vector of X25519 described in section 5.2
 * of RFC7748.
 */
int test_X25519_derive();

/**
 * The test case of the X448 function.
 *
 * Perform test using first test vector of X448 described in section 5.2
 * of RFC7748.
 */
int test_X448_derive();

/**
 * The test case of the X25519 function with iteration.
 *
 * Perform test using second test vector of X25519 described in section 5.2
 * of RFC7748.
 */
int test_X25519_derive_with_iteration();

/**
 * The test case of the X448 function with iteration.
 *
 * Perform test using second test vector of X448 described in section 5.2
 * of RFC7748.
 */
int test_X448_derive_with_iteration();

/**
 * The test case of the X25519 used in Diffie-Hellman.
 *
 * Perform test using first test vector of X25519 described in section 6.2
 * of RFC7748.
 */
int test_X25519_Diffie_Hellman();

/**
 * The test case of the X448 used in Diffie-Hellman.
 *
 * Perform test using first test vector of X448 described in section 6.2
 * of RFC7748.
 */
int test_X448_Diffie_Hellman();

#ifdef  __cplusplus
}
#endif

#endif	/* INCLUSION_GUARD_UUID_C6779B3A_71ED_40E8_98B0_6EAEFFBC3AC9 */
