/* edc_internal.h */
/*
 * Copyright (c) 2019 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/index.html.
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */

#ifndef INCLUSION_GUARD_UUID_59821FAF_402C_46D0_8F24_5FDB557BBB44
#define INCLUSION_GUARD_UUID_59821FAF_402C_46D0_8F24_5FDB557BBB44

#include <aicrypto/nrg_edc.h>

extern uint8_t x25519_base_point[X25519_KEY_LENGTH];
extern uint8_t x448_base_point[X448_KEY_LENGTH];

/**
 * Perform scalar multiplication on X25519 curve.
 * For details, see section 5 of RFC 7748.
 *
 * @param [in] prv private key data.
 * @param [in] base base point or public key data.
 * @param [out] secret public key data or shared secret. the result depends
 * on base data.
 * @return 0 or -1 if error.
 */
int X25519_derive(uint8_t *prv, uint8_t *base, uint8_t *secret);

/**
 * Perform scalar multiplication on X448 curve.
 * For details, see section 5 of RFC 7748.
 *
 * @param [in] prv private key data.
 * @param [in] base base point or public key data.
 * @param [out] secret public key data or shared secret. the result depends
 * on base data.
 * @return 0 or -1 if error.
 */
int X448_derive(uint8_t *prv, uint8_t *base, uint8_t *secret);

#endif /* INCLUSION_GUARD_UUID_59821FAF_402C_46D0_8F24_5FDB557BBB44 */
