/* ecctestfunc.h */
/*
 * this header is just used for POSIX Thread test function.
 */

typedef struct pth_ecpm{
  ECParam     *E;
  ECp         *A;
  ECp         *B;
  LNm         *k;
  ECp         *ret;
  int         pow;
}pth_ecpm;

/* this length is significantly practical. */
#define NUM_THREADS     2

void init_pth_ECp_pmul(pth_ecpm **pe,ECParam *E, ECp *A, LNm *k);
void thread_ECp_pmulti(pth_ecpm **pe, ECp *ret);
void free_pth_ECp_pmul(pth_ecpm **pe);

pth_ecpm **pth_ecpm_array_new();
void pth_ecpm_array_free(pth_ecpm **pe);

void *ecp_multi_in(pth_ecpm *pe);
