/* destestfc.c */
/*
 * Modified by National Institute of Informatics in Japan, 2013-2016.
 *
 */

#include "aiconfig.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <aicrypto/ok_des.h>

#define UCH unsigned char

int test_des(){
    Key_DES  *deskey,*d1,*d2;
    Key_3DES *des3;
    unsigned char key1[] ={
      0x64,0x32,0x32,0x46,0xfa,0x01,0x43,0x25};
    unsigned char key2[] ={
      0xfe,0xdc,0xba,0x98,0x76,0x54,0x32,0x10};
    uint64_t in1 = 0xff0123456789ab00LL;
    uint64_t *in,*cry,*ret;
    int	 i,j;

    in  = (uint64_t*)malloc(sizeof(uint64_t)*4096);
    cry = (uint64_t*)malloc(sizeof(uint64_t)*4096);
    ret = (uint64_t*)malloc(sizeof(uint64_t)*4096);

    deskey = DESkey_new(8,key1);
    DES_set_iv(deskey,key2);
    d1 = DESkey_new(8,key1);
    d2 = DESkey_new(8,key2);
    des3 = DES3key_new(d1,d2,NULL);
    DES3_set_iv(des3,key1);
/*
    DES3_cbc_encrypt_ll(des3,1,&in1,cry);

    printf("%.8x%.8x\n",(long)(in1>>32),(long)in1);
    printf("%.8x%.8x\n",(long)(cry[0]>>32),(long)cry[0]);

    DES3_cbc_decrypt_ll(des3,1,cry,ret);

    printf("%.8x%.8x\n",(long)(cry[0]>>32),(long)cry[0]);
    printf("%.8x%.8x\n",(long)(ret[0]>>32),(long)ret[0]);    
*/
    for(i=0;i<3;i++){
      for(j=0;j<4096;j++){
		in[j] = (uint64_t)rand();
		in[j]|= (uint64_t)rand()<<16;
		in[j]|= (uint64_t)rand()<<32;
		in[j]|= (uint64_t)rand()<<48;
      }

	  printf("start step : %d\n",i);

	  /* --------------------------- */
      DES_ecb_encrypt_ll(deskey,4096,in,cry);
      DES_ecb_decrypt_ll(deskey,4096,cry,ret);

      if(memcmp(in,ret,sizeof(uint64_t)*4096)){
	  printf("error -- ECB %d\n",i);
	  return -1;
      }
      DES_ecb_encrypt(deskey,4096*8,(UCH*)in,(UCH*)cry);
      DES_ecb_decrypt(deskey,4096*8,(UCH*)cry,(UCH*)ret);

      if(memcmp(in,ret,4096*8)){
		printf("error -- ECB %d\n",i);
		return -1;
      }
	  printf("ok -- ECB %d\n",i);

	  /* --------------------------- */
	  deskey->iv = deskey->oiv;
      DES_cbc_encrypt_ll(deskey,4096,in,cry);
	  deskey->iv = deskey->oiv;
      DES_cbc_decrypt_ll(deskey,4096,cry,ret);

      if(memcmp(in,ret,sizeof(uint64_t)*4096)){
		printf("error -- CBC %d\n",i);
		return -1;
      }
	  deskey->iv = deskey->oiv;
      DES_cbc_encrypt(deskey,4096*8,(UCH*)in,(UCH*)cry);
	  deskey->iv = deskey->oiv;
      DES_cbc_decrypt(deskey,4096*8,(UCH*)cry,(UCH*)ret);

      if(memcmp(in,ret,4096*8)){
		printf("error -- CBC %d\n",i);
		return -1;
      }
	  printf("ok -- CBC %d\n",i);

	  /* --------------------------- */
      DES_cfb_encrypt_ll(deskey,16,4096,in,cry);
      DES_cfb_decrypt_ll(deskey,16,4096,cry,ret);

      if(memcmp(in,ret,sizeof(uint64_t)*4096)){
          printf("error -- CFB %d\n",i);
          return -1;
      }
	  printf("ok -- CFB %d\n",i);

	  /* --------------------------- */
      DES3_ecb_encrypt_ll(des3,4096,in,cry);
      DES3_ecb_decrypt_ll(des3,4096,cry,ret);

      if(memcmp(in,ret,sizeof(uint64_t)*4096)){
          printf("error -- EDE3 ECB %d\n",i);
          return -1;
      }
      DES3_ecb_encrypt(des3,4096*8,(UCH*)in,(UCH*)cry);
      DES3_ecb_decrypt(des3,4096*8,(UCH*)cry,(UCH*)ret);

      if(memcmp(in,ret,4096*8)){
          printf("error -- EDE3 ECB %d\n",i);
          return -1;
      }
      printf("ok -- EDE3 ECB %d\n",i);

	  /* --------------------------- */
	  des3->iv = des3->oiv;
      DES3_cbc_encrypt_ll(des3,4096,in,cry);
	  des3->iv = des3->oiv;
      DES3_cbc_decrypt_ll(des3,4096,cry,ret);

      if(memcmp(in,ret,sizeof(uint64_t)*4096)){
          printf("error -- EDE3 CBC %d\n",i);
          return -1;
      }
	  des3->iv = des3->oiv;
      DES3_cbc_encrypt(des3,4096*8,(UCH*)in,(UCH*)cry);
	  des3->iv = des3->oiv;
      DES3_cbc_decrypt(des3,4096*8,(UCH*)cry,(UCH*)ret);

      if(memcmp(in,ret,4096*8)){
          printf("error -- EDE3 ECB %d\n",i);
	  return -1;
      }
      printf("ok -- EDE3 CBC %d\n",i);
      printf("ok -- %d\n",i);
    }

	free(in); free(cry); free(ret);

    DESkey_free(deskey);
    DESkey_free(d1);
    DESkey_free(d2);
    DES3key_free(des3);
    return 0;
}
