/* des_speed.c */
/*
 * Copyright (C) 1998-2002
 * Akira Iwata & Takuto Okuno
 * Akira Iwata Laboratory,
 * Nagoya Institute of Technology in Japan.
 *
 * All rights reserved.
 *
 * This software is written by Takuto Okuno(usapato@anet.ne.jp)
 * And if you want to contact us, send an email to Kimitake Wakayama
 * (wakayama@elcom.nitech.ac.jp)
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * 3. All advertising materials mentioning features or use of this software must
 *    display the following acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *    Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *     Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 *   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *   AKIRA IWATA LABORATORY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 *   SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 *   IN NO EVENT SHALL AKIRA IWATA LABORATORY BE LIABLE FOR ANY SPECIAL,
 *   INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
 *   FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 *   NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION
 *   WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <time.h>
#include <sys/types.h>
#include <sys/times.h>

#include "ok_des.h"

#define TIMES

/* The following if from times(3) man page.  It may need to be changed */
#ifndef HZ
# ifndef CLK_TCK
#  ifndef _BSD_CLK_TCK_ /* FreeBSD hack */
#   define HZ   100.0
#  else /* _BSD_CLK_TCK_ */
#   define HZ ((double)_BSD_CLK_TCK_)
#  endif
# else /* CLK_TCK */
#  define HZ ((double)CLK_TCK)
# endif
#endif

#define START   0
#define STOP    1

static double Time_F(int s){
    double ret;
#ifdef TIMES
    static struct tms tstart,tend;

    if (s == START)
    {
	times(&tstart);
	return(0);
    }
    else
    {
	times(&tend);
	ret=((double)(tend.tms_utime-tstart.tms_utime))/HZ;
	return((ret < 1e-3)?1e-3:ret);
    }
#else /* !times() */
    static struct timeb tstart,tend;
    long i;

    if (s == START)
    {
	ftime(&tstart);
	return(0);
    }
    else
    {
	ftime(&tend);
	i=(long)tend.millitm-(long)tstart.millitm;
	ret=((double)(tend.time-tstart.time))+((double)i)/1000.0;
	return((ret < 0.001)?0.001:ret);
    }
#endif
}


int main(int argc,char **argv){
    Key_DES  *deskey,*d1,*d2;
    Key_3DES *des3;
    unsigned char key1[] ={
      0x64,0x32,0x32,0x46,0xfa,0x01,0x43,0x25};
    unsigned char key2[] ={
      0xfe,0xdc,0xba,0x98,0x76,0x54,0x32,0x10};
    unsigned char *dmy;
    ULLONG in1 = 0xff0123456789ab00L;
    ULLONG *in,*cry,*ret;
    double tm;
    int	 i,j;

    in  = (ULLONG*)MALLOC(sizeof(ULLONG)*4096);
    cry = (ULLONG*)MALLOC(sizeof(ULLONG)*4096);
    ret = (ULLONG*)MALLOC(sizeof(ULLONG)*4096);

    deskey = DESkey_new(8,key1);
    DES_set_iv(deskey,key2);
    d1 = DESkey_new(8,key1);
    d2 = DESkey_new(8,key2);
    /* use 2 keys (112 bit), but it works same as 3 keys (168 bit) */
    des3 = DES3key_new(d1,d2,NULL);
    DES3_set_iv(des3,key1);

    for(j=0;j<4096;j++){
	in[j] = (ULLONG)rand();
	in[j]|= (ULLONG)rand()<<16;
	in[j]|= (ULLONG)rand()<<32;
	in[j]|= (ULLONG)rand()<<48;
    }
    
    printf("----------DES-SPEED-TEST----------\n");
    /* DES (56bit) ecb mode encryption */
    Time_F(START);
    for(i=0;i<100;i++){
      DES_ecb_encrypt_ll(deskey,4096,in,cry);
    }
    tm=Time_F(STOP);
    i = (int)(((double)3200)/tm); /* 3200 = (4096*8*100)/1024 */
    printf("DES (56bit) ecb-encryption   -> %d KB/s\n",i);


    /* DES (56bit) ecb mode decryption */
    Time_F(START);
    for(i=0;i<100;i++){
      DES_ecb_decrypt_ll(deskey,4096,cry,ret);
    }
    tm=Time_F(STOP);
    i = (int)(((double)3200)/tm); /* 3200 = (4096*8*100)/1024 */
    printf("DES (56bit) ecb-decryption   -> %d KB/s\n",i);


    /* DES (56bit) cbc mode encryption */
    Time_F(START);
    for(i=0;i<100;i++){
      DES_cbc_encrypt_ll(deskey,4096,in,cry);
    }
    tm=Time_F(STOP);
    i = (int)(((double)3200)/tm); /* 3200 = (4096*8*100)/1024 */
    printf("DES (56bit) cbc-decryption   -> %d KB/s\n",i);


    /* DES (56bit) cbc mode decryption */
    Time_F(START);
    for(i=0;i<100;i++){
      DES_cbc_decrypt_ll(deskey,4096,cry,ret);
    }
    tm=Time_F(STOP);
    i = (int)(((double)3200)/tm); /* 3200 = (4096*8*100)/1024 */
    printf("DES (56bit) cbc-decryption   -> %d KB/s\n",i);


    /* 3DES (168bit) ecb mode encryption */
    Time_F(START);
    for(i=0;i<50;i++){
      DES3_ecb_encrypt_ll(des3,4096,in,cry);
    }
    tm=Time_F(STOP);
    i = (int)(((double)1600)/tm); /* 1600 = (4096*8*50)/1024 */
    printf("3DES (168bit) ecb-encryption -> %d KB/s\n",i);


    /* 3DES (168bit) ecb mode decryption */
    Time_F(START);
    for(i=0;i<50;i++){
      DES3_ecb_decrypt_ll(des3,4096,in,cry);
    }
    tm=Time_F(STOP);
    i = (int)(((double)1600)/tm); /* 1600 = (4096*8*50)/1024 */
    printf("3DES (168bit) ecb-decryption -> %d KB/s\n",i);


    /* 3DES (168bit) cbc mode encryption */
    Time_F(START);
    for(i=0;i<50;i++){
      DES3_cbc_encrypt_ll(des3,4096,in,cry);
    }
    tm=Time_F(STOP);
    i = (int)(((double)1600)/tm); /* 1600 = (4096*8*50)/1024 */
    printf("3DES (168bit) cbc-encryption -> %d KB/s\n",i);


    /* 3DES (168bit) cbc mode decryption */
    Time_F(START);
    for(i=0;i<50;i++){
      DES3_cbc_decrypt_ll(des3,4096,in,cry);
    }
    tm=Time_F(STOP);
    i = (int)(((double)1600)/tm); /* 1600 = (4096*8*50)/1024 */
    printf("3DES (168bit) cbc-decryption -> %d KB/s\n",i);


    DESkey_free(deskey);
    DESkey_free(d1);
    DESkey_free(d2);
    DES3key_free(des3);
    return 0;
}



