/* des.c */
/*
 * Modified by National Institute of Informatics in Japan, 2013-2016.
 *
 */
/*
 * Copyright (C) 1998-2002
 * Akira Iwata & Takuto Okuno
 * Akira Iwata Laboratory,
 * Nagoya Institute of Technology in Japan.
 *
 * All rights reserved.
 *
 * This software is written by Takuto Okuno(usapato@anet.ne.jp)
 * And if you want to contact us, send an email to Kimitake Wakayama
 * (wakayama@elcom.nitech.ac.jp)
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * 3. All advertising materials mentioning features or use of this software must
 *    display the following acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *    Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *     Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 *   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *   AKIRA IWATA LABORATORY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 *   SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 *   IN NO EVENT SHALL AKIRA IWATA LABORATORY BE LIABLE FOR ANY SPECIAL,
 *   INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
 *   FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 *   NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION
 *   WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

#include "aiconfig.h"

#include <stdio.h>
#include <stdint.h>
#include <aicrypto/ok_des.h>

uint64_t DES2Crypto(uint64_t blockL,uint64_t *keyL);
uint64_t DES2Plain(uint64_t blockL,uint64_t *keyL);
void des_crypto_asm(uint32_t *a, uint32_t *b, uint64_t *keyL,
					int init, int end, int dt);

uint32_t Sboxc[8][4][16]={
	{{0x00808200,0x00008000,0x00808002,0x00000002,0x00000200,0x00808202,0x00800202,0x00800000,0x00000202,0x00800200,0x00008200,0x00808000,0x00008002,0x00800002,0x00000000,0x00008202},
	{0x00000000,0x00808202,0x00008202,0x00008000,0x00808200,0x00000200,0x00808002,0x00000002,0x00800200,0x00008200,0x00808000,0x00800202,0x00800002,0x00008002,0x00000202,0x00800000},
	{0x00008000,0x00000002,0x00808200,0x00800000,0x00808002,0x00008200,0x00000200,0x00800202,0x00808202,0x00808000,0x00800002,0x00008202,0x00000202,0x00800200,0x00008002,0x00000000},
	{0x00808202,0x00808000,0x00800000,0x00000200,0x00008000,0x00800002,0x00000002,0x00008202,0x00008002,0x00800202,0x00000202,0x00808200,0x00800200,0x00000000,0x00008200,0x00808002}},

	{{0x40084010,0x00004000,0x00080000,0x40080010,0x40000010,0x40084000,0x40004000,0x00000010,0x00084000,0x40004010,0x40000000,0x00084010,0x00080010,0x00000000,0x00004010,0x40080000},
	{0x40004000,0x00084010,0x00000010,0x40004010,0x40084010,0x40000000,0x00080000,0x40080010,0x00080010,0x00000000,0x00004000,0x40080000,0x40000010,0x00084000,0x40084000,0x00004010},
	{0x00000000,0x40080010,0x40004010,0x40084000,0x40080000,0x00000010,0x00084010,0x00004000,0x00004010,0x00080000,0x00080010,0x40000010,0x00084000,0x40004000,0x40000000,0x40084010},
	{0x00084010,0x00080000,0x40080000,0x00004000,0x40004000,0x40084010,0x00000010,0x40000000,0x40084000,0x40000010,0x40004010,0x00080010,0x00000000,0x00004010,0x40080010,0x00084000}},

	{{0x00000104,0x00000000,0x04000100,0x00010104,0x00010004,0x04000004,0x04010104,0x04010000,0x04000000,0x04010100,0x00010100,0x04010004,0x04000104,0x00010000,0x00000004,0x00000100},
	{0x04010100,0x04010004,0x00000000,0x04000100,0x04000004,0x00010000,0x00010004,0x00000104,0x00000004,0x00000100,0x04010000,0x00010104,0x00010100,0x04000104,0x04010104,0x04000000},
	{0x04010100,0x00010004,0x00010000,0x04000100,0x00000100,0x04010104,0x04000004,0x00000000,0x04000104,0x04000000,0x00000004,0x00010100,0x04010000,0x00000104,0x00010104,0x04010004},
	{0x04000000,0x00000104,0x04010100,0x00000000,0x00010004,0x04000100,0x00000100,0x04010004,0x00010000,0x04010104,0x00010104,0x04000004,0x04000104,0x04010000,0x00000004,0x00010100}},

	{{0x80401000,0x80001040,0x00401040,0x80400000,0x00000000,0x00401000,0x80000040,0x00400040,0x80000000,0x00400000,0x00000040,0x80001000,0x80400040,0x00001040,0x00001000,0x80401040},
	{0x80001040,0x00000040,0x80400040,0x80001000,0x00401000,0x80401040,0x00000000,0x80400000,0x00001000,0x80401000,0x00400000,0x00001040,0x80000000,0x00400040,0x00401040,0x80000040},
	{0x00400040,0x00401000,0x80000040,0x00000000,0x00001040,0x80400040,0x80401000,0x80001040,0x80401040,0x80000000,0x80400000,0x00401040,0x80001000,0x00400000,0x00000040,0x00001000},
	{0x80400000,0x80401040,0x00000000,0x00401000,0x00400040,0x80000000,0x80001040,0x00000040,0x80000040,0x00001000,0x80001000,0x80400040,0x00001040,0x80401000,0x00400000,0x00401040}},

	{{0x00000080,0x01040000,0x00040000,0x20000000,0x20040080,0x01000080,0x21000080,0x00040080,0x01000000,0x20040000,0x20000080,0x21040080,0x21040000,0x00000000,0x01040080,0x21000000},
	{0x01040080,0x21000080,0x00000080,0x01040000,0x00040000,0x20040080,0x21040000,0x20000000,0x20040000,0x00000000,0x21040080,0x01000080,0x20000080,0x21000000,0x01000000,0x00040080},
	{0x00040000,0x00000080,0x20000000,0x21000080,0x01000080,0x21040000,0x20040080,0x01000000,0x21040080,0x21000000,0x01040000,0x20040000,0x00040080,0x20000080,0x00000000,0x01040080},
	{0x21000080,0x01000000,0x01040000,0x20040080,0x20000000,0x01040080,0x00000080,0x21040000,0x00040080,0x21040080,0x00000000,0x21000000,0x01000080,0x00040000,0x20040000,0x20000080}},

	{{0x10000008,0x00002000,0x10200000,0x10202008,0x10002000,0x00200000,0x00200008,0x10000000,0x00000000,0x10002008,0x00202000,0x00000008,0x10200008,0x00202008,0x00002008,0x10202000},
	{0x10200000,0x10202008,0x00000008,0x00200000,0x00202008,0x10000008,0x10002000,0x00002008,0x00200008,0x00002000,0x10002008,0x10200008,0x00000000,0x10202000,0x00202000,0x10000000},
	{0x10002000,0x10200008,0x10202008,0x00002008,0x00200000,0x10000000,0x10000008,0x00202000,0x00202008,0x00000000,0x00000008,0x10200000,0x00002000,0x10002008,0x10202000,0x00200008},
	{0x00000008,0x00202000,0x00200000,0x10000008,0x10002000,0x00002008,0x10202008,0x10200000,0x10202000,0x10200008,0x00002000,0x00202008,0x00200008,0x00000000,0x10000000,0x10002008}},

	{{0x00100000,0x02000401,0x00000400,0x00100401,0x02100401,0x00000000,0x00000001,0x02100001,0x02000400,0x00100001,0x02000001,0x02100400,0x02100000,0x00000401,0x00100400,0x02000000},
	{0x02100001,0x00000000,0x02000401,0x02100400,0x00100000,0x02000001,0x02000000,0x00000401,0x00100401,0x02000400,0x02100000,0x00100001,0x00000400,0x02100401,0x00000001,0x00100400},
	{0x02000000,0x00100000,0x02000401,0x02100001,0x00100001,0x02000400,0x02100400,0x00100401,0x00000401,0x02100401,0x00100400,0x00000001,0x00000000,0x02100000,0x02000001,0x00000400},
	{0x00100400,0x02000401,0x02100001,0x00000001,0x02000000,0x00100000,0x00000401,0x02100400,0x02000001,0x02100000,0x00000000,0x02100401,0x00100401,0x00000400,0x02000400,0x00100001}},

	{{0x08000820,0x00020000,0x08000000,0x00000020,0x00020020,0x08020820,0x08020800,0x00000800,0x08020000,0x08000800,0x00020800,0x08020020,0x00000820,0x00000000,0x08000020,0x00020820},
	{0x00000800,0x08020820,0x08000820,0x08000000,0x08020000,0x00020800,0x00020820,0x00000020,0x08000020,0x00000820,0x00020020,0x08020800,0x00000000,0x08020020,0x08000800,0x00020000},
	{0x00020820,0x08020800,0x00000020,0x00000800,0x08000800,0x08000020,0x08020020,0x00020000,0x00000000,0x00020020,0x08020000,0x08000820,0x08020820,0x00020800,0x00000820,0x08000000},
	{0x00020000,0x00000800,0x08020020,0x00020820,0x00000020,0x08020000,0x08000000,0x08000820,0x08020820,0x08000020,0x08000800,0x00000000,0x00020800,0x00000820,0x00020020,0x08020800}}
};

#define SBOX_OP(a,key,ti,ret) \
	(ti)  = (((a)<<5)|((a)>>27))^(int)(key>>42);\
	(ret) = Sboxc[0][(((ti)>>4)&0x02)|((ti)&0x01)][((ti)>>1)&0x0f];\
	(ti)  = ((a)>>23)^(int)(key>>36);\
	(ret)|= Sboxc[1][(((ti)>>4)&0x02)|((ti)&0x01)][((ti)>>1)&0x0f];\
	(ti)  = ((a)>>19)^(int)(key>>30);\
	(ret)|= Sboxc[2][(((ti)>>4)&0x02)|((ti)&0x01)][((ti)>>1)&0x0f];\
	(ti)  = ((a)>>15)^(int)(key>>24);\
	(ret)|= Sboxc[3][(((ti)>>4)&0x02)|((ti)&0x01)][((ti)>>1)&0x0f];\
	(ti)  = ((a)>>11)^(int)(key>>18);\
	(ret)|= Sboxc[4][(((ti)>>4)&0x02)|((ti)&0x01)][((ti)>>1)&0x0f];\
	(ti)  = ((a)>>7)^(int)(key>>12);\
	(ret)|= Sboxc[5][(((ti)>>4)&0x02)|((ti)&0x01)][((ti)>>1)&0x0f];\
	(ti)  = ((a)>>3)^(int)(key>>6);\
	(ret)|= Sboxc[6][(((ti)>>4)&0x02)|((ti)&0x01)][((ti)>>1)&0x0f];\
	(ti)  = (((a)<<1)|((a)>>31))^(int)(key);\
	(ret)|= Sboxc[7][(((ti)>>4)&0x02)|((ti)&0x01)][((ti)>>1)&0x0f];


#define BIT_EXCHG(a,b,reg,sh,msk)\
	(reg)=((((a)>>(sh))^(b))&(msk));\
	(b)^=(reg); (a)^=((reg)<<(sh));

void IP1(uint32_t *a,uint32_t *b){
	uint32_t reg,l=*a,r=*b;
	BIT_EXCHG(l,r,reg,4, 0x0f0f0f0fL);
	BIT_EXCHG(l,r,reg,16,0x0000ffffL);
	BIT_EXCHG(r,l,reg,2, 0x33333333L);
	BIT_EXCHG(r,l,reg,8, 0x00ff00ffL);
	BIT_EXCHG(l,r,reg,1, 0x55555555L);
	*a=l;*b=r;
}

void IP2(uint32_t *a, uint32_t *b){
	uint32_t reg,l=*a,r=*b;
	BIT_EXCHG(l,r,reg,1, 0x55555555L);
	BIT_EXCHG(r,l,reg,8, 0x00ff00ffL);
	BIT_EXCHG(r,l,reg,2, 0x33333333L);
	BIT_EXCHG(l,r,reg,16,0x0000ffffL);
	BIT_EXCHG(l,r,reg,4, 0x0f0f0f0fL);
	*a=l;*b=r;
}

void des_crypto(uint32_t *a, uint32_t *b, uint64_t *keyL, int enc){
	uint64_t key;
	uint32_t l=*a,r=*b,tmp;
	int i,ti,j;

    if(enc){
		for(i=0;i<16;i++){
			key = keyL[i];
			SBOX_OP(r,key,ti,j);

			tmp = l ^ j;
			l = r;
			r = tmp;
	    }
	}else{
	    for(i=15;i>=0;i--){
			key = keyL[i];
			SBOX_OP(l,key,ti,j);
	
			tmp = r ^ j;
			r = l;
			l = tmp;
		}
	}
	*a=l;*b=r;
}

/*------------------------------------------------
    1 block(64bit)
------------------------------------------------*/
uint64_t DES2Crypto(uint64_t blockL,uint64_t *keyL){
	uint32_t l,r;
    uint64_t	retL;

    l = (uint32_t)(blockL >> 32);
    r = (uint32_t) blockL;
	IP1(&l,&r);

	des_crypto(&l,&r,keyL,1);

	IP2(&r,&l);
	retL = (uint64_t)r << 32;
	retL |= l;

    return retL;
}

/*------------------------------------------------
    1 block(64bit)
------------------------------------------------*/
uint64_t DES2Plain(uint64_t blockL,uint64_t *keyL){
    uint32_t l,r;
    uint64_t	retL;

    r = (uint32_t)(blockL >> 32);
    l = (uint32_t) blockL;
	IP1(&r,&l);

	des_crypto(&l,&r,keyL,0);

   	IP2(&l,&r);
    retL = (uint64_t)l << 32;
    retL |= r;

    return retL;
}
