/* chacha.h */
/*
 * Copyright (c) 2017 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/index.html.
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */

/**
 * @file chacha.h
 *
 * These macros extracted from chacha.c for reuse in other source files.
 */

#ifndef INCLUSION_GUARD_UUID_01D8E620_B47C_11E7_AEDF_4F316C3F6E47
#define INCLUSION_GUARD_UUID_01D8E620_B47C_11E7_AEDF_4F316C3F6E47

#include "ecrypt-portable.h"

#define ROTATE(v,c) (ROTL32(v,c))
#define XOR(v,w) ((v) ^ (w))
#define PLUS(v,w) (U32V((v) + (w)))
#define PLUSONE(v) (PLUS((v),1))

#define QUARTERROUND(a,b,c,d) \
  x[a] = PLUS(x[a],x[b]); x[d] = ROTATE(XOR(x[d],x[a]),16); \
  x[c] = PLUS(x[c],x[d]); x[b] = ROTATE(XOR(x[b],x[c]),12); \
  x[a] = PLUS(x[a],x[b]); x[d] = ROTATE(XOR(x[d],x[a]), 8); \
  x[c] = PLUS(x[c],x[d]); x[b] = ROTATE(XOR(x[b],x[c]), 7);

#endif	/* INCLUSION_GUARD_UUID_01D8E620_B47C_11E7_AEDF_4F316C3F6E47 */
