/* chachatest.h */
/*
 * Copyright (c) 2017 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/index.html.
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */

#ifndef INCLUSION_GUARD_UUID_5F63A4E6_AF37_11E7_8B71_573B5114CADE
#define INCLUSION_GUARD_UUID_5F63A4E6_AF37_11E7_8B71_573B5114CADE

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * The test of the ChaCha Quarter Round.
 *
 * Perform tests using test vectors described in Section 2.2.1 of RFC7539.
 */
int test_QUARTERROUND();

/**
 * Test of the Quarter Round on the ChaCha State.
 *
 * Perform tests using test vectors described in Section 2.2.1 of RFC7539.
 */
int test_QUARTERROUND_on_the_ChaCha_State();

/**
 * Test of the ChaCha20 Block Function.
 *
 * Perform tests using test vectors described in Section 2.3.2 of RFC7539.
 */
int test_ChaCha20_Block_Function();

/**
 * Test of the ChaCha20 Cipher.
 *
 * Perform tests using test vectors described in Section 2.4.2 of RFC7539.
 */
int test_ChaCha20_Cipher();

/**
 * Test of the ChaCha20 Encrypt.
 *
 * Perform tests using test vectors described in Section 2.4.2 of RFC7539.
 * (Use the same data as test_ChaCha20_Cipher).
 */
int test_ChaCha20_Encrypt();

#ifdef  __cplusplus
}
#endif

#endif	/* INCLUSION_GUARD_UUID_5F63A4E6_AF37_11E7_8B71_573B5114CADE */
