/* chacha.c */
/*
 * Copyright (c) 2019 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/index.html.
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */

#include <stdlib.h>
#include <string.h>
#include <aicrypto/key_type.h>
#include <aicrypto/nrg_chacha.h>

Key_ChaCha *ChaChakey_new_() {
	Key_ChaCha *key;

	if ((key = malloc(sizeof(Key_ChaCha))) == NULL) {
		return NULL;
	}
	memset(key, 0, sizeof(Key_ChaCha));
	key->key_type = KEY_CHACHA;
	return key;
}

Key_ChaCha *ChaChakey_new(unsigned char *key, unsigned char *ivc) {
	Key_ChaCha *chacha_key;

	if ((chacha_key = ChaChakey_new_()) == NULL) {
		goto error;
	}
	ChaChakey_set(chacha_key, key);
	ChaCha_set_iv(chacha_key, ivc);

	return chacha_key;

error:
	ChaChakey_free(chacha_key);
	return NULL;
}

void ChaChakey_set(Key_ChaCha *chacha_key, unsigned char *key) {
	memcpy(chacha_key->key, key, CHACHA_KEY_LENGTH);
}

void ChaCha_set_iv(Key_ChaCha *chacha_key, unsigned char *ivc) {
	memcpy(chacha_key->iv, ivc, CHACHA_IV_LENGTH);
}

Key_ChaCha *ChaChakey_dup(Key_ChaCha *org) {
	Key_ChaCha *new;

	if (org == NULL) {
		return NULL;
	}

	if ((new = malloc(sizeof(Key_ChaCha))) == NULL) {
		return NULL;
	}
	memcpy(new, org, sizeof(Key_ChaCha));
	return new;
}

void ChaChakey_free(Key_ChaCha *chacha_key) {
	if (chacha_key == NULL) {
		return;
	}

	memset(chacha_key, 0, sizeof(Key_ChaCha));
	free(chacha_key);
}
