/* chacha20_poly1305test.h */
/*
 * Copyright (c) 2017 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/index.html.
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */

#ifndef INCLUSION_GUARD_UUID_FA64043E_B871_11E7_AE29_1B66CE001988
#define INCLUSION_GUARD_UUID_FA64043E_B871_11E7_AE29_1B66CE001988

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * Test of Poly1305 Key Generation.
 *
 * Perform tests using test vectors described in Section 2.6.2 of RFC7539.
 */
int test_Key_Generation();

/**
 * Test of AEAD_CHACHA20_POLY1305
 *
 * Perform tests using test vectors described in Section 2.8.2 of RFC7539.
 */
int test_AEAD_Construction();

#ifdef  __cplusplus
}
#endif

#endif	/* INCLUSION_GUARD_UUID_FA64043E_B871_11E7_AE29_1B66CE001988 */
