/* asn1testfc.c */
/*
 * Modified by National Institute of Informatics in Japan, 2013-2014.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <aicrypto/ok_asn1.h>

int test_asn1_oid(){
	unsigned char buf[32];
	char ret[64],in[64];
	char tstr[4][64]={"2.5.8","1.2.840.113549.1",
		"1.1.3.5135.55890.7.0.1","0.1.2.34.567.8910.0.0.0"};
	int i,j;

	for(j=0;j<4;j++){
		snprintf(in,62,"%s",tstr[j]);
		if((i=str2objid(in,buf,32))<0){
			printf("test_asn1_oid : error -- in str2objid (%d).\n",j);
			return -1;
		}

		if(objid2str(buf,ret,62)<0){
			printf("test_asn1_oid : error -- in objid2str (%d).\n",j);
			return -1;
		}

		if(strcmp(in,ret)){
			printf("test_asn1_oid : error -- result is different (%d).\n",j);
			return -1;}

		printf("test_asn1_oid : coding ok -- %d\n",j);
	}

	return 0;
}
