/* asn1_file.c */
/*
 * Modified by National Institute of Informatics in Japan, 2013-2016.
 *
 */
/*
 * Copyright (C) 1998-2002
 * Akira Iwata & Takuto Okuno
 * Akira Iwata Laboratory,
 * Nagoya Institute of Technology in Japan.
 *
 * All rights reserved.
 *
 * This software is written by Takuto Okuno(usapato@anet.ne.jp)
 * And if you want to contact us, send an email to Kimitake Wakayama
 * (wakayama@elcom.nitech.ac.jp)
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * 3. All advertising materials mentioning features or use of this software must
 *    display the following acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *    Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *     Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 *   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *   AKIRA IWATA LABORATORY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 *   SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 *   IN NO EVENT SHALL AKIRA IWATA LABORATORY BE LIABLE FOR ANY SPECIAL,
 *   INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
 *   FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 *   NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION
 *   WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

#include "aiconfig.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include <sys/types.h>
#include <sys/stat.h>

#ifdef HAVE_SYS_TIME_H
# include <sys/time.h>
#elif HAVE_SYS_TIMES_H
# include <sys/times.h>
#endif

#ifdef HAVE_FCNTL_H
# include <fcntl.h>
#endif

#include <aicrypto/ok_io.h>
#include <aicrypto/ok_err.h>
#include <aicrypto/ok_asn1.h>

/* simple sleep function */
void asn1_sleep(int msec){
  struct timeval tv;

  tv.tv_sec  = 0;
  tv.tv_usec = msec*1000; /* ms */

  select(0,NULL,NULL,NULL,&tv); /* wait _msec_ ms */
}

/*-----------------------------------------
  Read DER file (return DER buf)
-----------------------------------------*/
unsigned char *ASN1_read_der(char *fname){
	unsigned char *buf = NULL;
	int fd = 0;
	off_t sz;
	int j, err = -1;

	/* try 500 times to open */
	for(j=0;j<500;j++){
		if((fd=open(fname,O_RDONLY|O_SYNC))<0){
			asn1_sleep(10); /* sleep 10 msec */
			continue;
		}
		if((sz = ok_get_fdlen(fd)) > 0) break;
		close(fd); fd=0;
	}
	if(j==500){
		OK_set_error(ERR_ST_FILEOPEN,ERR_LC_ASN1,ERR_PT_ASN1FILE,NULL);
		goto done;
	}


	if((buf=(unsigned char*)malloc(sz+2))==NULL){
		OK_set_error(ERR_ST_MEMALLOC,ERR_LC_ASN1,ERR_PT_ASN1FILE,NULL);
		goto done;
	}

	if(read(fd,buf,sz)<sz){
		OK_set_error(ERR_ST_FILEREAD,ERR_LC_ASN1,ERR_PT_ASN1FILE,NULL);
		goto done;
	}
	buf[sz]=buf[sz+1]=0;

	if((buf[0]!=(ASN1_SEQUENCE|0x20)) && (buf[0]!=(ASN1_SET|0x20))){
		/* {FILE *fp;if(fp=fopen("#asn1_file_err.txt","a+")){fprintf(fp,"fname:%s:sz=%d:b[0]=%.2x\n",fname,sz,buf[0]);fclose(fp);}}*/
		/*{FILE *fp;if(fp=fopen("d:\\asn1_file_buf.bin","wb")){fwrite(buf,1,sz+1,fp);fclose(fp);}}*/
		OK_set_error(ERR_ST_ASN_NOTASN1,ERR_LC_ASN1,ERR_PT_ASN1FILE,NULL);
		goto done;
	}
	err=0;
done:
	if(err&&buf){ free(buf); buf=NULL;}
	if(fd > 0) close(fd);
	return(buf);
}

/*-----------------------------------------
  Write DER file.
  error -- return -1
-----------------------------------------*/
int ASN1_write_der(unsigned char *der,char *fname){
	int i,len,err=-1;
	int fd=0;

	if(der==NULL){
		OK_set_error(ERR_ST_NULLPOINTER,ERR_LC_ASN1,ERR_PT_ASN1FILE+1,NULL);
		return -1;
	}

	if((fd=open(fname,O_CREAT|O_WRONLY|O_TRUNC|O_SYNC,S_IRUSR|S_IWUSR|S_IRGRP|S_IROTH))<0)
	{
		OK_set_error(ERR_ST_FILEOPEN,ERR_LC_ASN1,ERR_PT_ASN1FILE+1,NULL);
		return -1;
	}

	if((len =ASN1_length((der+1),&i))<0){
		OK_set_error(ERR_ST_FILEWRITE,ERR_LC_ASN1,ERR_PT_ASN1FILE+1,NULL);
		goto done;
	}
	len+=i+1;

	if(write(fd,der,len)<len){
		OK_set_error(ERR_ST_FILEWRITE,ERR_LC_ASN1,ERR_PT_ASN1FILE+1,NULL);
		goto done;
	}
	err=0;
done:
	if(fd > 0) close(fd);
	return err;
}
