/* asn1_attr.c */
/*
 * Modified by National Institute of Informatics in Japan, 2013-2014.
 *
 */
/*
 * Copyright (C) 1998-2002
 * Akira Iwata & Takuto Okuno
 * Akira Iwata Laboratory,
 * Nagoya Institute of Technology in Japan.
 *
 * All rights reserved.
 *
 * This software is written by Takuto Okuno(usapato@anet.ne.jp)
 * And if you want to contact us, send an email to Kimitake Wakayama
 * (wakayama@elcom.nitech.ac.jp)
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * 3. All advertising materials mentioning features or use of this software must
 *    display the following acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *    Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *     Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 *   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *   AKIRA IWATA LABORATORY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 *   SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 *   IN NO EVENT SHALL AKIRA IWATA LABORATORY BE LIABLE FOR ANY SPECIAL,
 *   INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
 *   FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 *   NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION
 *   WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <aicrypto/ok_err.h>
#include <aicrypto/ok_asn1.h>

/*-----------------------------------------
  Attribute HcActorData
-----------------------------------------*/
int asn1_coded_data(CodedData *dat, unsigned char *in){
	unsigned char *t;
	char buf[64];
	int j,ok = -1;

	in = ASN1_next(in);

	/* codingSchemeReference [0] ObjectIdenrifier */
	memset(buf,0,64);
	t = ASN1_next(in);
	if(objid2str(t,buf,62)<=0) goto done;

	if ((dat->oid = strdup(buf)) == NULL){
		OK_set_error(ERR_ST_STRDUP,ERR_LC_ASN1_,ERR_PT_ASN1ATTR,NULL);
		goto done;
	}
	in = ASN1_skip(in);

	/* codeDataValue [1] NumericString OPTIONAL */
	if(*in == 0xa1){
		t = ASN1_next(in);
		if((dat->value=ASN1_numeric(t,&j))==NULL) goto done;
		in = ASN1_skip(in);
	}
	/* codeDataFreeText [2] DirectoryString OPTIONAL */
	if(*in == 0xa2){
		t = ASN1_next(in);
		if((dat->text=asn1_get_str(t,&j))==NULL) goto done;
	}

	ok = 0;
done:
	return ok;
}

CertExt *ASN1_attr_hcact(unsigned char* in){
	AT_HcActorData *ret=NULL;
	HcActor *hd,*ac=NULL;
	unsigned char *cp,*t;
	int i,j,len;

	if((ret=(AT_HcActorData*)CertExt_new(OBJ_ISO17090_HCACT))==NULL)
		goto error;

	if((ret->der=ASN1_dup(in))==NULL) goto error;

	len = ASN1_length(&in[1],&j);
	in = ASN1_next(in);

	for(i=0;i<len;){
		if((ac=HcActor_new())==NULL) goto error;

		cp = ASN1_next(in);
		/* coded data optional */
		if(*cp == 0xa0){
			t = ASN1_next(cp);
			if(asn1_coded_data(&ac->data,t)) goto error;
			cp = ASN1_skip(cp);
		}
		/* regional hcActor data */
		if(*cp == 0xa1){
			cp = ASN1_step(cp,3);
			/* country [0] PrintableString */
			t = ASN1_next(cp);
			if(*t != ASN1_PRINTABLE_STRING){
				OK_set_error(ERR_ST_ASN_NOTPRINTABLESTR,ERR_LC_ASN1_,ERR_PT_ASN1ATTR,NULL);
				goto error;
			}
			strncpy(ac->country,&t[2],2);

			/* issuingAuthority [1] DirectoryString */
			t = ASN1_next(cp);
			if((ac->issuer=asn1_get_str(t,&j))==NULL) goto error;
			cp = ASN1_skip(cp);

			/* hcMajorClassCode [2] CodedData */
			t = ASN1_next(cp);
			if(asn1_coded_data(&ac->major,t)) goto error;
			cp = ASN1_skip(cp);

			/* hcMajorClassCode [3] CodedData OPTIONAL */
			if(*t == 0xa3){
				t = ASN1_next(cp);
				if(asn1_coded_data(&ac->minor,t)) goto error;
			}
		}

		if(ret->actor==NULL){
			ret->actor = hd = ac;
		}else{
			hd->next = ac;
			hd = ac;
		}
		ac = NULL;

		if((in=ASN1_skip_(in,&j))==NULL) goto error;
		i+=j;
	}
	return (CertExt*)ret;
error:
	HcActor_free(ac);
	CertExt_free((CertExt*)ret);
	return NULL;
}

