/* ok_ssl.h */
/*
 * Modified by National Institute of Informatics in Japan, 2013-2015.
 *
 */
/*
 * Copyright (C) 1998-2002
 * Akira Iwata & Takuto Okuno
 * Akira Iwata Laboratory,
 * Nagoya Institute of Technology in Japan.
 *
 * All rights reserved.
 *
 * This software is written by Takuto Okuno(usapato@anet.ne.jp)
 * And if you want to contact us, send an email to Kimitake Wakayama
 * (wakayama@elcom.nitech.ac.jp)
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *	this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *	this list of conditions and the following disclaimer in the documentation
 *	and/or other materials provided with the distribution.
 *
 * 3. All advertising materials mentioning features or use of this software must
 *	display the following acknowledgment:
 *	"This product includes software developed by Akira Iwata Laboratory,
 *	Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *	acknowledgment:
 *	"This product includes software developed by Akira Iwata Laboratory,
 *	 Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 *
 *   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *   AKIRA IWATA LABORATORY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 *   SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 *   IN NO EVENT SHALL AKIRA IWATA LABORATORY BE LIABLE FOR ANY SPECIAL,
 *   INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
 *   FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 *   NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION
 *   WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

#ifndef INCLUSION_GUARD_UUID_6F0E58FF_5C9A_4F1F_92E5_FE8F35BCC93D
#define INCLUSION_GUARD_UUID_6F0E58FF_5C9A_4F1F_92E5_FE8F35BCC93D

#ifdef HAVE_NETDB_H
#include <netdb.h>
#endif

#include <sys/types.h>

#ifdef __WINDOWS__
# undef ULONG
/*
 * windows.h includes winsock.h, so some *.c files could not be compiled.
 * in that case, it should include winsock2.h before windows.h.
 * copy & paste following definition.
#ifndef _WINSOCKAPI_
# define _WINSOCKAPI_
#endif
 */
# include <winsock2.h>

#else
#include <sys/socket.h>
#include <netinet/in.h>
#endif

#include <aicrypto/ok_x509.h>
#include <aicrypto/ok_pkcs.h>

#ifdef  __cplusplus
extern "C" {
#endif

/*
 * SSL Structure
 */
typedef struct ssl SSL;
struct ssl;


/* SSL Verification mode -- see ok_x509.h more details */
#define SSL_DONT_VERIFY			DONT_VERIFY
#define SSL_DONT_VERIFY_CRL		DONT_VERIFY_CRL
#define SSL_ALLOW_SELF_SIGN		ALLOW_SELF_SIGN
#define SSL_DONT_CHECK_REVOKED		DONT_CHECK_REVOKED
#define SSL_IF_NO_CRL_DONT_CHECK_REVOKED	IF_NO_CRL_DONT_CHECK_REVOKED
#define SSL_ONLY_FIRST_DEPTH_CHECK_REVOKED	ONLY_FIRST_DEPTH_CHECK_REVOKED


/* ssl options & mode flag */
#define SSL_OPT_IMMEDIATE		0x0001	/* handshake after accept() immediately */
#define SSL_OPT_HS_SEPARATE		0x0002	/* send several handshake messages separately */
#define SSL_OPT_CERTREQ			0x0010	/* server send certificate request */
#define SSL_OPT_CERTREQOPT_F		0x0020	/* server doesn't check client certificate (flag) */
#define SSL_OPT_CERTREQOPT		(SSL_OPT_CERTREQ | SSL_OPT_CERTREQOPT_F)
						/* server send certificate request (nocheck mode) */
#define SSL_OPT_KEEPWBUF		0x0080	/* keep write buffer (data won't be flushed) */


/* SSL errnum */
#define SSL_ERR_CLOSE_NOTIFY		0x01	/* closed by receiving a close_notify alert */
#define SSL_ERR_PROTOCOL_VERSION	0x02	/* protocol version mismatch */


/* ssl.c */
SSL *SSL_new(void);
SSL *SSL_dup(SSL *org);
void SSL_free(SSL *ssl);
int SSL_get_error(SSL *ssl);


/* ssl_hs.c */
int SSL_handshake(SSL *ssl);


/* ssl_sock.c */
SSL *SSL_socket(int af,int type,int protocol);
int SSL_shutdown(SSL *ssl, int how);
int SSL_close(SSL *ssl);
int SSL_setsockopt(SSL *ssl, int level, int optname, const void * optval, int optlen);
int SSL_getsockopt(SSL *ssl, int level, int optname, void  *optval, int *optlen);
void SSL_set_timeout(int msec);
int SSL_get_timeout();


/* ssl_bind.c */
int SSL_bind(SSL *ssl, const struct sockaddr *name, int namelen);
int SSL_listen(SSL *ssl, int backlog);
SSL *SSL_accept(SSL *ssl, struct sockaddr *addr, int *addrlen);
int SSL_connect(SSL *ssl, const struct sockaddr *name, int namelen);
void SSL_setopt(SSL *ssl, int flag);
int SSL_getopt(SSL *ssl);


/* ssl_name.c */
int SSL_getpeername(SSL *ssl, struct sockaddr *name, int *namelen);
int SSL_getsockname(SSL *ssl, struct sockaddr *name, int *namelen);


/* ssl_write.c */
int SSL_write(SSL *ssl, void *buf, size_t nbyte);


/* ssl_read.c */
int SSL_read(SSL *ssl, void *buf, size_t nbyte);
int SSL_gets(SSL *ssl, char *buf, size_t nbyte);


/* ssl_tool.c */
int SSL_set_server_p12(SSL *ssl,char *fname,char *passwd);/* old function */
int SSL_set_serverkey_file(SSL *ssl,char *fname,char *passwd);
int SSL_set_serverkey_p12(SSL *ssl,PKCS12 *p12);
int SSL_set_serverkey_id(SSL *ssl,char *id);

int SSL_set_client_p12(SSL *ssl,char *fname,char *passwd);
int SSL_set_clientkey_file(SSL *ssl,char *fname,char *passwd);
int SSL_set_clientkey_p12(SSL *ssl,PKCS12 *p12);
int SSL_set_clientkey_id(SSL *ssl,char *id);

Cert *SSL_get_client_cert(SSL *ssl);
Cert *SSL_get_server_cert(SSL *ssl);
int SSL_got_certreq(SSL *ssl);


/* ssl_list.c */
void SSL_set_list_max(SSL *ssl,int num);


/* ssl_vfy.c */
int SSL_set_vfytype(SSL *ssl, int type);
int SSL_set_vfydepth(SSL *ssl, int depth);
int SSL_set_store(SSL *ssl,char *path);


/* OpenSSL compatible functions */
int SSL_get_fd(SSL *ssl);
int SSL_set_fd(SSL *ssl, int s);
Cert *SSL_get_peer_certificate(SSL *ssl);


#ifdef  __cplusplus
}
#endif

#endif /* INCLUSION_GUARD_UUID_6F0E58FF_5C9A_4F1F_92E5_FE8F35BCC93D */
