/* ok_spkac.h */
/*
 * Modified by National Institute of Informatics in Japan, 2014.
 *
 */
/*
 * Copyright (C) 1998-2005
 * Akira Iwata & Takuto Okuno
 * Akira Iwata Laboratory,
 * Nagoya Institute of Technology in Japan.
 *
 * All rights reserved.
 *
 * This software is written by Takuto Okuno(usapato@anet.ne.jp)
 * And if you want to contact us, send an email to Kimitake Wakayama
 * (wakayama@elcom.nitech.ac.jp)
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * 3. All advertising materials mentioning features or use of this software must
 *    display the following acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *    Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *     Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 *   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *   AKIRA IWATA LABORATORY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 *   SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 *   IN NO EVENT SHALL AKIRA IWATA LABORATORY BE LIABLE FOR ANY SPECIAL,
 *   INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
 *   FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 *   NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION
 *   WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

#ifndef INCLUSION_GUARD_UUID_E9485BA3_AFAE_4F3B_878C_C3BF5E1B6726
#define INCLUSION_GUARD_UUID_E9485BA3_AFAE_4F3B_878C_C3BF5E1B6726

#include <aicrypto/ok_rsa.h>
#include <aicrypto/ok_dsa.h>
#include <aicrypto/ok_ecdsa.h>
#include <aicrypto/ok_x509.h>

/*
 *	PublicKeyAndChallenge ::= SEQUENCE
 *	{
 *		spki SubjectPublicKeyInfo,
 *		challenge IA5STRING
 *	}
 *
 *	SignedPublicKeyAndChallenge ::= SEQUENCE
 *	{
 *		publicKeyAndChallenge PublicKeyAndChallenge,
 *		signatureAlgorithm AlgorithmIdentifier,
 *		signature BIT STRING
 *	}
 */

#ifdef  __cplusplus
extern "C" {
#endif

typedef struct netscape_spkac{
	int	pubkey_algo;
	Key	*pubkey;
	char	*challenge;

	int	signature_algo;
	int	siglen;
	unsigned char	*signature;

	/* DER encode strings */
	unsigned char	*der;

}SPKAC;

/* spkac.c */
SPKAC *SPKAC_new(void);
void SPKAC_free(SPKAC *spk);
SPKAC *SPKAC_dup(SPKAC *spk);

int SPKAC_verify(SPKAC *spk);

/* spkac_asn1.c */
unsigned char *SPKAC_toDER(SPKAC *spk,Key *prv,unsigned char *buf,int *ret_len);
int SPKAC_DER_pkac(SPKAC *spk,unsigned char *ret,int *ret_len);

int SPKAC_set_sigalgo(SPKAC *spk,Key *prv);
int SPKAC_estimate_der_size(SPKAC *spk);

/* spkac_print.c */
void SPKAC_print(SPKAC *spk);



#ifdef  __cplusplus
}
#endif

#endif /* INCLUSION_GUARD_UUID_E9485BA3_AFAE_4F3B_878C_C3BF5E1B6726 */
