/* ok_err.h */
/*
 * Modified by National Institute of Informatics in Japan, 2013-2017.
 *
 */
/*
 * Copyright (C) 1998-2002
 * Akira Iwata & Takuto Okuno
 * Akira Iwata Laboratory,
 * Nagoya Institute of Technology in Japan.
 *
 * All rights reserved.
 *
 * This software is written by Takuto Okuno(usapato@anet.ne.jp)
 * And if you want to contact us, send an email to Kimitake Wakayama
 * (wakayama@elcom.nitech.ac.jp)
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * 3. All advertising materials mentioning features or use of this software must
 *    display the following acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *    Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *     Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 *   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *   AKIRA IWATA LABORATORY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 *   SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 *   IN NO EVENT SHALL AKIRA IWATA LABORATORY BE LIABLE FOR ANY SPECIAL,
 *   INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
 *   FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 *   NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION
 *   WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

#ifndef INCLUSION_GUARD_UUID_7859576C_131A_46DF_9D93_09478052A018
#define INCLUSION_GUARD_UUID_7859576C_131A_46DF_9D93_09478052A018

#include <stdint.h>
#include <aicrypto/pkcs11.h>

#ifdef  __cplusplus
extern "C" {
#endif

/*-----------------------------------------------
 * Define error location
 *---------------------------------------------*/
#define	ERR_LC_NON		0x0
#define	ERR_LC_LNM		0x1
#define	ERR_LC_ECC		0x2
#define	ERR_LC_RAND		0x3
#define	ERR_LC_EDC		0x4

#define	ERR_LC_DES		0x10
#define	ERR_LC_RC2		0x11
#define	ERR_LC_RC4		0x12
#define	ERR_LC_AES		0x13
#define	ERR_LC_CHACHA20	0x14

#define	ERR_LC_MODES		0x20

#define	ERR_LC_MD2		0x30
#define	ERR_LC_MD5		0x31
#define	ERR_LC_SHA1		0x32
#define	ERR_LC_HMAC		0x33

#define	ERR_LC_RSA		0x40
#define	ERR_LC_DSA		0x41
#define	ERR_LC_ECDSA	0x42
#define	ERR_LC_DH		0x43
	
#define	ERR_LC_ASN1		0x50
#define	ERR_LC_X509		0x51
#define	ERR_LC_X509CERT	0x52
#define	ERR_LC_X509CRL	0x53
#define	ERR_LC_X509KEY	0x54
#define	ERR_LC_X509EXT	0x55
#define	ERR_LC_X509REQ	0x56
#define	ERR_LC_ASN1_	0x57

#define	ERR_LC_PKCS		0x5a
#define	ERR_LC_PKCS7	0x5b
#define	ERR_LC_PKCS12	0x5c
#define	ERR_LC_PKCS11	0x5d

#define	ERR_LC_PEM		0x60
#define	ERR_LC_SMIME	0x61
#define	ERR_LC_SSL		0x62
#define	ERR_LC_SSLHS	0x63
#define	ERR_LC_SSLREC	0x64
#define	ERR_LC_SSLALERT	0x65

#define ERR_LC_TLS1	0x66
#define ERR_LC_TLS2	0x67
#define ERR_LC_TLS3	0x68
#define ERR_LC_TLS4	0x69
#define ERR_LC_TLS5	0x6a
#define ERR_LC_TLS6	0x6b

#define	ERR_LC_TOOL		0x70
#define	ERR_LC_WINCRY	0x71
#define	ERR_LC_UCONV	0x72
#define	ERR_LC_STORE	0x73
#define	ERR_LC_STOREDEV	0x74

#define	ERR_LC_CMP		0x90
#define ERR_LC_ASN1CMP	0x91
#define	ERR_LC_SPKAC	0x92

/*-----------------------------------------------
 * define error point
 *---------------------------------------------*/
/* --- */
#define ERR_PT_NON		0x0
/* des */
#define ERR_PT_DES		0x10
#define ERR_PT_3DES		0x20
#define ERR_PT_DESKEY	0x30
#define ERR_PT_DESMODE	0x40
/* rc2 */
#define ERR_PT_RC2		0x10
#define ERR_PT_RC2KEY	0x20
#define ERR_PT_RC2MODE	0x30
/* rc4 */
#define ERR_PT_RC4		0x10
#define ERR_PT_RC4KEY	0x20
/* aes */
#define ERR_PT_AES		0x10
#define ERR_PT_AESKEY	0x20
#define ERR_PT_AESMODE	0x30
/* lnm */
#define ERR_PT_LNMADD	0x10
#define ERR_PT_LNMSUB	0x20
#define ERR_PT_LNMMUL	0x30
#define ERR_PT_LNMDIV	0x40
#define ERR_PT_LNMSQR	0x50
#define ERR_PT_LNMSHF	0x60
#define ERR_PT_LNMSET	0x70
#define ERR_PT_LNMLONG	0x80
#define ERR_PT_LNMSYS	0x90
#define ERR_PT_LNMRAND	0xa0
#define ERR_PT_LNMPRIME	0xb0
#define ERR_PT_LNMSQRT	0xc0
#define ERR_PT_LNMMONT	0xd0
/* ecc */
#define ERR_PT_ECC		0x10
#define ERR_PT_ECCADD	0x20
#define ERR_PT_ECCMUL	0x30
#define ERR_PT_ECCPADD	0x40
#define ERR_PT_ECCPMUL	0x50
#define ERR_PT_ECCTOOL	0x60
#define ERR_PT_ECCCONV	0x70
#define ERR_PT_ECCSTD	0x80
#define ERR_PT_ECCGEN	0x90
#define ERR_PT_ECCVFY	0xa0
#define ERR_PT_ECCASN1	0xb0
/* rand */
#define	ERR_PT_RAND		0x10
#define	ERR_PT_LUTZRAND	0x20
#define	ERR_PT_LUTZSEED	0x30
/* ERR_LC_EDC */
#define	ERR_PT_EDC		0x10
#define	ERR_PT_EDCKEY	0x20
/* ecdsa */
#define ERR_PT_ECDSA	0x10
#define ERR_PT_ECDSAKEY	0x20
#define ERR_PT_ECDSAASN	0x30
/* rsa */
#define ERR_PT_RSA		0x10
#define ERR_PT_RSAKEY	0x20
#define ERR_PT_RSAASN	0x30
#define ERR_PT_RSAPSS	0x40
/* dsa */
#define ERR_PT_DSA		0x10
#define ERR_PT_DSAKEY	0x20
#define ERR_PT_DSAGEN	0x30
#define ERR_PT_DSAASN	0x40
#define ERR_PT_DSASIG	0x50
/* dh */
#define ERR_PT_DH		0x10
#define ERR_PT_DHKEY	0x20
#define ERR_PT_DHASN	0x30
/* modes */
#define ERR_PT_GCMENC	0x10
#define ERR_PT_GCMDEC	0x20

/* asn1 */
#define ERR_PT_ASN1		0x10
#define ERR_PT_ASN1CERT	0x20
#define ERR_PT_ASN1CRL	0x30
#define ERR_PT_ASN1FILE	0x40
#define ERR_PT_ASN1OBJ	0x50
#define ERR_PT_ASN1P7E	0x60
#define ERR_PT_ASN1P7S	0x70
#define ERR_PT_ASN1REQ	0x80
#define ERR_PT_ASN1RSA	0x90
#define ERR_PT_ASN1SET	0xa0
#define ERR_PT_ASN1PRT	0xb0
#define ERR_PT_ASN1P12	0xc0
#define ERR_PT_ASN1EXT	0xd0
#define ERR_PT_ASN1ECC	0xe0
#define ERR_PT_ASN1DSA	0xf0
/* asn1_ */
#define ERR_PT_ASN1DH	0x10
#define ERR_PT_ASN1EXTDEF	0x20
#define ERR_PT_ASN1EXTMOJ	0x30
#define ERR_PT_ASN1CRTP		0x40
#define ERR_PT_ASN1ECDSA	0x50
#define ERR_PT_ASN1ATTR 	0x60
#define ERR_PT_ASN1EXTIP	0x70
#define ERR_PT_ASN1SPKAC	0x80

/* x509 */
#define ERR_PT_X509FILE		0x10
#define ERR_PT_X509TIME		0x20
/* x509-cert */
#define ERR_PT_CERT		0x10
#define ERR_PT_CERTASN1	0x20
#define ERR_PT_CERTEXT	0x30
#define ERR_PT_CERTEXTNS	0x40
#define ERR_PT_CERTEXTSTR	0x50
#define ERR_PT_CERTPRINT	0x60
#define ERR_PT_CERTTOOL	0x70
#define ERR_PT_CERTVFY	0x80

#define ERR_PT_CLIST	0x90
#define ERR_PT_CLFILE	0xa0
#define ERR_PT_CLTOOL	0xb0

#define ERR_PT_CRTP		0xc0
#define ERR_PT_CRTPASN1	0xd0

/* x509-crl */
#define ERR_PT_CRL		0x10
#define ERR_PT_CRLASN1	0x20
#define ERR_PT_CRLEXT	0x30
#define ERR_PT_CRLEXTSTR	0x40
#define ERR_PT_CRLPRINT		0x50
#define ERR_PT_CRLVFY		0x60
/* x509-key */
#define ERR_PT_KEY		0x10
#define ERR_PT_KEYTOOL	0x20
/* x509-ext */
#define ERR_PT_EXTGN	0x10
#define ERR_PT_EXTPOL	0x20
#define ERR_PT_EXTCERT	0x30
#define ERR_PT_EXTCRL	0x40
#define ERR_PT_EXTMS	0x50
#define ERR_PT_EXTMOJ	0x60
#define ERR_PT_ATTRHC	0x70
#define ERR_PT_EXTIP	0x80
/* x509-req */
#define ERR_PT_REQASN1	0x10
#define ERR_PT_REQVFY	0x20

/* pkcs */
#define ERR_PT_PKCS12	0x10
#define ERR_PT_P12ASN1	0x20
#define ERR_PT_P12FILE	0x30
#define ERR_PT_P12KEY	0x40
#define ERR_PT_P12MAC	0x50
#define ERR_PT_P12TOOL	0x60

#define ERR_PT_PKCS7	0x10
#define ERR_PT_P7DATA	0x20
#define ERR_PT_P7ENC	0x30
#define ERR_PT_P7ENV	0x40
#define ERR_PT_P7FILE	0x50
#define ERR_PT_P7SIGN	0x60
#define ERR_PT_P7MASN1	0x70
#define ERR_PT_P7SASN1	0x80
#define ERR_PT_P7SATTR	0x90

#define ERR_PT_PKCS8	0x10
#define ERR_PT_P8FILE	0x20
#define ERR_PT_PBE		0x30
#define ERR_PT_PBECRY	0x40
#define ERR_PT_PBEKEY	0x50
#define ERR_PT_DECINFO	0x60

#define ERR_PT_PKCS11	0x10
#define ERR_PT_P11SESS	0x20
#define ERR_PT_P11TOOL	0x30
#define ERR_PT_P11KEY	0x40

/* pem */
#define ERR_PT_BASE64	0x10
#define	ERR_PT_PEM		0x20
#define ERR_PT_PEMCRY	0x30
#define ERR_PT_PEMMSG	0x40
#define ERR_PT_PEMWRITE	0x50
#define ERR_PT_PEMPKCS	0x60
/* tool */
#define ERR_PT_DIGEST	0x10
#define ERR_PT_SIG		0x20
#define ERR_PT_PASS		0x30
#define ERR_PT_LOCK		0x40
/* wincry */
#define ERR_PT_WINCRY_CERT	0x10
#define ERR_PT_WINCRY_CLIST	0x20
#define ERR_PT_WINCRY_CRL	0x30
#define ERR_PT_WINCRY_KEY	0x40
/* uconv */
#define ERR_PT_UCONV	0x10
#define ERR_PT_UC_JIS	0x20
#define ERR_PT_UC_SJIS	0x30
#define ERR_PT_UC_EUC	0x40
#define ERR_PT_UC_UNI	0x50
#define ERR_PT_UC_UTF8	0x60
/* store */
#define ERR_PT_STORE	0x10
#define ERR_PT_STADD	0x20
#define ERR_PT_STDEL	0x30
#define ERR_PT_STSEARCH	0x40
#define ERR_PT_STTOOL	0x50
#define ERR_PT_MANAGER		0xf0
#define ERR_PT_MANADD		0xe0
#define ERR_PT_MANDEL		0xd0
#define ERR_PT_MANSEARCH	0xc0
#define ERR_PT_MANASN1		0xb0
#define ERR_PT_MANTOOL		0xa0

/* store device */
#define ERR_PT_STFILE	0x10
#define ERR_PT_STFILEMETH	0x20
/* smime */
#define ERR_PT_SMIME_DEC	0x10
#define ERR_PT_SMIME_ENC	0x20
#define ERR_PT_MIME_HEAD	0x30
/* ssl */
#define ERR_PT_SSL			0x10
#define ERR_PT_SSL_BIND		0x20
#define ERR_PT_SSL_CB		0x30
#define ERR_PT_SSL_CS		0x40
#define ERR_PT_SSL_HELLO	0x50
#define ERR_PT_SSL_LIST		0x60
#define ERR_PT_SSL_NAME		0x70
#define ERR_PT_SSL_RAND		0x80
#define ERR_PT_SSL_READ		0x90
#define ERR_PT_SSL_SOCK		0xa0
#define ERR_PT_SSL_TOOL		0xb0
#define ERR_PT_SSL_VFY		0xc0
#define ERR_PT_SSL_WRITE	0xd0

#define ERR_PT_SSLALERT		0x10

#define ERR_PT_SSLHS		0x10
#define ERR_PT_SSLHS_CLNT	0x20
#define ERR_PT_SSLHS_KEY	0x30
#define ERR_PT_SSLHS_SERV	0x40

#define ERR_PT_SSLREC		0x10
#define ERR_PT_SSLREC_PROC	0x20

/* tls */
/* ERR_LC_TLS1 */
#define ERR_PT_TLS			0x10
#define ERR_PT_TLS_ALERT		0x20
#define ERR_PT_TLS_CCS			0x30
#define ERR_PT_TLS_CERT			0x40
/* ERR_PT_TLS_CERT continues to 0x50 */
#define ERR_PT_TLS_CIPHER		0x60
#define ERR_PT_TLS_CIPHER_AEAD		0x70
#define ERR_PT_TLS_CIPHER_BLOCK		0x80
#define ERR_PT_TLS_CIPHER_STREAM	0x90
#define ERR_PT_TLS_COMPAT		0xa0
#define ERR_PT_TLS_COMPRESS		0xb0
#define ERR_PT_TLS_DIGITALLY_SIGNED	0xc0
/* ERR_PT_TLS_DIGITALLY_SIGNED continues to 0xd0 */
#define ERR_PT_TLS_CERT2		0xe0
/* ERR_PT_TLS_CERT2 continues to 0xf0 */

/* ERR_LC_TLS2 */
#define ERR_PT_TLS_HS			0x10
#define ERR_PT_TLS_HS_CS_CLIENT		0x20
#define ERR_PT_TLS_HS_CS_SERVER		0x30
#define ERR_PT_TLS_HS_CS_FINALE		0x40
#define ERR_PT_TLS_HS_MSG_CERT		0x50
/* ERR_PT_TLS_HS_MSG_CERT continues to 0x60 */
#define ERR_PT_TLS_HS_MSG_CERTREQ	0x70
#define ERR_PT_TLS_HS_MSG_CERTVFY	0x80
/* ERR_PT_TLS_HS_MSG_CERTVFY continues to 0x90 */
#define ERR_PT_TLS_HS_MSG_CHELLO	0xa0
/* ERR_PT_TLS_HS_MSG_CHELLO continues to 0xb0 */
#define ERR_PT_TLS_HS_MSG_CKEYEXC	0xc0
#define ERR_PT_TLS_HS_MSG_FINISHED	0xd0
#define ERR_PT_TLS_HS_MSG_HELLOREQ	0xe0

/* ERR_LC_TLS3 */
#define ERR_PT_TLS_HS_MSG_SHELLO	0x10
#define ERR_PT_TLS_HS_MSG_SHELLODONE	0x20
#define ERR_PT_TLS_HS_MSG_SKEYEXC	0x30
#define ERR_PT_TLS_HS_EXT_SIGHASH	0x40
#define ERR_PT_TLS_HS_UTIL_HASH		0x50
#define ERR_PT_TLS_HS_UTIL_MSG		0x60
#define ERR_PT_TLS_HS_UTIL_SIGNATURE	0x70
#define ERR_PT_TLS_HS_EXT_ECC		0x80
/* ERR_PT_TLS_HS_EXT_ECC continues to 0x90 */
#define ERR_PT_TLS_HS_ECDH_ECDH		0xa0
#define ERR_PT_TLS_HS_ECDH_ECDHKEY	0xb0
/* ERR_PT_TLS_HS_ECDH_ECDHKEY continues to 0xc0 */

/* ERR_LC_TLS4 */
#define ERR_PT_TLS_KEY			0x10
#define ERR_PT_TLS_MAC			0x20
#define ERR_PT_TLS_OPT			0x30
#define ERR_PT_TLS_PRF			0x40
#define ERR_PT_TLS_RECORD		0x50
/* ERR_PT_TLS_RECORD continues to 0x60 */
#define ERR_PT_TLS_SESSION		0x70
#define ERR_PT_TLS_SOCKET		0x80
/* ERR_PT_TLS_SOCKET continues to 0x90 */
#define ERR_PT_TLS_STM			0xa0
#define ERR_PT_TLS_UTIL			0xb0

/* ERR_LC_TLS5 */
#define ERR_PT_TLS_HS_EXT_COOKIE	0x00
#define ERR_PT_TLS_HS_EXT_KEYSHARE	0x10
/* ERR_PT_TLS_HS_EXT_KEYSHARE continues to 0x30 */
#define ERR_PT_TLS_HS_EXT_PARSE		0x40
#define ERR_PT_TLS_HS_EXT_SERVERNAME	0x50
/* ERR_PT_TLS_HS_EXT_SERVERNAME continues to 0x60 */
#define ERR_PT_TLS_HS_EXT_SUPPORTED_VERSIONS	0x70
#define ERR_PT_TLS_HS_EXT_SIGHASH2	0x80
/* ERR_PT_TLS_HS_EXT_SIGHASH2 continues to 0x90 */
#define ERR_PT_TLS_HS_CS_CLIENT2	0xa0
/* ERR_PT_TLS_CLIENT2 continues to 0xb0 */
#define ERR_PT_TLS_HS_CS_SERVER2	0xc0
/* ERR_PT_TLS_CLIENT2 continues to 0xd0 */

/* ERR_LC_TLS6 */
#define ERR_PT_TLS_HS_MSG_CERT2		0x10
/* ERR_PT_TLS_HS_MSG_CERT2 continues to 0x20 */
#define ERR_PT_TLS_HS_MSG_CERTREQ2	0x30
#define ERR_PT_TLS_HS_MSG_ENCEXT	0x40
#define ERR_PT_TLS_HS_MSG_KEYUPDATE	0x50
#define ERR_PT_TLS_HS_MSG_MSGHASH	0x60
#define ERR_PT_TLS_HS_MSG_SHELLO2	0x70
#define ERR_PT_TLS_RECORD2			0x80
#define ERR_PT_TLS_KEY2				0x90
/* ERR_PT_TLS_KEY2 continues to 0xa0 */
#define ERR_PT_TLS_CIPHER2			0xb0
#define ERR_PT_TLS_DIGITALLY_SIGNED2	0xc0
#define ERR_PT_TLS_HS_MSG_CHELLO2	0xd0

/* cmp */
#define ERR_PT_PKIMSG		0x10
#define ERR_PT_PKIHEAD		0x20
#define ERR_PT_PKIBODY		0x30
#define ERR_PT_CMP			0x40
#define ERR_PT_PKIBD_ASN	0x50
#define ERR_PT_PKIHD_ASN	0x60
#define ERR_PT_PKIMG_ASN	0x70
#define ERR_PT_CMP_ASN		0x80
#define ERR_PT_PKIBD_ASNSZ	0x90
#define ERR_PT_CMP_ASNSZ	0xa0
/* asn_cmp */
#define ERR_PT_ASN_PKIBD	0x10
#define ERR_PT_ASN_PKIHD	0x20
#define ERR_PT_ASN_CMP		0x30

/* spkac */
#define ERR_PT_SPKAC		0x10
#define ERR_PT_SPKACASN1	0x20
#define ERR_PT_SPKACPRINT	0x30

/*-----------------------------------------------
 * define error state
 *---------------------------------------------*/
/* general errors */
#define ERR_ST_NON				0x0
#define ERR_ST_MEMALLOC			0x1
#define ERR_ST_NULLPOINTER		0x2
#define ERR_ST_BADPARAM			0x3
#define ERR_ST_BADFORMAT		0x4
#define ERR_ST_BADVER			0x5
#define ERR_ST_BADPADDING		0x6
#define ERR_ST_UNMATCHEDPARAM	0x7
#define ERR_ST_STRDUP			0x8
#define ERR_ST_BADSTATE			0x9
#define ERR_ST_UNSUPPORTED_ALGO		0x10
#define ERR_ST_UNSUPPORTED_VER		0x11
#define ERR_ST_UNSUPPORTED_PARAM	0x12
#define ERR_ST_UNSUPPORTED_CODE		0x13
#define ERR_ST_BADNAME			0x14
#define ERR_ST_NULLKEY			0x20
#define ERR_ST_BADKEY			0x21
#define ERR_ST_FILEOPEN			0x30
#define ERR_ST_FILEREAD			0x31
#define ERR_ST_FILEWRITE		0x32
#define ERR_ST_MEMMAP   		0x33
#define ERR_ST_LOADLIB   		0x34
#define ERR_ST_GETPROCADDR		0x35
#define ERR_ST_FILERENAME		0x36


/* lnm */
#define ERR_ST_LNM_BUFOVERFLOW	0x80
#define ERR_ST_LNM_DIVBYZERO	0x81
#define ERR_ST_LNM_NOSQRT		0x82
/* asn1 */
#define ERR_ST_ASN_NOTINTEGER		0x101
#define ERR_ST_ASN_NOTENUMERATED	0x102
#define ERR_ST_ASN_NOTBITSTR		0x103
#define ERR_ST_ASN_NOTOCTETSTR		0x104
#define ERR_ST_ASN_NOTOID			0x105
#define ERR_ST_ASN_NOTPRINTABLESTR	0x106
#define ERR_ST_ASN_NOTUTF8STR		0x107
#define ERR_ST_ASN_NOTT61STR		0x108
#define ERR_ST_ASN_NOTIA5STR		0x109
#define ERR_ST_ASN_NOTBMPSTR		0x10a
#define ERR_ST_ASN_NOTUTCTIME		0x10b
#define ERR_ST_ASN_NOTGENTIME		0x10c
#define ERR_ST_ASN_NOTISO64STR		0x10d
#define ERR_ST_ASN_NOTNUMERICSTR	0x10e
#define ERR_ST_ASN_UNKNOWNOID		0x120
#define ERR_ST_ASN_BADOID			0x121
#define ERR_ST_ASN_NOTASN1			0x122
#define ERR_ST_ASN_NOTBOOLEAN		0x123
#define ERR_ST_ASN_INVALIDLENGTH	0x124
/* pkcs */
#define ERR_ST_P12_BADDEPTH		0x201
#define ERR_ST_P12_NOBAG		0x202
#define ERR_ST_P12_NOCERT		0x203
#define ERR_ST_P12_NOCRL		0x204
#define ERR_ST_P12_NOKEY		0x205
#define ERR_ST_P12_BADMAC		0x206
/* pkcs11 */
#define ERR_ST_GETFUNCLIST		0x220
#define ERR_ST_P11_INIT			0x221
#define ERR_ST_P11_GETINFO		0x222
#define ERR_ST_P11_SLOTLIST		0x223
#define ERR_ST_P11_SLOTINFO		0x224
#define ERR_ST_P11_TKNINFO		0x225
#define ERR_ST_P11_OPENSS		0x226
#define ERR_ST_P11_CLOSESS		0x227
#define ERR_ST_P11_LOGIN		0x228
#define ERR_ST_P11_LOGOUT		0x229
#define ERR_ST_P11_GENKEY		0x22a
#define ERR_ST_P11_GETATTR		0x22b
#define ERR_ST_P11_SETATTR		0x22c
#define ERR_ST_P11_CREOBJ		0x22d
#define ERR_ST_P11_FOBJINIT		0x22e
#define ERR_ST_P11_FOBJCT		0x22f
#define ERR_ST_P11_FOBJFIN		0x230
#define ERR_ST_P11_SIGINIT		0x231
#define ERR_ST_P11_SIGN 		0x232
#define ERR_ST_P11_SIGFIN		0x233
#define ERR_ST_P11_VFYINIT		0x234
#define ERR_ST_P11_VERIFY 		0x235
#define ERR_ST_P11_VFYFIN		0x236
#define ERR_ST_P11_ENCINIT		0x237
#define ERR_ST_P11_ENCRYPT 		0x238
#define ERR_ST_P11_ENCFIN		0x239
#define ERR_ST_P11_DECINIT		0x23a
#define ERR_ST_P11_DECRYPT 		0x23b
#define ERR_ST_P11_DECFIN		0x23c
#define ERR_ST_P11_WRAP 		0x23d
#define ERR_ST_P11_UNWRAP		0x23e
#define ERR_ST_P11_ACTMOFN		0x23f
#define ERR_ST_P11_GETSINFO		0x240

/* rsa */
#define ERR_ST_RSA_MSGTOOLONG		0x251
#define ERR_ST_RSA_ENCODING		0x252
#define ERR_ST_RSA_MSKTOOLONG		0x253
#define ERR_ST_RSA_INCONSISTENT		0x254
/* rand */
#define ERR_ST_RAND_NOPOOL		0x301
#define ERR_ST_RAND_NOTSEEDED	0x302
/* pem */
#define ERR_ST_PEM_BADHEADER	0x6e02
#define ERR_ST_PEM_BADFOOTER	0x6e03
#define ERR_ST_PEM_BADPASSWD	0x6e04
/* tool */
#define ERR_ST_P1_BADPADDING	0x6f00
#define ERR_ST_MUTEXINIT		0x6f10
#define ERR_ST_MUTEXOPEN		0x6f11
#define ERR_ST_MUTEXCLOSE		0x6f12
#define ERR_ST_MUTEXLOCK		0x6f13
#define ERR_ST_MUTEXUNLOCK		0x6f14
#define ERR_ST_MUTEXTMOUT		0x6f15
/* wincry */
#define ERR_ST_WINAPI	0x7000
/* uconv */
#define ERR_ST_UC_BADJISCODE	0x7010
#define ERR_ST_UC_BADUTF8CODE	0x7011
#define ERR_ST_UC_UNKNOWNCODE	0x7012
/* store */
#define ERR_ST_STO_MANAGNOTFOUND	0x7300
#define ERR_ST_STO_STORENOTFOUND	0x7301
#define ERR_ST_STO_BAGNOTFOUND		0x7302
#define ERR_ST_STO_BADMANAG		0x7303
#define ERR_ST_STO_BADSTORE		0x7304
#define ERR_ST_STO_BADBAG		0x7305
#define ERR_ST_STO_BADID		0x7306

/* smime */
#define ERR_ST_MIME_BADHEADER	0x7101
#define ERR_ST_MIME_BADFOOTER	0x7102
/* ssl */
#define ERR_ST_SSL_CLOSE_NOTIFY			0x7201
#define ERR_ST_SSL_UNEXPECTED_MESSAGE	0x7202
#define ERR_ST_SSL_BAD_RECORD_MAC		0x7203
#define ERR_ST_SSL_DECOMPRESSION_FAILURE	0x7204
#define ERR_ST_SSL_HAND_SHAKE_FAILURE	0x7205
#define ERR_ST_SSL_NO_CERT			0x7206
#define ERR_ST_SSL_BAD_CERT			0x7207
#define ERR_ST_SSL_UNSUPPORTED_CERT	0x7208
#define ERR_ST_SSL_CERT_REVOKED		0x7209
#define ERR_ST_SSL_CERT_EXPIRED		0x720a
#define ERR_ST_SSL_CERT_UNKNOWN		0x720b
#define ERR_ST_SSL_ILLEGAL_PARAMETER	0x720c
#define ERR_ST_SSL_WRITE			0x720d
#define ERR_ST_SSL_READ				0x720e
#define ERR_ST_SSL_BADHEADER		0x720f
#define ERR_ST_SSL_BADSIGNATURE		0x7210
#define ERR_ST_SSL_BADFINISHED		0x7211
#define ERR_ST_SSL_CERT_BADSIG		0x7212
#define ERR_ST_SSL_CERT_BADCHAIN	0x7213
#define ERR_ST_SSL_CRL_EXPIRED		0x7214
#define ERR_ST_SSL_CRL_BADSIG		0x7215
#define ERR_ST_SSL_CRL_NOTFOUND		0x7216
#define ERR_ST_SSL_CERT_UNKNOWNCA	0x7217

#define ERR_ST_ACCEPT			0x7221
#define ERR_ST_CONNECT			0x7222
#define ERR_ST_SOCKOPEN			0x7223
#define ERR_ST_SOCKWRITE		0x7224
#define ERR_ST_SOCKREAD			0x7225
#define ERR_ST_SOCKBIND			0x7226
#define ERR_ST_SOCKLISTEN		0x7227
#define ERR_ST_SELECT   		0x7228
#define ERR_ST_SELTIMEOUT		0x7229

#define ERR_ST_BADCERTID		0x7230
#define ERR_ST_BADKEYID			0x7231

/* edc */
enum {
	ERR_ST_EDC_DERIVATION_FAILURE = 0x8000,
	ERR_ST_EDC_ALL_ZERO_VALUE     = 0x8001,
};

/* tls */
enum {
	ERR_ST_TLS_CALLOC                         = 0xf000,
	ERR_ST_TLS_MALLOC                         = 0xf001,
	ERR_ST_TLS_REALLOC                        = 0xf002,
	ERR_ST_TLS_SNPRINTF                       = 0xf003,
	ERR_ST_TLS_STRDUP                         = 0xf004,
	ERR_ST_TLS_SOCKET                         = 0xf005,
	ERR_ST_TLS_CONNECT                        = 0xf006,
	ERR_ST_TLS_TLS_BIND                       = 0xf007,
	ERR_ST_TLS_LISTEN                         = 0xf008,
	ERR_ST_TLS_ACCEPT                         = 0xf009,
	ERR_ST_TLS_PSELECT                        = 0xf00a,
	ERR_ST_TLS_READ                           = 0xf00b,
	ERR_ST_TLS_WRITE                          = 0xf00c,
	ERR_ST_TLS_PSELECT_TIMEOUT                = 0xf00d,
	ERR_ST_TLS_DISCONNECT                     = 0xf00e,
	ERR_ST_TLS_TLS_RECORD_INIT                = 0xf00f,
	ERR_ST_TLS_INIT_RECORD_Q                  = 0xf010,
	ERR_ST_TLS_INIT_HS                        = 0xf011,
	ERR_ST_TLS_TLS_NEW                        = 0xf012,
	ERR_ST_TLS_TLS_DUP                        = 0xf013,
	ERR_ST_TLS_COPY_CERTS                     = 0xf014,
	ERR_ST_TLS_TLS_NULL                       = 0xf015,
	ERR_ST_TLS_UNKNOWN_ALERT_LEVEL            = 0xf016,
	ERR_ST_TLS_INVALID_ALERT_LEVEL            = 0xf017,
	ERR_ST_TLS_INVALID_ALERT_DESC             = 0xf018,
	ERR_ST_TLS_TLS_RECORD_WRITE               = 0xf019,
	ERR_ST_TLS_INVALID_RECORD_LENGTH          = 0xf01a,
	ERR_ST_TLS_INVALID_STATUS                 = 0xf01b,
	ERR_ST_TLS_TLS_CIPHER_PARAM_SET           = 0xf01c,
	ERR_ST_TLS_INVALID_CCS_BODY               = 0xf01d,
	ERR_ST_TLS_P12_CHECK_CHAIN                = 0xf01e,
	ERR_ST_TLS_X509_REVOKED                   = 0xf01f,
	ERR_ST_TLS_X509_NOTBEFORE                 = 0xf020,
	ERR_ST_TLS_X509_NOTAFTER                  = 0xf021,
	ERR_ST_TLS_X509_LASTUPDATE                = 0xf022,
	ERR_ST_TLS_X509_NEXTUPDATE                = 0xf023,
	ERR_ST_TLS_X509_SIGNATURE                 = 0xf024,
	ERR_ST_TLS_X509_SIGNATURE_CRL             = 0xf025,
	ERR_ST_TLS_X509_ISSUER_CRL                = 0xf026,
	ERR_ST_TLS_X509_NOT_IN_CERTLIST           = 0xf027,
	ERR_ST_TLS_X509_SELF_SIGN                 = 0xf028,
	ERR_ST_TLS_X509_NOT_CACERT                = 0xf029,
	ERR_ST_TLS_X509_SYSTEMERR                 = 0xf02a,
	ERR_ST_TLS_CHECK_PKCS12                   = 0xf02b,
	ERR_ST_TLS_P12_READ_FILE                  = 0xf02c,
	ERR_ST_TLS_CERT_SET_BY_PKCS12             = 0xf02d,
	ERR_ST_TLS_STM_FIND                       = 0xf02e,
	ERR_ST_TLS_P12_GET_USERCERT               = 0xf02f,
	ERR_ST_TLS_STM_VERIFY                     = 0xf030,
	ERR_ST_TLS_CHECK_VERIFY_STATUS            = 0xf031,
	ERR_ST_TLS_PKCS12_CLIENT_NULL             = 0xf032,
	ERR_ST_TLS_PKCS12_SERVER_NULL             = 0xf033,
	ERR_ST_TLS_CIPHER_UNSELECT                = 0xf034,
	ERR_ST_TLS_UNKNOWN_CIPHER_TYPE            = 0xf035,
	ERR_ST_TLS_ENCRYPT_STREAM_FAILED          = 0xf036,
	ERR_ST_TLS_ENCRYPT_BLOCK_FAILED           = 0xf037,
	ERR_ST_TLS_ENCRYPT_AEAD_FAILED            = 0xf038,
	ERR_ST_TLS_DECRYPT_STREAM_FAILED          = 0xf039,
	ERR_ST_TLS_DECRYPT_BLOCK_FAILED           = 0xf03a,
	ERR_ST_TLS_DECRYPT_AEAD_FAILED            = 0xf03b,
	ERR_ST_TLS_UNSUPPORT_SSL_OPT_HS_SEPARATE  = 0xf03c,
	ERR_ST_TLS_UNSUPPORT_SSL_OPT_CERTREQOPT_F = 0xf03d,
	ERR_ST_TLS_UNSUPPORT_SSL_OPT_KEEPWBUF     = 0xf03e,
	ERR_ST_TLS_UNKNOWN_COMPRESSION_ALGO       = 0xf03f,
	ERR_ST_TLS_HS_SINGLE                      = 0xf040,
	ERR_ST_TLS_HS_QUEUE_NULL                  = 0xf041,
	ERR_ST_TLS_TLS_RECORD_READ                = 0xf042,
	ERR_ST_TLS_UNKNOWN_HS_TYPE                = 0xf043,
	ERR_ST_TLS_UNEXPECTED_MSG                 = 0xf044,
	ERR_ST_TLS_ASN1_READ_CERT                 = 0xf045,
	ERR_ST_TLS_AICRYPTO_SIG_TYPE              = 0xf046,
	ERR_ST_TLS_BAD_CERT                       = 0xf047,
	ERR_ST_TLS_NOT_RSA_PUB                    = 0xf048,
	ERR_ST_TLS_CERT_KEYENCIPHERMENT           = 0xf049,
	ERR_ST_TLS_UNSUPPORTED_CERT               = 0xf04a,
	ERR_ST_TLS_CERT_FLAG_DIGITALSIGNATURE     = 0xf04b,
	ERR_ST_TLS_P12_MAX_DEPTH                  = 0xf04c,
	ERR_ST_TLS_P12_FIND_BAG                   = 0xf04d,
	ERR_ST_TLS_P12_NEW                        = 0xf04e,
	ERR_ST_TLS_X509_VERSION                   = 0xf04f,
	ERR_ST_TLS_P12_ADD_CERT                   = 0xf050,
	ERR_ST_TLS_UNMATCH_SIGHASH                = 0xf051,
	ERR_ST_TLS_UNSUPPORTED_KEYALGO            = 0xf052,
	ERR_ST_TLS_P12_GET_PRIVATEKEY             = 0xf053,
	ERR_ST_TLS_P12_SIGN_DIGEST                = 0xf054,
	ERR_ST_TLS_INVALID_SIGHASH                = 0xf055,
	ERR_ST_TLS_OK_DO_VERIFY                   = 0xf056,
	ERR_ST_TLS_GET_EPOCHTIME                  = 0xf057,
	ERR_ST_TLS_GET_RANDOM                     = 0xf058,
	ERR_ST_TLS_GET_SESSION                    = 0xf059,
	ERR_ST_TLS_PROTOCOL_VERSION               = 0xf05a,
	ERR_ST_TLS_CET_NO_PUBKEY                  = 0xf05b,
	ERR_ST_TLS_PKCS1_ENCRYPT                  = 0xf05c,
	ERR_ST_TLS_NOT_RSA_PRIV                   = 0xf05d,
	ERR_ST_TLS_PKCS1_DECRYPT                  = 0xf05e,
	ERR_ST_TLS_INVALID_PREMASTER_SECRET       = 0xf05f,
	ERR_ST_TLS_INVALID_DIGEST                 = 0xf060,
	ERR_ST_TLS_READ_BLOCK                     = 0xf061,
	ERR_ST_TLS_INVALID_MAC                    = 0xf062,
	ERR_ST_TLS_INVALID_BLOCK_LENGTH           = 0xf063,
	ERR_ST_TLS_AESKEY_NEW                     = 0xf064,
	ERR_ST_TLS_DES3KEY_NEW                    = 0xf065,
	ERR_ST_TLS_RC4KEY_NEW                     = 0xf066,
	ERR_ST_TLS_INVALID_MAC_LENGTH             = 0xf067,
	ERR_ST_TLS_INVALID_OPT_KEY                = 0xf068,
	ERR_ST_TLS_SESSION_NULL                   = 0xf069,
	ERR_ST_TLS_SESSION_USED                   = 0xf06a,
	ERR_ST_TLS_SESSION_ID_LENGTH              = 0xf06b,
	ERR_ST_TLS_RANDOM_LENGTH                  = 0xf06c,
	ERR_ST_TLS_RAND_BYTES                     = 0xf06d,
	ERR_ST_TLS_RSAPUB_DOCRYPT                 = 0xf06e,
	ERR_ST_TLS_PKCS1_PADDING                  = 0xf06f,
	ERR_ST_TLS_PKCS1_SIZE                     = 0xf070,
	ERR_ST_TLS_STM_FIND_BYNAME                = 0xf071,
	ERR_ST_TLS_STM_CS_GET_KEYHASH             = 0xf072,
	ERR_ST_TLS_STM_CSTORE_FIND_BYKEYHASH      = 0xf073,
	ERR_ST_TLS_STM_CSTORE_GET_KEY             = 0xf074,
	ERR_ST_TLS_STM_GET_PATHCERT               = 0xf075,
	ERR_ST_TLS_STM_FIND_ID                    = 0xf076,
	ERR_ST_TLS_STM_VERIFY_CERT                = 0xf077,
	ERR_ST_TLS_STM_OPEN                       = 0xf078,
	ERR_ST_TLS_INVALID_FRAGMENT_LENGTH        = 0xf079,
	ERR_ST_TLS_INVALID_RECORD_TYPE            = 0xf07a,
	ERR_ST_TLS_NO_RENEGOTIATION               = 0xf07b,
	ERR_ST_TLS_NOT_ECDH_PUB                   = 0xf07c,
	ERR_ST_TLS_UNSUPPORTED_EXTENSION          = 0xf07d,
	ERR_ST_TLS_ECP_NEW                        = 0xf07e,
	ERR_ST_TLS_ECP_MULTI                      = 0xf07f,
	ERR_ST_TLS_FE2OSP                         = 0xf080,
	ERR_ST_TLS_ECPM_GET_STD_PARAMETER         = 0xf081,
	ERR_ST_TLS_ECP_P2OS                       = 0xf082,
	ERR_ST_TLS_ECDSAPUBKEY_NEW                = 0xf083,
	ERR_ST_TLS_ECP_OS2EP                      = 0xf084,
	ERR_ST_TLS_NOT_ECDH_PRIV                  = 0xf085,
	ERR_ST_TLS_UNSUPPORTED_CURVE              = 0xf086,
	ERR_ST_TLS_UNSUPPORTED_CURVE_TYPE         = 0xf087,
	ERR_ST_TLS_ILLEGAL_PARAMETER              = 0xf088,
	ERR_ST_TLS_HANDSHAKE_FAILURE              = 0xf089,
	ERR_ST_TLS_UNRECOGNIZED_NAME              = 0xf08a,
	ERR_ST_TLS_MISSING_EXTENSION              = 0xf08b,
	ERR_ST_TLS_INTERNAL_ERROR                 = 0xf08c,
	ERR_ST_TLS_PROTOCOL_VERSION_DOWNGRADE     = 0xf08d,
	ERR_ST_TLS_CIPHER_LIST_FULL               = 0xf08e,
	ERR_ST_TLS_EMPTY_CERT                     = 0xf08f,
	ERR_ST_TLS_UNSUPPORTED_KEY_EXCHANGE       = 0xf090,
	ERR_ST_TLS_UNSUPPORTED_SIGSCHEME          = 0xf091,
	ERR_ST_TLS_UNSUPPORTED_HASH               = 0xf092,
	ERR_ST_TLS_UNSUPPORTED_SIGNATURE          = 0xf093,
	ERR_ST_TLS_FORBIDDEN_HS_TYPE              = 0xf094,
	ERR_ST_TLS_FORBIDDEN_HASH                 = 0xf095,
	ERR_ST_TLS_FORBIDDEN_SIGSCHEME            = 0xf096,
	ERR_ST_TLS_SAME_TYPE_EXTENSION            = 0xf097,
	ERR_ST_TLS_CHACHAKEY_NEW                  = 0xf098,
	ERR_ST_TLS_X25519_SHARED_SECRET           = 0xf099,
	ERR_ST_TLS_X448_SHARED_SECRET             = 0xf09a,
	ERR_ST_TLS_INVALID_NIST_PUB               = 0xf09b,
	ERR_ST_TLS_INVALID_HKDF_LABEL_LENGTH      = 0xf09c,
	ERR_ST_TLS_INVALID_HKDF_CONTEXT_LENGTH    = 0xf09d,
	ERR_ST_TLS_RECORD_OVERFLOW                = 0xf09e,
	ERR_ST_TLS_CONNECTION_CLOSED              = 0xf09f,
	ERR_ST_TLS_GETADDRINFO                    = 0xf0a0,
	ERR_ST_TLS_SERVER_NAME_NUMHOST            = 0xf0a1,
	ERR_ST_TLS_SERVER_NAME_EMPTY              = 0xf0a2,
	ERR_ST_TLS_SERVER_NAME_INVALID            = 0xf0a3,
	ERR_ST_TLS_SERVER_NAME_TOOLONG            = 0xf0a4,
};

/*
 * functions
 */
/**
 * Set error information.
 *
 * @param[in] info a return value of Cryptoki (PKCS#11).
 */
void OK_set_error(int error, int location, int point, CK_RV *info);
void OK_set_errorlocation(int location,int point);
void OK_clear_error();
uint32_t OK_get_error(); /* XXX:FIXME: should use uint32_t? */
CK_RV *OK_get_errorinfo();
char *OK_get_errstr();

char *get_err_location(int err);
char *get_err_type(int err);

/* print error with "okerr" */
void OK_print_error();

#ifdef  __cplusplus
}
#endif

#endif /* INCLUSION_GUARD_UUID_7859576C_131A_46DF_9D93_09478052A018 */
