/*
 * Copyright (c) 2017 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/index.html.
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */

#ifndef INCLUSION_GUARD_UUID_CAB03080_1436_11E7_A057_0BADDC19702F
#define INCLUSION_GUARD_UUID_CAB03080_1436_11E7_A057_0BADDC19702F

#include <sys/queue.h>

/*
 * Add macro definitions missing in Linux.
 * Based on the implementation at FreeBSD 10.
 */ 
#ifndef TAILQ_FOREACH_SAFE
#define	TAILQ_FOREACH_SAFE(var, head, field, tvar)			\
	for ((var) = TAILQ_FIRST((head));				\
	    (var) && ((tvar) = TAILQ_NEXT((var), field), 1);		\
	    (var) = (tvar))
#endif /* TAILQ_FOREACH_SAFE */

#endif /* INCLUSION_GUARD_UUID_CAB03080_1436_11E7_A057_0BADDC19702F */
