/* nrg_poly1305.h */
/*
 * Copyright (c) 2017 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/index.html.
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */

/**
 * @file nrg_poly1305.h
 * This file defines functions, structures and macros to compute Poly1305.
 **/

#ifndef INCLUSION_GUARD_UUID_152FA16C_B262_11E7_8A3E_772D846B0748
#define INCLUSION_GUARD_UUID_152FA16C_B262_11E7_8A3E_772D846B0748

#include <stdint.h>

#ifdef __cplusplus
extern "C" {
#endif

/**
 * Generating the Poly1305 mac
 *
 * Takes a 32-byte one-time key and a message and produces a 16-byte tag.
 * This tag is used to authenticate the message.
 *
 * For details of implementation, see section 2.5. 'The Poly1305 Algorithm'
 * in RFC7539.
 *
 * @param[in] msg input data.
 * @param[in] bytes length of msg.
 * @param[in] key a 32-byte one-time key.
 * @param[out] tag a buffer for storing the generated 16-byte tag.
 * @ingroup poly1305
 */
void poly1305_mac(const uint8_t *msg, const size_t bytes, const uint8_t *key,
		  uint8_t *tag);

#ifdef  __cplusplus
}
#endif

#endif	/* INCLUSION_GUARD_UUID_152FA16C_B262_11E7_8A3E_772D846B0748 */
