/* md_global.h */
/*
 * Modified by National Institute of Informatics in Japan, 2013-2015.
 *
 */

#ifndef INCLUSION_GUARD_UUID_8A97173B_752C_4B4C_B028_E9BACDB280BB
#define INCLUSION_GUARD_UUID_8A97173B_752C_4B4C_B028_E9BACDB280BB

/*** RFC 1321, section A.1. ***/

/* GLOBAL.H - RSAREF types and constants
 */

/* PROTOTYPES should be set to one if and only if the compiler supports
  function argument prototyping.
  The following makes PROTOTYPES default to 0 if it has not already
  been defined with C compiler flags.
 */
/* NRG: PROTOTYPES is no longer effective. see below. */

#ifndef PROTOTYPES
#define PROTOTYPES 0
#endif

#include <stdint.h>

/* POINTER defines a generic pointer type */
typedef unsigned char *POINTER;

/* UINT2 defines a two byte word */
typedef unsigned short int UINT2;

/* UINT4 defines a four byte word */
typedef uint32_t UINT4;

/* PROTO_LIST is defined depending on how PROTOTYPES is defined above.
If using PROTOTYPES, then PROTO_LIST returns the list, otherwise it
  returns an empty list.
 */
/* NRG: the macro __STDC__ should be used because current compilers do
  not define PROTOTYPES. see also GCC manual, "Prototypes and Old-Style
  Function Definitions".
 */
#if __STDC__
#define PROTO_LIST(list) list
#else
#define PROTO_LIST(list) ()
#endif

/*** end of RFC 1321, A.1. ***/

#endif	/* INCLUSION_GUARD_UUID_8A97173B_752C_4B4C_B028_E9BACDB280BB */
