/* FIPS 197, Appendix C */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <aicrypto/ok_aes.h>

static unsigned char key[] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
	0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
	0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f
};
static unsigned char pt[] = {
	0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77,
	0x88, 0x99, 0xaa, 0xbb, 0xcc, 0xdd, 0xee, 0xff
};
static unsigned char ct[3][16] = {
	{0x69, 0xc4, 0xe0, 0xd8, 0x6a, 0x7b, 0x04, 0x30,
	 0xd8, 0xcd, 0xb7, 0x80, 0x70, 0xb4, 0xc5, 0x5a},
	{0xdd, 0xa9, 0x7c, 0xa4, 0x86, 0x4c, 0xdf, 0xe0,
	 0x6e, 0xaf, 0x70, 0xa0, 0xec, 0x0d, 0x71, 0x91},
	{0x8e, 0xa2, 0xb7, 0xca, 0x51, 0x67, 0x45, 0xbf,
	 0xea, 0xfc, 0x49, 0x90, 0x4b, 0x49, 0x60, 0x89}
};

int test_fips197(void)
{
	Key_AES *aeskey;
	unsigned char c1[16], p1[16];
	int i;

	for (i = 0; i < 3; i++) {
		printf("AES-%d ", 128 + 64 * i);
		aeskey = AESkey_new(16 + 8 * i, key, 16);
		printf("(encrypt -- ");
		AES_ecb_encrypt(aeskey, 16, pt, c1);
		if (memcmp(ct[i], c1, 16) != 0) {
			printf("failed\n");
			return EXIT_FAILURE;
		}
		printf("\b\b\b\b,");
		printf("decrypt -- ");
		AES_ecb_decrypt(aeskey, 16, ct[i], p1);
		if (memcmp(pt, p1, 16) != 0) {
			printf("failed\n");
			return EXIT_FAILURE;
		}
		printf("\b\b\b\b) -- ");
		AESkey_free(aeskey);
		printf("ok\n");
	}
	return EXIT_SUCCESS;
}
