/* aestestfc.c */
/*
 * Modified by National Institute of Informatics in Japan, 2014.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <aicrypto/ok_aes.h>

int test_aes(){
	Key_AES *akey;
	int i,j,k;
	unsigned char c1[32],r1[32];
	unsigned char in[6144],cry[6144],ret[6144];

	unsigned char key[]={
		0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
		0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
		0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
		0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f};
	unsigned char in1[]={
		0xff,0xee,0xdd,0xcc,0xbb,0xaa,0x99,0x88,
		0x77,0x66,0x55,0x44,0x33,0x22,0x11,0x00,
		0xff,0xee,0xdd,0xcc,0xbb,0xaa,0x99,0x88,
		0x77,0x66,0x55,0x44,0x33,0x22,0x11,0x00,
	};
	unsigned char known_c0[]={
		0x0A,0x94,0x0B,0xB5,0x41,0x6E,0xF0,0x45,
		0xF1,0xC3,0x94,0x58,0xC6,0x53,0xEA,0x5A
	};
	unsigned char known_c1[]={
		0x00,0x60,0xBF,0xFE,0x46,0x83,0x4B,0xB8,
		0xDA,0x5C,0xF9,0xA6,0x1F,0xF2,0x20,0xAE
	};
	unsigned char known_c2[]={
		0x5A,0x6E,0x04,0x57,0x08,0xFB,0x71,0x96,
		0xF0,0x2E,0x55,0x3D,0x02,0xC3,0xA6,0x92
	};

	/* known table test (128 bit key) */
	printf("test AES known table (128 bit key) -- ");
	fflush(stdout);
	
	akey = AESkey_new(16,key,16);
	AES_ecb_encrypt(akey,16,key,c1);
	if(memcmp(c1,known_c0,16)){
		printf("error!\n");
		return -1;
	}		
	AES_ecb_decrypt(akey,16,c1,r1);
	if(memcmp(key,r1,16)){
		printf("error!\n");
		return -1;
	}		
	AESkey_free(akey);
	printf("ok\n");

	/* known table test (192 bit key) */
	printf("test AES known table (192 bit key) -- ");
	fflush(stdout);
	
	akey = AESkey_new(24,key,16);
	AES_ecb_encrypt(akey,16,key,c1);
	if(memcmp(c1,known_c1,16)){
		printf("error!\n");
		return -1;
	}		
	AES_ecb_decrypt(akey,16,c1,r1);
	if(memcmp(key,r1,16)){
		printf("error!\n");
		return -1;
	}		
	AESkey_free(akey);
	printf("ok\n");

	/* known table test (256 bit key) */
	printf("test AES known table (256 bit key) -- ");
	fflush(stdout);
	
	akey = AESkey_new(32,key,16);
	AES_ecb_encrypt(akey,16,key,c1);
	if(memcmp(c1,known_c2,16)){
		printf("error!\n");
		return -1;
	}		
	AES_ecb_decrypt(akey,16,c1,r1);
	if(memcmp(key,r1,16)){
		printf("error!\n");
		return -1;
	}		
	AESkey_free(akey);
	printf("ok\n");

	/* simple ecb mode test */
	for(j=16; j<=32; j+=8){
		for(k=16; k<=32; k+=8){
			/* test 128 bit key & 128 bit block */
			printf("test AES(1block) %d bit key & %d bit block -- ",j*8,k*8);
			fflush(stdout);

			akey = AESkey_new(j,key,k);
			AES_ecb_encrypt(akey,k,in1,c1);
			AES_ecb_decrypt(akey,k,c1,r1);

			if(memcmp(in1,r1,k)){
				printf("error!\n");
				for(i=0;i<k;i++) printf("%.2x ",c1[i]); printf("\n");
				for(i=0;i<k;i++) printf("%.2x ",r1[i]); printf("\n");
				return -1;
			}
			printf("ok\n");

			AESkey_free(akey);
		}
	}

	/* long byte test */
	for(j=16; j<=32; j+=8){
		for(k=16; k<=32; k+=8){
			/* test 128 bit key & 128 bit block */
			for(i=0;i<6144;i++) in[i] = rand();

			akey = AESkey_new(j,&in[345],k);
			AES_set_iv(akey,c1);

			printf("test AES(ecb) %d bit key & %d bit block -- ",j*8,k*8);
			fflush(stdout);

			AES_ecb_encrypt(akey,6144,in,cry);
			AES_ecb_decrypt(akey,6144,cry,ret);

			if(memcmp(in,ret,6144)){
				printf("error!\n");
				for(i=0;i<k*4;i++) printf("%.2x ",in[i]);  printf("\n");
				for(i=0;i<k*4;i++) printf("%.2x ",ret[i]); printf("\n");
				return -1;
			}
			printf("ok\n");

			printf("test AES(cbc) %d bit key & %d bit block -- ",j*8,k*8);
			fflush(stdout);

			AES_cbc_encrypt(akey,6144,in,cry);
			AES_cbc_decrypt(akey,6144,cry,ret);

			if(memcmp(in,ret,6144)){
				printf("error!\n");
				for(i=0;i<k*4;i++) printf("%.2x ",in[i]);  printf("\n");
				for(i=0;i<k*4;i++) printf("%.2x ",ret[i]); printf("\n");
				return -1;
			}
			printf("ok\n");

			AESkey_free(akey);
		}
	}
	return 0;
}
