/* aesspeed.c */
/*
 * Copyright (C) 1998-2002
 * Akira Iwata & Takuto Okuno
 * Akira Iwata Laboratory,
 * Nagoya Institute of Technology in Japan.
 *
 * All rights reserved.
 *
 * This software is written by Takuto Okuno(usapato@anet.ne.jp)
 * And if you want to contact us, send an email to Kimitake Wakayama
 * (wakayama@elcom.nitech.ac.jp)
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * 3. All advertising materials mentioning features or use of this software must
 *    display the following acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *    Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *     Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 *   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *   AKIRA IWATA LABORATORY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 *   SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 *   IN NO EVENT SHALL AKIRA IWATA LABORATORY BE LIABLE FOR ANY SPECIAL,
 *   INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
 *   FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 *   NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION
 *   WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <time.h>
#include <sys/types.h>
#include <sys/times.h>

#include "ok_aes.h"

#define TIMES

/* The following if from times(3) man page.  It may need to be changed */
#ifndef HZ
# ifndef CLK_TCK
#  ifndef _BSD_CLK_TCK_ /* FreeBSD hack */
#   define HZ   100.0
#  else /* _BSD_CLK_TCK_ */
#   define HZ ((double)_BSD_CLK_TCK_)
#  endif
# else /* CLK_TCK */
#  define HZ ((double)CLK_TCK)
# endif
#endif

#define START   0
#define STOP    1

static double Time_F(int s){
    double ret;
#ifdef TIMES
    static struct tms tstart,tend;

    if (s == START)
    {
	times(&tstart);
	return(0);
    }
    else
    {
	times(&tend);
	ret=((double)(tend.tms_utime-tstart.tms_utime))/HZ;
	return((ret < 1e-3)?1e-3:ret);
    }
#else /* !times() */
    static destruct timeb tstart,tend;
    long i;

    if (s == START)
    {
	ftime(&tstart);
	return(0);
    }
    else
    {
	ftime(&tend);
	i=(long)tend.millitm-(long)tstart.millitm;
	ret=((double)(tend.time-tstart.time))+((double)i)/1000.0;
	return((ret < 0.001)?0.001:ret);
    }
#endif
}


int main(int argc,char **argv){
	unsigned char key[]={
		0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
		0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
		0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
		0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f};

	unsigned char in[6144],cry[6144],ret[6144];
	int i,j,k;
	double tm;
	Key_AES *akey;

	/* test j*8 bit key & k*8 bit block */
	for(i=0;i<6144;i++) in[i] = rand();

	printf("----------AES-SPEED-TEST----------\n");
	for(j=16; j<=32; j+=8){
		for(k=16; k<=32; k+=8){

			akey = AESkey_new(j,&in[345],k);
			AES_set_iv(akey,&in[44]);

			/* AES ecb mode encryption */
			Time_F(START);
			for(i=0;i<400;i++){
				AES_ecb_encrypt(akey,6144,in,cry);
			}
			tm=Time_F(STOP);
			i = (int)(((double)2400)/tm); /* 2400 = (6144*400)/1024 */
			printf("AES %d bit key & %d bit block ecb-encryption   -> %d KB/s\n",j*8,k*8,i);


			/* AES ecb mode decryption */
			Time_F(START);
			for(i=0;i<400;i++){
				AES_ecb_decrypt(akey,6144,cry,ret);
			}
			tm=Time_F(STOP);
			i = (int)(((double)2400)/tm); /* 2400 = (6144*400)/1024 */
			printf("AES %d bit key & %d bit block ecb-decryption   -> %d KB/s\n",j*8,k*8,i);

			/* AES ecb mode encryption */
			Time_F(START);
			for(i=0;i<400;i++){
				AES_cbc_encrypt(akey,6144,in,cry);
			}
			tm=Time_F(STOP);
			i = (int)(((double)2400)/tm); /* 2400 = (6144*400)/1024 */
			printf("AES %d bit key & %d bit block cbc-encryption   -> %d KB/s\n",j*8,k*8,i);


			/* AES ecb mode decryption */
			Time_F(START);
			for(i=0;i<400;i++){
				AES_cbc_decrypt(akey,6144,cry,ret);
			}
			tm=Time_F(STOP);
			i = (int)(((double)2400)/tm); /* 2400 = (6144*400)/1024 */
			printf("AES %d bit key & %d bit block cbc-decryption   -> %d KB/s\n",j*8,k*8,i);

			AESkey_free(akey);
		}
	}
	return 0;
}



