/* aesgcmtestfc.c */
/*
 * Copyright (c) 2016 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/index.html.
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <aicrypto/nrg_modes.h>
#include <aicrypto/ok_aes.h>

#include "../modes/aesgcm_testvec.h"

typedef struct GCMNonce{
	uint8_t salt[4];
	uint8_t nonce_explicit[8];
} GCMNonce_t;

#define TEST_OK(label, n)	printf("test AES gcm %s -- OK : %d\n", label, n);
#define TEST_NG(label, n)	printf("test AES gcm %s -- NG : %d\n", label, n);
#define TEST_ERROR(label, n)	printf("test AES gcm %s -- error! : %d\n", label, n);

int test_vec_01();
int test_vec_02();
int test_vec_03();
int test_vec_04();
int test_vec_05();
int test_vec_06();
int test_vec_07();
int test_vec_08();
int test_vec_09();
int test_vec_10();

int test_vec_11();
int test_vec_12();
int test_vec_13();
int test_vec_14();
int test_vec_15();
int test_vec_16();
int test_vec_17();
int test_vec_18();

#define TEST_C(label)\
	GCMNonce_t nonce;\
	gcm_param_t gcm_param;\
	Key_AES *key;\
\
	key = AESkey_new(sizeof(K), K, 16);\
\
	gcm_param_set_key(&gcm_param, (Key *) key);\
	if (sizeof(IV) == sizeof(GCMNonce_t)) {\
		memcpy(nonce.salt, &IV[0], 4);\
		memcpy(nonce.nonce_explicit, &IV[4], 8);\
		gcm_param_set_iv(&gcm_param, &nonce, sizeof(GCMNonce_t));\
	} else {\
		gcm_param_set_iv(&gcm_param, IV, sizeof(IV));\
	}\
	gcm_param_set_aad(&gcm_param, A, sizeof(A));\
\
	/* encrypt */\
	uint8_t dest[sizeof(P) + sizeof(T)];\
	AES_gcm_encrypt(&gcm_param, sizeof(P), P, dest);\
\
	if (memcmp(dest, C, sizeof(C)) == 0) {\
		TEST_OK(label, 1);\
	} else {\
		TEST_NG(label, 1);\
	}\
	if (memcmp(dest + sizeof(C), T, sizeof(T)) == 0) {\
		TEST_OK(label, 2);\
	} else {\
		TEST_NG(label, 2);\
	}\
\
	/* decrypt */\
	uint8_t src[sizeof(C) + sizeof(T)];\
	memcpy(src, C, sizeof(C));\
	memcpy(src+sizeof(C), T, sizeof(T));\
\
	AES_gcm_decrypt(&gcm_param, sizeof(src), src, dest);\
\
	if (memcmp(dest, P, sizeof(P)) == 0) {\
		TEST_OK(label, 3);\
	} else {\
		TEST_NG(label, 3);\
	}\
\
	AESkey_free(key);\
	gcm_param.ciph_key = NULL;

/**
 * gcm-test-vectors/vec-01.txt
 */
int test_vec_01()
{
	AESGCM_TEST_VEC_01;

	TEST_C("vec_01");

	return 0;
}
/**
 * gcm-test-vectors/vec-02.txt
 */
int test_vec_02()
{
	AESGCM_TEST_VEC_02;

	TEST_C("vec_02");

	return 0;
}
/**
 * gcm-test-vectors/vec-03.txt
 */
int test_vec_03()
{
	AESGCM_TEST_VEC_03;

	TEST_C("vec_03");

	return 0;
}
/**
 * gcm-test-vectors/vec-04.txt
 */
int test_vec_04()
{
	AESGCM_TEST_VEC_04;

	TEST_C("vec_04");

	return 0;
}
/**
 * gcm-test-vectors/vec-05.txt
 */
int test_vec_05()
{
	AESGCM_TEST_VEC_05;

	TEST_C("vec_05");

	return 0;
}
/**
 * gcm-test-vectors/vec-06.txt
 */
int test_vec_06()
{
	AESGCM_TEST_VEC_06;

	TEST_C("vec_06");

	return 0;
}
/**
 * gcm-test-vectors/vec-07.txt
 */
int test_vec_07()
{
	AESGCM_TEST_VEC_07;

	TEST_C("vec_07");

	return 0;
}
/**
 * gcm-test-vectors/vec-08.txt
 */
int test_vec_08()
{
	AESGCM_TEST_VEC_08;

	TEST_C("vec_08");

	return 0;
}
/**
 * gcm-test-vectors/vec-09.txt
 */
int test_vec_09()
{
	AESGCM_TEST_VEC_09;

	TEST_C("vec_09");

	return 0;
}
/**
 * gcm-test-vectors/vec-10.txt
 */
int test_vec_10()
{
	AESGCM_TEST_VEC_10;

	TEST_C("vec_10");

	return 0;
}
/**
 * gcm-test-vectors/vec-11.txt
 */
int test_vec_11()
{
	AESGCM_TEST_VEC_11;

	TEST_C("vec_11");

	return 0;
}
/**
 * gcm-test-vectors/vec-12.txt
 */
int test_vec_12()
{
	AESGCM_TEST_VEC_12;

	TEST_C("vec_12");

	return 0;
}
/**
 * gcm-test-vectors/vec-13.txt
 */
int test_vec_13()
{
	AESGCM_TEST_VEC_13;

	TEST_C("vec_13");

	return 0;
}
/**
 * gcm-test-vectors/vec-14.txt
 */
int test_vec_14()
{
	AESGCM_TEST_VEC_14;

	TEST_C("vec_14");

	return 0;
}
/**
 * gcm-test-vectors/vec-15.txt
 */
int test_vec_15()
{
	AESGCM_TEST_VEC_15;

	TEST_C("vec_15");

	return 0;
}
/**
 * gcm-test-vectors/vec-16.txt
 */
int test_vec_16()
{
	AESGCM_TEST_VEC_16;

	TEST_C("vec_16");

	return 0;
}
/**
 * gcm-test-vectors/vec-17.txt
 */
int test_vec_17()
{
	AESGCM_TEST_VEC_17;

	TEST_C("vec_17");

	return 0;
}
/**
 * gcm-test-vectors/vec-18.txt
 */
int test_vec_18()
{
	AESGCM_TEST_VEC_18;

	TEST_C("vec_18");

	return 0;
}
