/* aissview.c */
/*
 * Copyright (c) 2004-2012 National Institute of Informatics in Japan, 
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/index.html.
 * If you redistribute this file, with or without modifications, you must 
 * include this notice in the file.
 */
/*
 * Copyright (C) 1998-2004
 * Akira Iwata & Takuto Okuno
 * Akira Iwata Laboratory,
 * Nagoya Institute of Technology in Japan.
 *
 * All rights reserved.
 *
 * This software is written by Takuto Okuno(usapato@anet.ne.jp)
 * And if you want to contact us, send an email to Kimitake Wakayama
 * (wakayama@elcom.nitech.ac.jp)
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *        this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *        this list of conditions and the following disclaimer in the documentation
 *        and/or other materials provided with the distribution.
 *
 * 3. All advertising materials mentioning features or use of this software must
 *        display the following acknowledgment:
 *        "This product includes software developed by Akira Iwata Laboratory,
 *        Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *        acknowledgment:
 *        "This product includes software developed by Akira Iwata Laboratory,
 *     Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 *   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *   AKIRA IWATA LABORATORY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 *   SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 *   IN NO EVENT SHALL AKIRA IWATA LABORATORY BE LIABLE FOR ANY SPECIAL,
 *   INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
 *   FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 *   NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION
 *   WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */
#include "aiconfig.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#ifdef __WINDOWS__
# include <io.h>
#else
# include <signal.h>
#endif

#include "ok_rand.h"
#include "ok_asn1.h"
#include "ok_pem.h"
#include "ok_tool.h"
#include "ok_uconv.h"

#include "ok_ca.h"
#include "ok_lcmp.h"
#include "ok_aica.h"

#ifndef AICONFIG
#define AICONFIG "aica.cnf"
#endif

char sespath[256];

/* functions */
void options(int argc,char **argv);
void usage();

char *get_modestr(int i){
  char *ret;

  switch(i){
  case 1: ret="ENL_NEWISS"; break;
  case 2: ret="ENL_WAITISS"; break;
  case 3: ret="ENL_WAITGET"; break;
  case 4: ret="ENL_ISSDONE"; break;
  case 5: ret="ENL_REJECTED"; break;
  case 6: ret="ENL_AUTHERR"; break;
  case 7: ret="ENL_REVOKED"; break;
  case 8: ret="ENL_NOPIN"; break;
  case 9: ret="ENL_WAITUPD"; break;
  default:ret="NOT defined"; break;
  }
  return ret;
}

/* common/version.c */
void print_version(char *argv[]);


/*-------------------------------------------------
        begin aissview main
-------------------------------------------------*/
int main(int argc,char **argv){
  FILE *fp=NULL;
  struct stat sbuf;
  AccList acc;
  char session[WEB_SSBLOCK];
  struct tm *stm;
  int i,j,ret=-1;

  options(argc,argv);

  if((fp=fopen(sespath,"rb+"))==NULL){
    OK_set_error(ERR_ST_FILEOPEN,ERR_LC_ENR,ERR_PT_ENR,NULL);
    /* FIXME: should print an appropriate message.
     * maybe, someone should hack aicrypto/tool/error.c (get_err_location,
     * get_err_type). */
    goto done;
  }
  if(fstat(fileno(fp),&sbuf)){
    OK_set_error(ERR_ST_FILEREAD,ERR_LC_ENR,ERR_PT_ENR,NULL);
    goto done;
  }

  for(i=0;;i++){
    memset(session,0,WEB_SSBLOCK);

    if(WEB_SSBLOCK*(i+1)>sbuf.st_size) break;
    if(fgetpos(fp,&acc.pos)) break;
    if(fread(session,sizeof(char),WEB_SSBLOCK,fp)<WEB_SSBLOCK) break;

    memcpy(acc.name,&session,64);	/* 64 */
    memcpy(acc.cn, &session[64],64);	/* 128 */
    memcpy(acc.pwd,&session[128],64);	/* 192 */
    memcpy(acc.group,&session[192],64);	/* 256 */
    memcpy(acc.email,&session[256],64);	/* 320 */
    memcpy(&acc.mode,&session[320],4);	/* 324 */
    memcpy(&acc.acceptID,&session[324],4);	/* 328 */
    memcpy(&acc.serialNum,&session[328],4);	/* 332 */
    memcpy(&acc.containerTime,&session[332],4);	/* 336 */
    memcpy(acc.sessionID,&session[336],8);	/* 344 */
    memcpy(acc.keyID,&session[344],20);		/* 364 */
    memcpy(&acc.isstype,&session[364],4);	/* 368 */
    memcpy(&acc.notAfter,&session[368],SIZEOF_TIME_T); /* 372|376 */

#ifdef __WINDOWS__
	{
		time_t tt = (time_t)acc.notAfter;
		stm=(struct tm*)gmtime((time_t*)&tt);
	}
#else
    stm=(struct tm*)gmtime((time_t*)&acc.notAfter);
#endif

    /* print out access info */
    printf(">>>>>>>> NO.%.7d >>>>>>>>\n",i);
    printf("name  : %s\n",acc.name);
    printf("cn    : %s\n",acc.cn);
    printf("pwd   : %s\n",acc.pwd);
    printf("group : %s\n",acc.group);
    printf("email : %s\n",acc.email);
    printf("mode  : %s (%d)\n",get_modestr(acc.mode),acc.mode);
    printf("acceptID   : %d\n",acc.acceptID);
    printf("serialNum  : %d\n",acc.serialNum);
    printf("containerTime : %d\n",acc.containerTime);
    printf("sessionID  : "); for(j=0; j<8; j++) printf("%.2x ",(unsigned char)acc.sessionID[j]);
    printf("\nkeyID      : "); for(j=0; j<20; j++) printf("%.2x ",acc.keyID[j]);
    printf("\nisstype    : %.8x\n",acc.isstype);
    printf("notAfter   : %s (0x%.8x)\n\n",stm2str(stm,3),acc.notAfter);
  }

  ret = 0;
done:
  if(fp) fclose(fp);
  return ret;
}

/*-----------------------------------------
  usage and option check
-----------------------------------------*/
void options(int argc,char **argv){
  char *cp = NULL;
  int i;

  if(argc<2) goto usage;

  /* check options or arguments */
  for(i=1;i<argc;i++){
    if(!strcmp("-version",argv[i])){
      print_version(argv);
      exit(EXIT_SUCCESS);
    }else if(!strcmp("-help",argv[i])){
      usage();
      exit(EXIT_SUCCESS);
    }else if(argv[i][0] == '-') {
      printf("option error!\n");
      printf("unknown option: `%s'\n", argv[i]);
      goto usage;
    }else{
      strncpy(sespath,argv[i],254);
    }
  }

  return;
usage:
  usage();
  exit(EXIT_FAILURE);
}

void usage(){
  printf("\
Usage: aissview [OPTION] FILE\n\
\n\
Option:\n\
  -help		print this message\n\
  -version	print version information and exit\n\
\n\
FILE is a session file, like `sessions.0'.\n\
");
}
