/* airad_ra.c */
/*
 * Copyright (c) 2004-2014 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */
/*
 * Copyright (C) 1998-2004
 * Akira Iwata & Takuto Okuno
 * Akira Iwata Laboratory,
 * Nagoya Institute of Technology in Japan.
 *
 * All rights reserved.
 *
 * This software is written by Takuto Okuno(usapato@anet.ne.jp)
 * And if you want to contact us, send an email to Kimitake Wakayama
 * (wakayama@elcom.nitech.ac.jp)
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *	  this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *	  this list of conditions and the following disclaimer in the documentation
 *	  and/or other materials provided with the distribution.
 *
 * 3. All advertising materials mentioning features or use of this software must
 *	  display the following acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *    Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *     Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 *   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *   AKIRA IWATA LABORATORY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 *   SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 *   IN NO EVENT SHALL AKIRA IWATA LABORATORY BE LIABLE FOR ANY SPECIAL,
 *   INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
 *   FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 *   NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION
 *   WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef HAVE_NETDB_H
#include <netdb.h>
#endif

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>

#ifdef HAVE_ARPA_INET_H
#include <arpa/inet.h>
#endif

#include <signal.h>

#include <aicrypto/ok_err.h>
#include <aicrypto/ok_rand.h>
#include <aicrypto/ok_uconv.h>

#include "ok_aica.h"
#include "ok_aimsg.h"

int loop = 0;
LCMP *lcm = NULL;

/* static error handling */
extern char peer[];
extern int sesid;

/*-------------------------------------------------
  begin airad main
-------------------------------------------------*/
int RAd_main(RAdConf *cf, RAdRegInfo *reg, SSL *s){
	/* CertProf *cpf=NULL; *//* XXX:currently unused. */
	LCMP *to_sv=NULL,*fr_cl=NULL; /* to server & from client */
	int ok=-1;
	char buf[256];

	/* initialize */
	if(RAd_log_open(cf)) goto done; /* this error cause memory leak of "s" */
	RAd_log_connection(s);

	/* signal set for unloop */
	signal(SIGINT, RAd_sig);
	signal(SIGHUP, RAd_sig);
	signal(SIGTERM, RAd_sig);

	if((fr_cl=LCMP_new())==NULL) goto done;
	fr_cl->sock = s;
	fr_cl->sessionId = sesid;
	fr_cl->transactionId = 0;
	
	/* if SSL mode, do handshake here */
	if(cf->f_usessl){
		if(SSL_handshake(s)){
			RADERRLOG(fr_cl,AIMSG_RAERR_SSLHS,1,NULL);
			goto done;
	}}

	/* operation loop */
	loop = 1;
	do{
		OK_clear_error();
		fr_cl->transactionId++;

		if(LCMP_read(fr_cl)<0){
			if(OK_get_error()==0) /* connection closed */
				RADERRLOG(fr_cl,AIMSG_ERR_RDCLOSE,0,NULL);
			else
				RADERRLOG(fr_cl,AIMSG_ERR_READ,1,NULL);
			goto done;
		}
		
		if(fr_cl->op==NULL){ /* DER decoding error */
			RADERRLOG(fr_cl,AIMSG_ERR_DECODE,1,NULL);
			
			if((fr_cl->op=LCMP_get_response(LCMP_OP_UNBIND,LCMP_PROTOCOL_ERR,"bad Protocol format"))==NULL){
				RADERRLOG(fr_cl,AIMSG_ERR_ENCODE,1,NULL);
				goto done;
			}
			loop = -1;
			
		}else{
			printf("get operation (%d)\n",fr_cl->op->opId);
			switch(fr_cl->op->opId){
			case LCMP_OP_BINDREQ:
				if(RAd_op_bindreq(cf,reg,fr_cl,&to_sv)<0) loop=-1;
				break; /* close */
			case LCMP_OP_UNBIND:
				loop = 0;
				break; /* close */
			case LCMP_OP_SIGNREQ:
				if(RAd_op_signreq(cf,reg,fr_cl,to_sv)<0) loop=1;
				break;
			case LCMP_OP_CERTREQ:
				if(RAd_op_certreq(cf,reg,fr_cl,to_sv)<0) loop=1;
				break;
			case LCMP_OP_LISTREQ:
				if(RAd_op_listreq(cf,reg,fr_cl,to_sv)<0) loop=1;
				break;
			case LCMP_OP_RENEWALREQ:
				if(RAd_op_renewalreq(cf,reg,fr_cl,to_sv)<0) loop=1;
				break;

			/* these are not supported on RA server */
			case LCMP_OP_CSRREQ:
			case LCMP_OP_CRLREQ:
			case LCMP_OP_PROFREQ:
			case LCMP_OP_SVOPREQ:
			case LCMP_OP_EXTREQ:

			case LCMP_OP_BINDRSP:
			case LCMP_OP_SIGNRSP:
			case LCMP_OP_LISTRSP:
			case LCMP_OP_PROFRSP:
			case LCMP_OP_CERTRSP:
			case LCMP_OP_CRLRSP:
			case LCMP_OP_SVOPRSP:
			case LCMP_OP_EXTRSP:
			case LCMP_OP_RENEWALRSP:
			default: /* bad operation code */
				sprintf(buf,"lcmp : bad operation code : %d",fr_cl->op->opId);
				if((fr_cl->op=LCMP_get_response(LCMP_OP_UNBIND,LCMP_UNSUPPORTED_OP,buf))==NULL){
					RADERRLOG(fr_cl,AIMSG_ERR_ENCODE,1,buf);
					goto done;
				}
				loop=-1;
				break;
			}
		}

		if(loop){
			/* send response */
			if(LCMP_write(fr_cl)<0){
				RADERRLOG(fr_cl,AIMSG_ERR_WRITE,1,NULL);
				goto done;
			}
		}
		LCMP_op_free(fr_cl->op); fr_cl->op=NULL;
		if(to_sv){ LCMP_op_free(to_sv->op); to_sv->op=NULL; }
		
	}while(loop>0);

	ok=0;
done:
	snprintf(buf,256,"%s (%d)",AIMSG_RAEND,ok);
	RADACCLOG(fr_cl,buf,0,NULL);
	
	if(to_sv){
		SSL_close(to_sv->sock);
		LCMP_free(to_sv); lcm = NULL;
	}
	if(fr_cl){
		SSL_close(fr_cl->sock);
		LCMP_free(fr_cl); lcm = NULL;
	}
	RAd_log_close();

	RAND_cleanup();
	free_u2j_table();

	return ok;
}

int RAd_log_connection(SSL *s){
	memset(peer,0,128);
	rad_get_peername(SSL_get_fd(s),peer,126);
	
	RADACCLOG(NULL,AIMSG_RASTART,0,NULL);	
	return 0;
}

int rad_get_peername(int sock, char *ret, int max){
	char peername[NI_MAXHOST];
	struct sockaddr_storage sa;
	int sa_len = sizeof(sa);
	
	strncpy(ret,"unknown",max);
	
	if(getpeername(sock,(struct sockaddr *)&sa,&sa_len)<0) return 0; /* error */

	if(getnameinfo((struct sockaddr *)&sa,sa_len,peername,sizeof(peername),NULL,0,0)==0){
		strncpy(ret,peername,max);
	}
	return 0;
}

/*------------------------------------------------*/
void RAd_sig(){
    if(lcm && !lcm->op){
		/* waiting for client response, so close socket. */ 
		SSL_close(lcm->sock);
    }
    loop = 0;
}

/*-------------------------------------------------
	AiCAd get registered RA index number
-------------------------------------------------*/
int RAd_get_regnum(RAdRegInfo *reg,char *raname){
	int i;

	for(i=0; i<MAXCA; i++){
		if(!strcmp(reg[i].raname,raname)) return i;
	}
	return -1;
}

