/* airad_conf.c */
/*
 * Copyright (c) 2004-2014 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */
/*
 * Copyright (C) 1998-2004
 * Akira Iwata & Takuto Okuno
 * Akira Iwata Laboratory,
 * Nagoya Institute of Technology in Japan.
 *
 * All rights reserved.
 *
 * This software is written by Takuto Okuno(usapato@anet.ne.jp)
 * And if you want to contact us, send an email to Kimitake Wakayama
 * (wakayama@elcom.nitech.ac.jp)
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * 3. All advertising materials mentioning features or use of this software must
 *    display the following acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *    Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *     Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 *   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *   AKIRA IWATA LABORATORY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 *   SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 *   IN NO EVENT SHALL AKIRA IWATA LABORATORY BE LIABLE FOR ANY SPECIAL,
 *   INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
 *   FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 *   NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION
 *   WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "ok_aica.h"
#include "ok_conf.h"
#include "afi_utils.h"

/* exported function */
void afxstopmessage(char *msg);

/*-----------------------------------------
  read CAd config file
-----------------------------------------*/
int RAd_read_config(char *fname, RAdConf *cf, RAdRegInfo *reg){
	char *buf,begin[64],end[64];
	int i,err=-1;

	/* get store information */
	if((buf=conf_get_section(fname,"[general info]","[general info end]"))==NULL) goto done;
	if(conf_getstr(buf,"store_dir",cf->store,254)) goto done;
	free(buf); buf=NULL;

	/* get RA server information */
	if((buf=conf_get_section(fname,"[RAd]","[RAd end]"))==NULL) goto done;
	if(rad_set_config(buf,cf)) goto done;
	free(buf); buf=NULL;

	/* get Registerd RA information */
	for(i=0; i<MAXCA; i++){
		snprintf(begin,64,"[RAd RegInfo %d]",i);
		snprintf(end,64,"[RAd RegInfo %d end]",i);
		if((buf=conf_get_section(fname,begin,end))==NULL) break;
		if(rad_set_reginfo(buf,&reg[i])) goto done;
		free(buf); buf=NULL;
	}

	err = 0;
done:
	if(buf) free(buf);
	return err;
}

int rad_set_config(char *buf, RAdConf *cf){
	char *tmp,*cp;
	int i,v1=0,v2=0;

	/* get configuration info */
	if(conf_getstr(buf,"sv_id",cf->sv_id,126)) goto error;
	if(conf_getstr(buf,"sv_id_pwd",cf->sv_p12_passwd,PWD_BUFLEN*2)) goto error;
	if(conf_getstr(buf,"sv_p12",cf->sv_p12,126)) goto error;
	if(conf_getstr(buf,"sv_p12_pwd",cf->sv_p12_passwd,PWD_BUFLEN*2)) goto error;

	tmp = cf->sv_p12_passwd;
	if(*tmp && strstr(tmp,"$aicry${")){
		if((cp=strchr(tmp,'}'))==NULL) goto error;
		*cp = 0;
		if((tmp=aica_decry_passwd(&tmp[8]))==NULL) goto error;
		strcpy(cf->sv_p12_passwd,tmp);
		free(tmp);
	}
	
	if(conf_getint(buf,"sv_port",&cf->port)) goto error;
	if(conf_getint(buf,"sv_listen",&cf->listen)) goto error;
	if(conf_getint(buf,"sv_ssl_recon",&cf->ssl_recon)) goto error;

	if(conf_getbool(buf,"f_ssl_use",&cf->f_usessl)) goto error;
	if(conf_getbool(buf,"f_ssl_reqcert",&v1)) goto error;
	if(conf_getbool(buf,"f_ssl_optreq",&v2)) goto error;
	if(v2) cf->f_certreq = SSL_OPT_CERTREQOPT;
	if(v1) cf->f_certreq = SSL_OPT_CERTREQ;

	if(conf_getbool(buf,"f_ssl_novfy",&v1)) goto error;
	if(conf_getbool(buf,"f_ssl_novfycrl",&v2)) goto error;

	if(v2) cf->f_vfycert = IF_NO_CRL_DONT_CHECK_REVOKED | DONT_VERIFY_CRL;
	if(v1) cf->f_vfycert = DONT_VERIFY;

	if(conf_getint(buf,"ssl_timeout",&i)) goto error;
	SSL_set_timeout(i*1000);

	if(conf_getstr(buf,"errlog",cf->errlog,126)) goto error;
	if(conf_getstr(buf,"isslog",cf->isslog,126)) goto error;
	if(conf_getstr(buf,"acclog",cf->acclog,126)) goto error;

	/* v1.0 has typo bug, so bug fixed (lotate -> rotate).
	 * but old aica.cnf may have lotate items. version compatibility
	 * should be considered.
	 */
	if(conf_getint(buf,"errlog_lotate",&cf->errlog_rotate)) goto error;
	if(conf_getint(buf,"isslog_lotate",&cf->isslog_rotate)) goto error;
	if(conf_getint(buf,"acclog_lotate",&cf->acclog_rotate)) goto error;
	
	if(conf_getint(buf,"errlog_rotate",&cf->errlog_rotate)) goto error;
	if(conf_getint(buf,"isslog_rotate",&cf->isslog_rotate)) goto error;
	if(conf_getint(buf,"acclog_rotate",&cf->acclog_rotate)) goto error;

	return 0;
error:
	return -1;
}

int rad_set_reginfo(char *buf, RAdRegInfo *cf){
	char grp[256],tag[32],*tmp,*cp;
	int i,v1,v2;

	memset(grp,0,256);

	/* get configuration info */
	if(conf_getstr(buf,"raname",cf->raname,62)) goto error;
	if(conf_getstr(buf,"rapath",cf->rapath,254)) goto error;

	if(conf_getstr(buf,"ca_dir",cf->svname,126)) goto error;
	if(conf_parse_svpath(cf->svname,cf->svname,128,cf->caname,64)!=CONF_PARSE_SVPATH_PARSE_SUCCESS) goto error;

	if(conf_getstr(buf,"ca_uid",cf->userid,30)) goto error;
	if(conf_getint(buf,"ca_port",&cf->caport)) goto error;
	if(conf_getstr(buf,"ca_pwd",cf->cl_pwd,62)) goto error;

	if(conf_getbool(buf,"f_ssl_use",&cf->usessl)) goto error;
	if(conf_getbool(buf,"f_ssl_novfy",&v1)) goto error;
	if(conf_getbool(buf,"f_ssl_novfycrl",&v2)) goto error;

	if(v2) cf->vfycert = IF_NO_CRL_DONT_CHECK_REVOKED | DONT_VERIFY_CRL;
	if(v1) cf->vfycert = DONT_VERIFY;

	if(conf_getstr(buf,"cl_id",cf->cl_id,62)) goto error;
	if(conf_getstr(buf,"cl_id_pwd",cf->cl_pwd,PWD_BUFLEN*2)) goto error;

	tmp = cf->cl_pwd;
	if(*tmp && strstr(tmp,"$aicry${")){
		if((cp=strchr(tmp,'}'))==NULL) goto error;
		*cp = 0;
		if((tmp=aica_decry_passwd(&tmp[8]))==NULL) goto error;
		strcpy(cf->cl_pwd,tmp);
		free(tmp);
	}

	/* group check */
	for(i=0; i<MAXGROUP; i++){
		sprintf(tag,"groupname.%d",i); *grp = 0;
		if(conf_getstr(buf,tag,grp,30)) goto error;
		if(*grp == 0) break;
		if ((cf->grpname[i] = strdup(grp)) == NULL) goto error;

		sprintf(tag,"groupprof.%d",i); *grp = 0;
		if(conf_getstr(buf,tag,grp,30)) goto error;
		if(*grp){
			if ((cf->grpprof[i] = strdup(grp)) == NULL) goto error;
		}

		sprintf(tag,"groupemail.%d",i); *grp = 0;
		if(conf_getstr(buf,tag,grp,126)) goto error;
		if(*grp){
			if ((cf->grpemail[i] = strdup(grp)) == NULL) goto error;
		}

		sprintf(tag,"groupbase.%d",i); *grp = 0;
		if(conf_getstr(buf,tag,grp,254)) goto error;
		if(*grp){
			if ((cf->grpbase[i] = strdup(grp)) == NULL) goto error;
		}

		sprintf(tag,"grouphost.%d",i); *grp = 0;
		if(conf_getstr(buf,tag,grp,254)) goto error;
		if(*grp){
			if ((cf->grphost[i] = strdup(grp)) == NULL) goto error;
		}

		sprintf(tag,"groupbind.%d",i); *grp = 0;
		if(conf_getstr(buf,tag,grp,254)) goto error;
		if(*grp){
			if ((cf->grpbind[i] = strdup(grp)) == NULL) goto error;
		}

		sprintf(tag,"groupbindpwd.%d",i); *grp = 0;
		if(conf_getstr(buf,tag,grp,254)) goto error;
		if(*grp){
			if(strstr(grp,"$aicry${")){
				if((cp=strchr(grp,'}'))==NULL) goto error;
				*cp = 0;
				if((tmp=aica_decry_passwd(&grp[8]))==NULL) goto error;
				strcpy(grp,tmp);
				free(tmp); tmp = NULL;
			}
			if ((cf->grpbindpwd[i] = strdup(grp)) == NULL) goto error;
		}
	}

	/* post / offline ca mode */
	if(conf_getbool(buf,"post_mode",&cf->postmode)) goto error;
        if(conf_getbool(buf,"offline_ca_mode",&cf->offlineca)) goto error;

	/* user authntication */
	if(conf_getint(buf,"authmode",&cf->authmode)) goto error;
	if(conf_getstr(buf,"wwwsessions",cf->sesspath,254)) goto error;
	if(conf_getstr(buf,"wwwpwd",cf->pwdpath,254)) goto error;
	if(conf_getstr(buf,"wwwlicense",cf->lidpath,254)) goto error;
	if (conf_getstr(buf, "lang", cf->ldaplang, 3)) goto error;
	if(conf_getstr(buf,"ldap_host",cf->ldaphost,254)) goto error;
	cf->ldaplogin = (*cf->ldaphost && (cf->authmode!=AI_RA_AUTH_ANON))?(1):(0);
	if(conf_getstr(buf,"ldap_base",cf->ldapbase,254)) goto error;
	if(conf_getint(buf,"ldap_port",&cf->ldapport)) goto error;
	if(conf_getint(buf,"ldap_bind",&cf->ldapbind)) goto error;
	if(conf_getstr(buf,"ldap_user_attr",cf->uidattr,64)) goto error;
	if(conf_getstr(buf,"ldap_license_attr",cf->lidattr,64)) goto error;
	if(conf_getstr(buf,"ldap_pin_attr",cf->pinattr,64)) goto error;
	if(conf_getstr(buf,"ldap_uquery_attr",cf->uquattr,64)) goto error;

	if(conf_getstr(buf,"ldap_admin",cf->ldapadmin,254)) goto error;
	if(conf_getstr(buf,"ldap_admin_pwd",cf->ldapadminpwd,PWD_BUFLEN*2)) goto error;

	if(conf_getstr(buf,"ldap_student_attr",cf->stuattr,64)) goto error;
	if(conf_getstr(buf,"ldap_coop_attr",cf->coopattr,64)) goto error;
	if(conf_getbool(buf,"iccard_err_check",&cf->cardchk)) goto error;
	if(conf_getbool(buf,"ldap_sch_rawlid",&cf->rawlid)) goto error;

	tmp = cf->ldapadminpwd;
	if(*tmp && strstr(tmp,"$aicry${")){
		if((cp=strchr(tmp,'}'))==NULL) goto error;
		*cp = 0;
		if((tmp=aica_decry_passwd(&tmp[8]))==NULL) goto error;
		strcpy(cf->ldapadminpwd,tmp);
		free(tmp);
	}

	/* grid info */
	if(conf_getstr(buf,"gridcertpath",cf->gridcert,254)) goto error;
	
	/* email */
	if(conf_getstr(buf,"smtp_host",cf->smtphost,254)) goto error;
	if(conf_normalize_host(cf->smtphost)!=CONF_NORMALIZE_HOST_PARSE_SUCCESS) goto error;
	if(conf_getstr(buf,"web_address",cf->webhost,254)) goto error;
	if(conf_getstr(buf,"admin_email",cf->admemail,126)) goto error;
	if(conf_getint(buf,"smtp_port",&cf->smtpport)) goto error;
	if (conf_getstr(buf, "smtp_from", cf->smtpfrom, 126)) goto error;

	if(conf_getint(buf,"email_sbjfilter",&cf->emsbjfilter)) goto error;

        return 0;
error:
        return -1;
}
