/* aicrl_op.c */
/*
 * Copyright (c) 2004-2014 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/index.html.
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */
/*
 * Copyright (C) 1998-2004
 * Akira Iwata & Takuto Okuno
 * Akira Iwata Laboratory,
 * Nagoya Institute of Technology in Japan.
 *
 * All rights reserved.
 *
 * This software is written by Takuto Okuno(usapato@anet.ne.jp)
 * And if you want to contact us, send an email to Kimitake Wakayama
 * (wakayama@elcom.nitech.ac.jp)
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * 3. All advertising materials mentioning features or use of this software must
 *    display the following acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *    Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *     Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 *   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *   AKIRA IWATA LABORATORY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 *   SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 *   IN NO EVENT SHALL AKIRA IWATA LABORATORY BE LIABLE FOR ANY SPECIAL,
 *   INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
 *   FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 *   NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION
 *   WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <aicrypto/ok_err.h>
#include <aicrypto/ok_pem.h>

#include "ok_caerr.h"
#include "ok_aica.h"

extern char svpath[];
extern char outpath[];
extern char pushurl[];
extern int cop;

extern char ldaphost[];
extern char basedn[];

extern char crl_attr[];
extern char crl_prof[];
extern char arl_attr[];
extern char arl_prof[];


int CApub_cl_crl(LCMP *lc){
	LO_CRLRsp *lo = NULL;
	char *pf[4] = {"CRL","ARL","CRL-All",""};
	char buf[256];
	int i,pnum=3;

	for(i=0; i<pnum; i++){
		if((lc->op=LCMP_get_crlreq(cop,pf[i],LCMP_LCCRL_TOCLIENT,NULL))==NULL) goto error;
	
		if(LCMP_write(lc)<0) goto error;
		LCMP_op_free(lc->op); lc->op=NULL;

		/* wait a response from CA */
		if(LCMP_read(lc)<0) goto error;
		if((lo=(LO_CRLRsp*)lc->op)==NULL) goto error;
		if(lc->op->resultCode != LCMP_SUCCESS) goto error;

		if(lc->op->opId != LCMP_OP_CRLRSP){
			OK_set_error(ERR_ST_INVALIDRSP,ERR_LC_CRLP,ERR_PT_CRLPOP,NULL);
			goto error;
		}

		/* check returned CRL */
		if((lo->list==NULL)||(lo->list->crl==NULL)){
			OK_set_error(ERR_ST_NULLPOINTER,ERR_LC_CRLP,ERR_PT_CRLPOP,NULL);
			goto error;
		}
#if defined(HAVE_LDAP_H) && defined(HAVE_LIBLDAP)
		if(*ldaphost){
			strncpy(buf,basedn,216);
			
			if(!strcmp(pf[i],crl_prof)){
				if(CApub_ldap_crlout(lo->list->crl,crl_attr)) goto error;
			}else if(!strcmp(pf[i],arl_prof)){
				if(CApub_ldap_crlout(lo->list->crl,arl_attr)) goto error;
			}else{
				strcpy(buf,"no output");
			}
			strcat (buf," << ");
			strcat (buf,pf[i]);
			
		}else
#endif /* HAVE_LDAP_H */
		{
			if(*outpath){
				strncpy(buf,outpath,216);
				strcat (buf,"/");
			}else{
				strcpy(buf,"");
			}
			strcat (buf,"out-");
			strcat (buf,pf[i]);
			strcat (buf,".crl");

			if(PEM_write_crl(lo->list->crl,buf)) goto error;
		}
		if(*pushurl){
			if(!strcmp(pf[i],"CRL-All")){
				if(CApub_web_crlout(lo->list->crl)) goto error;
			}
		}
		LCMP_op_free(lc->op); lc->op=NULL;

		/* output log */
		CRPISSLOG(svpath,buf);
	}
	
	return 0;
error:
	return -1;
}


