/* aicrl_conf.c */
/*
 * Copyright (c) 2004-2016 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */
/*
 * Copyright (C) 1998-2004
 * Akira Iwata & Takuto Okuno
 * Akira Iwata Laboratory,
 * Nagoya Institute of Technology in Japan.
 *
 * All rights reserved.
 *
 * This software is written by Takuto Okuno(usapato@anet.ne.jp)
 * And if you want to contact us, send an email to Kimitake Wakayama
 * (wakayama@elcom.nitech.ac.jp)
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * 3. All advertising materials mentioning features or use of this software must
 *    display the following acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *    Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *     Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 *   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *   AKIRA IWATA LABORATORY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 *   SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 *   IN NO EVENT SHALL AKIRA IWATA LABORATORY BE LIABLE FOR ANY SPECIAL,
 *   INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
 *   FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 *   NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION
 *   WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <aicrypto/ok_err.h>
#include <aicrypto/ok_asn1.h>

#include "ok_caerr.h"
#include "ok_aica.h"
#include "ok_conf.h"

/* general info */
char ctstore[256]= "";

char capath[256] = ".";
char svpath[256] = "";
char outpath[256]= ".";
char pushurl[256]= "";
char clcert[256] = "";
char clctpw[PWD_BUFLEN*2] = "";

char certid[32]  = "";
char userid[32]  = "";
char pwd[PWD_BUFLEN*2] = "";

char ldaphost[128] = "";
char basedn[256]   = "";
char binddn[256]   = "";
char bindpw[PWD_BUFLEN*2] = "";
char addomain[256] = "";
char crl_attr[64]  = "certificateRevocationList;binary";
char crl_prof[32]  = "CRL-All";
char arl_attr[64]  = "authorityRevocationList;binary";
char arl_prof[32]  = "ARL";

int cop      = 0;
int ldapport = 389, sasl = 0;
int usessl   = 0;
int caport   = 11411;
int vfycert  = 0;
int interval = 3600*24;
int updchk   = 0;
int section  = 0;
time_t start = 0;
time_t end   = 0;

char isslog[256] = "";
char errlog[256] = "";

int errlog_size  = 256;
int isslog_size  = 256;


/*-----------------------------------------
  set CA configure
-----------------------------------------*/
int CApub_read_config(char *fname){
	char *buf,begin[64],end[64];
	int err=-1;

	/* get store information */
	if((buf=conf_get_section(fname,"[general info]","[general info end]"))==NULL) goto done;
	if(conf_getstr(buf,"store_dir",ctstore,254)) goto done;
	free(buf); buf=NULL;

	/* get CRL publisher info */
	snprintf(begin,64,"[CRL Publisher %d]",section);
	snprintf(end,64,"[CRL Publisher %d end]",section);
	if((buf=conf_get_section(fname,begin,end))==NULL) {
		fprintf(stderr, "[CRL Publisher %d]: No such section\n", section);
		goto done;
	}
	conf_clear_comment(buf);

	printf("reading section %d ... ", section);
	err = capub_set_config(buf);
	if (0 == err)
		printf("done.\n");
	else
		printf("failed.\n");
done:
	if(buf) free(buf);
	return err;
}

int capub_set_config(char *buf){
	unsigned char der[64];
	int v1=0,v2=0,exp=0;
	char *cp,*tmp=NULL;

	if(conf_getstr(buf,"ca_dir",capath,254)) goto error;
	if(conf_getstr(buf,"ca_uid",userid,30)) goto error;
	if(conf_getint(buf,"ca_port",&caport)) goto error;
	if(conf_getstr(buf,"ca_pwd",pwd,PWD_BUFLEN*2)) goto error;
        if(*pwd && strstr(pwd,"$aicry${")){
		if((cp=strchr(pwd,'}'))==NULL) goto error;
		*cp = 0;
		if((tmp=aica_decry_passwd(&pwd[8]))==NULL) goto error;
		strcpy(pwd,tmp);
		free(tmp);
	}

	if(conf_getstr(buf,"out_dir",outpath,254)) goto error;
	if(conf_getstr(buf,"push_url",pushurl,254)) goto error;

	if(conf_getint(buf,"interval",&interval)) goto error;
	if(conf_getint(buf,"upd_chk_interval",&updchk)) goto error;
	if(conf_getbool(buf,"f_exp_mode",&exp)) goto error;
	if(exp) cop = LCMP_OPCRL_GETLTS;
	
	memset(der,0,64);
	if(conf_getstr(buf,"tm_start",&der[2],30)) goto error;
	if(der[2]){
		der[0] = ASN1_GENERALIZEDTIME;
		der[1] = (char)strlen((char*)&der[2]);
		if((start=UTC2time_t(der))<0) goto error;
	}
	memset(der,0,64);
	if(conf_getstr(buf,"tm_end",&der[2],30)) goto error;
	if(der[2]){
		der[0] = ASN1_GENERALIZEDTIME;
		der[1] = (char)strlen((char*)&der[2]);
		if((end=UTC2time_t(der))<0) goto error;
	}
	if(conf_getbool(buf,"f_ssl_use",&usessl)) goto error;
	if(conf_getbool(buf,"f_ssl_novfy",&v1)) goto error;
	if(conf_getbool(buf,"f_ssl_novfycrl",&v2)) goto error;

	if(v2) vfycert = IF_NO_CRL_DONT_CHECK_REVOKED | DONT_VERIFY_CRL;
	if(v1) vfycert = DONT_VERIFY;

	if(conf_getstr(buf,"cl_id",certid,32)) goto error;
	if(conf_getstr(buf,"cl_id_pwd",clctpw,PWD_BUFLEN*2)) goto error;
	if(conf_getstr(buf,"cl_p12",clcert,254)) goto error;
	if(conf_getstr(buf,"cl_p12_pwd",clctpw,PWD_BUFLEN*2)) goto error;
        if(*clctpw && strstr(clctpw,"$aicry${")){
		if((cp=strchr(clctpw,'}'))==NULL) goto error;
		*cp = 0;
		if((tmp=aica_decry_passwd(&clctpw[8]))==NULL) goto error;
		strcpy(clctpw,tmp);
		free(tmp);
	}
	if(conf_getstr(buf,"ldap_host",ldaphost,126)) goto error;
	if(conf_getint(buf,"ldap_port",&ldapport)) goto error;
	if(conf_getint(buf,"ldap_sasl",&sasl)) goto error;
	if(conf_getstr(buf,"ldap_base",basedn,254)) goto error;
	if(conf_getstr(buf,"ldap_bind",binddn,254)) goto error;
	if(conf_getstr(buf,"ldap_ad_domain",addomain,254)) goto error;
	if(conf_getstr(buf,"ldap_pwd",bindpw,PWD_BUFLEN*2)) goto error;
        if(*bindpw && strstr(bindpw,"$aicry${")){
		if((cp=strchr(bindpw,'}'))==NULL) goto error;
		*cp = 0;
		if((tmp=aica_decry_passwd(&bindpw[8]))==NULL) goto error;
		strcpy(bindpw,tmp);
		free(tmp);
	}
	if(conf_getbool(buf,"f_ldap_sasl",&sasl)) goto error;
	
	if(conf_getstr(buf,"ld_crl_attr",crl_attr,62)) goto error;
	if(conf_getstr(buf,"ld_crl_prof",crl_prof,30)) goto error;
	if(conf_getstr(buf,"ld_arl_attr",arl_attr,62)) goto error;
	if(conf_getstr(buf,"ld_arl_prof",arl_prof,30)) goto error;
	
	if(conf_getstr(buf,"isslog",isslog,126)) goto error;
	if(conf_getstr(buf,"errlog",errlog,126)) goto error;

	/* v1.0 has typo bug, so bug fixed (lotate -> rotate).
	 * but old aica.cnf may have lotate items. version compatibility
	 * should be considered.
	 */
	if(conf_getint(buf,"isslog_lotate",&isslog_size)) goto error;
	if(conf_getint(buf,"errlog_lotate",&errlog_size)) goto error;

	if(conf_getint(buf,"isslog_rotate",&isslog_size)) goto error;
	if(conf_getint(buf,"errlog_rotate",&errlog_size)) goto error;

	if(strstr(capath,":")) strncpy(svpath,capath,254);

	return 0;
error:
	return -1;
}
