/* aiconfop.c */
/*
 * Copyright (c) 2004-2016 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */
/*
 * Copyright (C) 1998-2004
 * Akira Iwata & Takuto Okuno
 * Akira Iwata Laboratory,
 * Nagoya Institute of Technology in Japan.
 *
 * All rights reserved.
 *
 * This software is written by Takuto Okuno(usapato@anet.ne.jp)
 * And if you want to contact us, send an email to Kimitake Wakayama
 * (wakayama@elcom.nitech.ac.jp)
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * 3. All advertising materials mentioning features or use of this software must
 *    display the following acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *    Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *     Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 *   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *   AKIRA IWATA LABORATORY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 *   SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 *   IN NO EVENT SHALL AKIRA IWATA LABORATORY BE LIABLE FOR ANY SPECIAL,
 *   INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
 *   FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 *   NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION
 *   WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <aicrypto/ok_rand.h>
#include <aicrypto/ok_tool.h>

#include "ok_conf.h"

#ifndef LOGDIR
#define LOGDIR	"/usr/local/naregi-ca/log"
#warning "using the default value of LOGDIR, \"/usr/local/naregi-ca/log\""
#endif

/* global value */
extern char name[];
extern char pass[];
extern char path[];
extern char rapath[];
extern char sec[];
extern char item[];
extern char value[];

extern int op;
extern int type;
extern int enc;
extern int mode;

/*----------------------------------------------------------
  config file utilities
-----------------------------------------------------------*/
int _aiconf_get_section(char *in, char *section, char **bp, char **ep)
{
	char buf[64];

	snprintf(buf, 62, "[%s]", section);
	if ((*bp = strstr(in,buf)) == NULL) goto error;

	snprintf(buf, 62, "[%s end]", section);
	if ((*ep = strstr(*bp,buf)) == NULL) goto error;

	return 0;
error:
	return -1;
}

int aiconf_get_section(char *in, char *section, char **bp, char **ep)
{
	int ret;
	if((ret = _aiconf_get_section(in, section, bp, ep)))
		fprintf(stderr, "error: cannot get specified section: %s\n",
			section);
	return ret;
}

int aiconf_get_item(char *section, char *item, char **bp, char **vp, char **ve, char **np){
  char *hd = section;
  char tmp;
  int ok = -1;

  while(ok && hd && *hd){
    *ve = conf_get_line(hd,np,&tmp);
    if(*hd != '#'){
      if((*bp=conf_comp_item(hd,item)) != NULL){
	if((*vp=strchr(*bp,'=')) != NULL){ (*vp)++; ok = 0; } /* break */
      }
    }
    **ve = tmp; hd = *np;
  }

  return ok;
}

int aiconf_print_item(char *buf) /* actually print the value of the item. */
{
	char value[64] = ""; /* 64 -> CONF_?_MAX */
	int ret = -1;

	ret = conf_getstr(buf, item, value, 63); /* 63 -> CONF_?_MAX -1 */
	/*
	 * XXX: the current conf_getstr() always returns 0...
	 */
	if (value[0] == '\0') {
		fprintf(stderr, "error: cannot get specified item: %s\n", item);
		ret = -1; /* will be removed if conf_getstr() is improved */
		goto done;
	} else {
		printf("%s", value);
		/*
		 * this format is required for aisetup.sh, etc.
		 * then, the following is NOT suitable.
		 *
		 * printf("[%s]\n%s=%s\n",sec,item,vp);
		 */
	}
	ret = 0;
done:
	return ret;
}

char *aiconf_write_item(char *buf, int mode){
  /* mode | if the item exists | if the item does not exist
   *   0      overwrite            add
   *   1      overwrite            (do nothing)
   *   2      (do nothing)         add
   * FIXME: replace figures with appropriate macros.
   */
  char tmp,*sbp,*sep,*bp,*np,*vp,*ve,*ret=NULL;
  char line[280],*cry=NULL;
  int len = strlen(buf);

  if(aiconf_get_section(buf,sec,&sbp,&sep)) goto done;
  tmp = *sep; *sep = 0;

  if(enc){
    if((cry=aica_encry_passwd(value))==NULL) goto done;
    snprintf(line,278,"%s\t=$aicry${%s}\n",item,cry);
  }else{
    snprintf(line,278,"%s\t=%s\n",item,value);
  }

  if((ret=malloc(len+320))==NULL) goto done;
  memset(ret,0,len+320);

  if(!aiconf_get_item(sbp,item,&bp,&vp,&ve,&np)){
    switch (mode) {
    case 0:
    case 1:
      *sep = tmp; *bp = 0;
      strcpy(ret,buf);
      strcat(ret,line);
      strcat(ret,np);
      break;
    case 2:
    default:
      *sep = tmp;
      strcpy(ret,buf);
      break;
    }
  }else{
    switch (mode) {
    case 0:
    case 2:
      strcpy(ret,buf);
      strcat(ret,line);
      strcat(ret,"[");
      strcat(ret,sep+1);
      break;
    case 1:
    default:
      *sep = tmp;
      strcpy(ret,buf);
      break;
    }
  }

done:
  if(cry) free(cry);
  return ret;
}

char *aiconf_del_item(char *buf){
  char tmp,*sbp,*sep,*bp,*np,*vp,*ve,*ret=NULL;
  int len = strlen(buf);

  if(aiconf_get_section(buf,sec,&sbp,&sep)) goto done;
  tmp = *sep; *sep = 0;

  if((ret=malloc(len+2))==NULL) goto done;
  memset(ret,0,len+2);

  if(!aiconf_get_item(sbp,item,&bp,&vp,&ve,&np)){
    *sep = tmp; *bp = 0;
    strcpy(ret,buf);
    strcat(ret,np);
  }else{
    *sep = tmp;
    strcpy(ret,buf);
  }

done:
  return ret;
}

#define RANDSIZE 1024
#define SALTSIZE 64
char *aiconf_set_salt_val(char *buf) {
  char rand[RANDSIZE], salt[SALTSIZE];
  long i;
  int j, k = 0;

  strcpy(sec, "general info");
  strcpy(item, "salt_val");

  i = random();
  
  RAND_init();
  RAND_add(rand, RANDSIZE, 0.0);
  RAND_add(&i, sizeof(i), sizeof(i));
  RAND_bytes(rand, RANDSIZE);

  for (j = 0; j < RANDSIZE; j++) {
    if (k > SALTSIZE - 2) break;
    /* print PrintableString except `"', `(', `)', '/', '?', ' ' */
    if((('0' <= rand[j]) && (rand[j] <= '9')) ||
       (('A' <= rand[j]) && (rand[j] <= 'Z')) ||
       (('a' <= rand[j]) && (rand[j] <= 'z')) ||
       (rand[j] == '+') || (rand[j] == ',') || (rand[j] == '-') ||
       (rand[j] == '.') || (rand[j] == ':')) {
      salt[k] = rand[j];
      k++;
    }
  }
  salt[k] = '\0';
  RAND_cleanup();
  strcpy(value, salt);

  return aiconf_write_item(buf, 2);
}

char *aiconf_add_ca(char *buf){
  char tmp,t2,*sbp,*sep,*bp,*np,*vp,*ve,*t,*ret=NULL;
  char line[280],*cry=NULL;
  int i,len = strlen(buf);

  if(aiconf_get_section(buf,"CAd",&sbp,&sep)) goto done;
  tmp = *sep; *sep = 0; np=NULL;

  for(i=0; i<128; i++){
    /* find last number & last line */
    sprintf(item,"caname.%d",i);
    if(aiconf_get_item(sbp,item,&bp,&vp,&ve,&t)) break;
    np = t; t2 = *ve; *ve = 0;

    if(!strcmp(name,vp)){
      printf("error : specified ca is already registered : %s\n",name);
      goto done;
    }
    *ve = t2;

    sprintf(item,"capwd.%d",i);
    aiconf_get_item(sbp,item,&bp,&vp,&ve,&np);
  }

  if((ret=malloc(len+400))==NULL) goto done;
  memset(ret,0,len+400);

  /* register new CA info */
  *sep = tmp; 
  if(!np){
    ve = conf_get_line(sbp,&np,&tmp);
    *ve = tmp;
  }
  tmp = *np; *np = 0;
  strcpy(ret,buf);
  if (i != 0) strcat(ret,"\n"); /* no newline is inserted at first. */
  *np = tmp;

  snprintf(line,278,"capath.%d\t=%s\n",i,path);
  strcat(ret,line);

  snprintf(line,278,"caname.%d\t=%s\n",i,name);
  strcat(ret,line);

  if(enc){
    if((cry=aica_encry_passwd(pass))==NULL) goto done;
    snprintf(line,278,"capwd.%d\t=$aicry${%s}\n",i,cry);
  }else{
    snprintf(line,278,"capwd.%d\t=%s\n",i,pass);
  }
  strcat(ret,line);
  strcat(ret,np);

  printf("success to register a CA : %s\n",name);
done:
  if(cry) free(cry);
  return ret;
}

char *aiconf_del_ca(char *buf){
  char tmp,*sbp,*sep,*bp,*np,*vp,*ve,*t,*ret=NULL;
  char line[280];
  int i,j,find=-1,len = strlen(buf);

  struct ca_reg{
    char capath[256];
    char caname[32];
    char capwd[PWD_BUFLEN*2];
  } regca[128];
  

  if(aiconf_get_section(buf,"CAd",&sbp,&sep)) goto done;
  tmp = *sep; *sep = 0; np = sbp;

  memset(&regca,0,sizeof(struct ca_reg)*32);

  for(i=0; i<128; i++){
    sprintf(item,"capath.%d",i);
    if(aiconf_get_item(np,item,&bp,&vp,&ve,&t)) break;
    *bp = *ve = 0; np = t;
    strncpy(regca[i].capath,vp,254);

    sprintf(item,"caname.%d",i);
    if(aiconf_get_item(np,item,&bp,&vp,&ve,&np)) break;
    *bp = *ve = 0;
    strncpy(regca[i].caname,vp,30);

    if(!strcmp(name,vp)){ find = i; }

    sprintf(item,"capwd.%d",i);
    if(!aiconf_get_item(np,item,&bp,&vp,&ve,&np)){
      *bp = *ve = 0;
      strncpy(regca[i].capwd,vp,PWD_BUFLEN*2);
    }
  }

  if(find < 0){
    printf("error : cannot unregister specified CA : %s\n",name);
    goto done;
  }
  
  if((ret=malloc(len))==NULL) goto done;
  memset(ret,0,len);

  *sep = tmp;
  strcpy(ret,buf);
  for(i=j=0; i<32; i++,j++){
    if(i != find){
      if(*regca[i].capath == 0) break;

      snprintf(line,278,"capath.%d\t=%s\n",j,regca[i].capath);
      strcat(ret,line);

      snprintf(line,278,"caname.%d\t=%s\n",j,regca[i].caname);
      strcat(ret,line);

      snprintf(line,278,"capwd.%d\t=%s\n\n",j,regca[i].capwd);
      strcat(ret,line);
    }else{
      j--;
    }
  }
  strcat(ret,np);

  printf("success to unregister a CA : %s\n",name);
done:
  return ret;
}

char *aiconf_add_crl(char *buf){
  char tmp,*sbp,*sep,*bp,*np,*ve,*ret=NULL;
  char secbuf[2048],*cry=NULL;
  int i,len = strlen(buf);

  for(sbp=sep=NULL,i=0; i<128; i++){
    sprintf(sec,"CRL Publisher %d",i);
    if(_aiconf_get_section(buf,sec,&bp,&np)) break;
    sbp = bp; sep = np;
  }

  strcpy (secbuf,"#########################################################\n");
  strcat (secbuf,"## \"aicrlpub\" local or remote CRL publisher configuration\n");
  strcat (secbuf,"[");
  strcat (secbuf,sec);
  strcat (secbuf,"]\nca_dir\t=");
  strncat(secbuf,path,254);
  strcat (secbuf,"\nca_port\t=11411\n");
  strcat (secbuf,"ca_uid\t=caadmin\nca_pwd\t=");
  if(enc){
    if((cry=aica_encry_passwd(pass))==NULL) goto done;
    strcat (secbuf,"$aicry${");
    strncat(secbuf,cry,126);
    strcat (secbuf,"}");
  }else{
    strncat(secbuf,pass,PWD_BUFLEN);
  }
  strcat (secbuf,"\n\ninterval\t=3600\n");
  strcat (secbuf,"upd_chk_interval\t=0\n");
  strcat (secbuf,"f_exp_mode\t=false\n\n");

  strcat (secbuf,"out_dir\t=");
  strncat(secbuf,path,254);
  strcat (secbuf,"\n#push_url\t=http://localhost/RANAME/aicrlupload?Op=Upload");

  strcat (secbuf,"\n\n#cl_id\t=\n#cl_id_pwd\t=\n\n");
  strcat (secbuf,"#f_ssl_use\t=true\n#f_ssl_novfy\t=true\n\n");

  strcat (secbuf,"#ldap_host    =localhost\n");
  strcat (secbuf,"#ldap_port    =389\n");
  strcat (secbuf,"#ldap_base    =ou=testca,o=org,c=JP\n");
  strcat (secbuf,"#ldap_bind    =cn=manager\n");
  strcat (secbuf,"#ldap_pwd     =abcde\n");
  strcat (secbuf,"#ld_crl_attr  =certificateRevocationList;binary\n");
  strcat (secbuf,"#ld_crl_prof  =CRL-All\n");
  strcat (secbuf,"#ld_arl_attr  =authorityRevocationList;binary\n");
  strcat (secbuf,"#ld_arl_prof  =ARL\n\n");

  strcat (secbuf,"errlog\t=");
  strncat(secbuf,LOGDIR,254);
  strcat (secbuf,"/pub_error.log\nisslog\t=");
  strncat(secbuf,LOGDIR,254);
  strcat (secbuf,"/pub_issue.log\n\n");
  strcat (secbuf,"errlog_rotate\t=2048\n");
  strcat (secbuf,"isslog_rotate\t=2048\n\n");

  strcat (secbuf,"[");
  strcat (secbuf,sec);
  strcat (secbuf," end]\n");

  /* find insert point */
  if(sep){
    ve = conf_get_line(sep,&np,&tmp);
  }else{
    if(aiconf_get_section(buf,"default CA",&bp,&np)) goto done;
    ve = conf_get_line(np,&np,&tmp);
  }

  len += strlen(secbuf) + 8;
  if((ret=malloc(len))==NULL) goto done;
  memset(ret,0,len);

  /* register new CRL publisher */
  strcpy(ret,buf);
  strcat(ret,"\n");
  strcat(ret,"\n");
  strcat(ret,secbuf);
  strcat(ret,np);

  printf("success to register a CRL Publisher : %s\n",path);
done:
  if(cry) free(cry);
  return ret;
}

char *aiconf_del_crl(char *buf){
  char tmp,t2,*sbp,*sep,*bp,*np,*vp,*ve,*ret=NULL;
  int i,find,len = strlen(buf);

  /* find CRL Publisher section */
  for(i=find=0; (i<128)&&(!find); i++){
    sprintf(sec,"CRL Publisher %d",i);
    if(_aiconf_get_section(buf,sec,&sbp,&sep)) break;
    tmp = *sep; *sep = 0;

    if(!aiconf_get_item(sbp,"ca_dir",&bp,&vp,&ve,&np)){
      t2 = *ve; *ve = 0;
      if(!strcmp(path,vp)) find = 1; /* set loop end */
      *ve = t2;
    }
    *sep = tmp;
  }

  if(!find){
    printf("error : cannot find specified CRL Publisher : %s\n",path);
    goto done;
  }

  if((ret=malloc(len))==NULL) goto done;
  memset(ret,0,len);

  /* find & set delete point */
  *sbp = 0;
  ve = conf_get_line(sep,&np,&tmp);

  strcpy(ret,buf);
  strcat(ret,np);

  /* replace number */
  for(; i<128; i++){
    sprintf(sec,"CRL Publisher %d",i);
    if(_aiconf_get_section(ret,sec,&sbp,&sep)) break;

    sprintf(sec,"[CRL Publisher %d]",i-1);
    memcpy(sbp,sec,strlen(sec));
    sprintf(sec,"[CRL Publisher %d end]",i-1);
    memcpy(sep,sec,strlen(sec));
  }

  printf("success to unregister a CRL Publisher : %s\n",path);
done:
  return ret;
}


char *aiconf_add_ra(char *buf){
  char tmp,*sbp,*sep,*bp,*np,*ve,*ret=NULL;
  char secbuf[4096],*cry=NULL;
  int i,len = strlen(buf);

  for(sbp=sep=NULL,i=0; i<128; i++){
    sprintf(sec,"RAd RegInfo %d",i);
    if(_aiconf_get_section(buf,sec,&bp,&np)) break;
    sbp = bp; sep = np;
  }

  strcpy (secbuf,"[");
  strcat (secbuf,sec);
  strcat (secbuf,"]\nraname\t=");
  strncat(secbuf,name,30);
  strcat (secbuf,"\nrapath\t=");
  strncat(secbuf,rapath,254);
  strcat (secbuf,"\n\nca_dir\t=");
  strncat(secbuf,path,254);
  strcat (secbuf,"\nca_port\t=11411\n");
  strcat (secbuf,"ca_uid\t=caadmin\nca_pwd\t=");
  if(enc){
    if((cry=aica_encry_passwd(pass))==NULL) goto done;
    strcat (secbuf,"$aicry${");
    strncat(secbuf,cry,126);
    strcat (secbuf,"}");
  }else{
    strncat(secbuf,pass,PWD_BUFLEN);
  }
  strcat (secbuf,"\n\ncl_id\t=\ncl_id_pwd\t=\n\n");
  strcat (secbuf,"f_ssl_use\t=true\nf_ssl_novfycrl\t=true\n\n");

  strcat (secbuf,"interval\t=60\npost_mode\t=false\noffline_ca_mode\t=false\n\n");

  strcat (secbuf,"# authentication mode\n# 0 ... anonymous\n# 1 ... ID/Password mode\n");
  strcat (secbuf,"# 2 ... License ID mode\n# 4 ... Challenge PIN/License ID mode (UPKI)\n");
  strcat (secbuf,"authmode\t=0\n\nwwwpwd\t=");
  strncat(secbuf,rapath,254);
  strcat (secbuf,"/en.passwd\nwwwlicense\t=");
  strncat(secbuf,rapath,254);
  strcat (secbuf,"/en.license\nwwwsessions\t=");
  strncat(secbuf,rapath,254);
  strcat (secbuf,"/sessions.0\n");

  strcat(secbuf, "lang\t=en\n");
  strcat (secbuf,"#ldap_host     =localhost\n");
  strcat (secbuf,"#ldap_port     =389\n");
  strcat (secbuf,"#ldap_bind     =1\n");  
  strcat (secbuf,"#ldap_base     =ou=testca,o=org,c=JP\n\n");

  strcat (secbuf,"#ldap_user_attr=cn\n");
  strcat (secbuf,"#ldap_license_attr=uid\n");
  strcat (secbuf,"#ldap_pin_attr=userpassword\n");
  strcat (secbuf,"#ldap_uquery_attr=initials\n");
  strcat (secbuf,"#ldap_admin    =\n");
  strcat (secbuf,"#ldap_admin_pwd=\n");

  strcat (secbuf,"#smtp_host     =\n");
  strcat (secbuf,"#smtp_port     =25\n");
  strcat (secbuf,"#smtp_from     =\n");
  strcat (secbuf,"#admin_email   =webadmin@localhost\n");
  strcat (secbuf,"#web_address   =http://localhost/");
  strncat(secbuf,name,30);

  strcat (secbuf,"\n\n# 0:in subject, 1:subjectAltName, 2:no email\n");
  strcat (secbuf,"email_sbjfilter=0\n\n");

  strcat (secbuf,"# send notification mail before expiration (hour)\n");
  strcat (secbuf,"notice_update =168\n\n");

  strcat (secbuf,"# grid map file information\n");
  strcat (secbuf,"#gridmap\t=");
  strncat(secbuf,rapath,254);
  strcat (secbuf,"/grid/grid-mapfile\n");
  strcat (secbuf,"#gridcertpath\t=");
  strncat(secbuf,rapath,254);
  strcat (secbuf,"/grid/certs\n\n");

  strcat (secbuf,"groupname.0    =SMIME user\n");
  strcat (secbuf,"groupprof.0    =SMIME user\n");
  strcat (secbuf,"#groupemail.0   =grpadmin@localhost\n");
  strcat (secbuf,"#grouphost.0    =ldapserver\n");
  strcat (secbuf,"#groupbase.0    =ou=hoge0 unit,o=hoge0,c=JP\n\n");

  strcat (secbuf,"groupname.1    =SSL server\n");
  strcat (secbuf,"groupprof.1    =SSL server\n");
  strcat (secbuf,"#groupbase.1    =o=test,c=JP\n");


  strcat (secbuf,"[");
  strcat (secbuf,sec);
  strcat (secbuf," end]\n");

  /* find insert point */
  if(sep){
    ve = conf_get_line(sep,&np,&tmp);
  }else{
    if(aiconf_get_section(buf,"RAd",&bp,&np)) goto done;
    ve = conf_get_line(np,&np,&tmp);
  }

  len += strlen(secbuf) + 8;
  if((ret=malloc(len))==NULL) goto done;
  memset(ret,0,len);

  /* register new RAd RegInfo */
  strcpy(ret,buf);
  strcat(ret,"\n");
  strcat(ret,"\n");
  strcat(ret,secbuf);
  strcat(ret,np);

  printf("success to register a RAd RegInfo : %s\n",path);
done:
  if(cry) free(cry);
  return ret;
}


char *aiconf_del_ra(char *buf){
  char tmp,t2,*sbp,*sep,*bp,*np,*vp,*ve,*ret=NULL;
  int i,find,len = strlen(buf);

  /* find RAd RegInfo section */
  for(i=find=0; (i<128)&&(!find); i++){
    sprintf(sec,"RAd RegInfo %d",i);
    if(_aiconf_get_section(buf,sec,&sbp,&sep)) break;
    tmp = *sep; *sep = 0;

    if(!aiconf_get_item(sbp,"ca_dir",&bp,&vp,&ve,&np)){
      t2 = *ve; *ve = 0;
      if(!strcmp(path,vp)) find = 1; /* set loop end */
      *ve = t2;
    }
    *sep = tmp;
  }

  if(!find){
    printf("error : cannot find specified RAd RegInfo : %s\n",path);
    goto done;
  }

  if((ret=malloc(len))==NULL) goto done;
  memset(ret,0,len);

  /* find & set delete point */
  *sbp = 0;
  ve = conf_get_line(sep,&np,&tmp);

  strcpy(ret,buf);
  strcat(ret,np);

  /* replace number */
  for(; i<128; i++){
    sprintf(sec,"RAd RegInfo %d",i);
    if(_aiconf_get_section(ret,sec,&sbp,&sep)) break;

    sprintf(sec,"[RAd RegInfo %d]",i-1);
    memcpy(sbp,sec,strlen(sec));
    sprintf(sec,"[RAd RegInfo %d end]",i-1);
    memcpy(sep,sec,strlen(sec));
  }

  printf("success to unregister RAd RegInfo : %s\n",path);
done:
  return ret;
}
