/* aicommon.c */
/*
 * In writing functions below, we referred to the following page:
 * http://www.ipa.go.jp/security/awareness/vendor/programmingv1/index.html
 *
 * Thanks!
 *
 */

#include <string.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/wait.h>

void ipa_catch_SIGCHLD(int signo) {
  pid_t ch_pid = 0;
  do {
    int ch_ret;
    ch_pid = waitpid(-1, &ch_ret, WNOHANG);
  } while(ch_pid > 0);
}

void ipa_clean_zombie(void) {
  struct sigaction act;
  memset(&act, 0, sizeof(act));
  act.sa_handler = ipa_catch_SIGCHLD;
  sigemptyset(&act.sa_mask);
  act.sa_flags = SA_NOCLDSTOP | SA_RESTART;
  sigaction(SIGCHLD, &act, NULL);
}
