/* aicatest.c */
/*
 * Copyright (c) 2004-2014 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/index.html.
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */
/*
 * Copyright (C) 1998-2004
 * Akira Iwata & Takuto Okuno
 * Akira Iwata Laboratory,
 * Nagoya Institute of Technology in Japan.
 *
 * All rights reserved.
 *
 * This software is written by Takuto Okuno(usapato@anet.ne.jp)
 * And if you want to contact us, send an email to Kimitake Wakayama
 * (wakayama@elcom.nitech.ac.jp)
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * 3. All advertising materials mentioning features or use of this software must
 *    display the following acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *    Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *     Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 *   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *   AKIRA IWATA LABORATORY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 *   SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 *   IN NO EVENT SHALL AKIRA IWATA LABORATORY BE LIABLE FOR ANY SPECIAL,
 *   INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
 *   FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 *   NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION
 *   WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <aicrypto/ok_tool.h>	/* PWD_BUFLEN */

#ifndef	AICONFIG
#define	AICONFIG "aica.cnf"
#endif

char conf[256]   = AICONFIG;
char pfname[32]  = "SMIME user";

extern char ctstore[];
extern char userid[];
extern char pwd[];

extern char svpath[];
extern char certid[];
extern char clcert[];
extern char clctpw[];
extern char capath[];

extern int usessl;
extern int caport;

/* aicatestfc.c */
int ca_test_bind();
int ca_test_sign(char *profile);
int ca_test_list(char *profile);
int ca_test_cert(char *profile);
int ca_test_crl(char *profile);
int ca_test_csr();
int ca_test_prof();
int ca_test_svop();

void options(int argc,char **argv);
void usage();


int main(int argc, char *argv[])
{
	int ok = -1;

	/* initialize */
	OK_clear_error();
	options(argc, argv);
	RAND_init();

	/* test for reading configuration file.
	 * the configuration file will be specified by the option "-conf"
	 * because this test program will be executed before 'make install',
	 * and must include the following sections:
	 * - [general info]
	 * - [default CA]
	 */
	if (CA_read_config(conf)) {
		/* what is the meaning of the non-zero value
		 * that the CA_read_config() returned?
		 */
		printf("cannot read the configuration file: %s\n", conf);
		goto done;
	}

#if 1 /* <- ??? */
	if (prepare()) goto done;

	/* remote CA test */
	if(ca_test_bind()) goto done;

	if(ca_test_sign(NULL)) goto done;

	if(ca_test_list(NULL)) goto done;

	if(ca_test_cert(NULL)) goto done;

	if(ca_test_csr(NULL)) goto done;

	if(ca_test_crl(NULL)) goto done;

	if(ca_test_prof()) goto done;
#endif
	if(ca_test_svop()) goto done;

	ok = 0;
done:
	OK_clear_passwd();
	
	free_u2j_table();
	RAND_cleanup();
	return ok;
}

/**
 * options
 */
void options(int argc,char **argv)
{
	int i;;

	if (argc == 1) {
		usage();
		exit(EXIT_FAILURE);
	}

	for (i = 1; i < argc; i++) {
		if(!strcmp("-conf",argv[i])){
			i++;
			if(i<argc) strncpy(conf,argv[i],254);
		}else if(!strcmp("-sv",argv[i])){
			i++;
			if(i<argc) strncpy(svpath,argv[i],254);			
		}else if(!strcmp("-ssl",argv[i])){
			usessl=1;

		}else if(!strcmp("-cl",argv[i])){
			i++;
			if(i<argc) strncpy(clcert,argv[i],254);
		}else if(!strcmp("-clid",argv[i])){
			i++;
			if(i<argc) strncpy(certid,argv[i],30);
		}else if(!strcmp("-clpw",argv[i])){
			i++;
			if(i<argc) strncpy(clctpw,argv[i],PWD_BUFLEN);
		}else if(!strcmp("-u",argv[i])){
			i++;
			if(i<argc) strncpy(userid,argv[i],30);
		}else if(!strcmp("-p",argv[i])){
			i++;
			if(i<argc) strncpy(pwd,argv[i],PWD_BUFLEN);
		}else{
			printf("option error!\n");
			printf("unknown option: `%s'\n", argv[i]);
			usage();
			exit(EXIT_FAILURE);
		}
	}
}

/**
 * usage
 */
void usage()
{
	printf("\
Usage: %s [OPTION...]\n", getprogname());
	printf("\
\n\
Options:\n\
  -conf PATH	set aica config path.\n\
  -sv   path    set aica server path.\n\
  -u loginid    set login name (CA client mode).\n\
  -p passwd     set password (local or CA server).\n\
  -clid id      set certificate store id.\n\
  -clpw pwd     set certificate store password.\n\
");
}
