/* aica_user.c */
/*
 * Copyright (c) 2004-2016 National Institute of Informatics in Japan, 
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download.
 * If you redistribute this file, with or without modifications, you must 
 * include this notice in the file.
 */
/*
 * Copyright (C) 1998-2004
 * Akira Iwata & Takuto Okuno
 * Akira Iwata Laboratory,
 * Nagoya Institute of Technology in Japan.
 *
 * All rights reserved.
 *
 * This software is written by Takuto Okuno(usapato@anet.ne.jp)
 * And if you want to contact us, send an email to Kimitake Wakayama
 * (wakayama@elcom.nitech.ac.jp)
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * 3. All advertising materials mentioning features or use of this software must
 *    display the following acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *    Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *     Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 *   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *   AKIRA IWATA LABORATORY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 *   SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 *   IN NO EVENT SHALL AKIRA IWATA LABORATORY BE LIABLE FOR ANY SPECIAL,
 *   INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
 *   FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 *   NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION
 *   WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "ok_ca.h"
#include "ok_aica.h"

/* aica.c */
extern char keypwd[];


int CA_user_add(CA *ca){
	char uname[256]="",pwd[PWD_BUFLEN]="",buf[256];
	AuthInfo *tp=NULL,*ai=NULL;
	int uid,gid,grant,ok=-1;

	if (set_path(buf, 256,
		     ca->ca_path, "/ca.passwd", NULL) == -1) {
		return -1;
	}

	printf("-------\n");
	printf("Add a new user to this CA.\n\n");

	/* get current authinfo */
	if((tp=CA_read_authinfo(buf))==NULL){
		printf("cannot open ca.passwd file. ");
		goto done;
	}

	/* input user name */
	if(ca_ask_comment("Enter new user name",uname,256)) goto done;
	if(*uname==0) goto done;

	if(CA_ai_findbyname(tp,uname)){
		printf("input user name is already used. ");
		goto done;
	}
	
	/* input user passwd */
	OK_get_passwd("Enter user password: ",pwd,1);
	if(*pwd==0) goto done;

	/* input user & group id */
	if((uid=ca_ask_num("Enter user ID (Serial Number)",0))<0) goto done;
	if((gid=ca_ask_num("Enter group ID (Profile Number)",0))<0) goto done;
	if((grant=ca_ask_grant("Enter user Grant",0x0200b007))<0) goto done;

	/* find last point and add new user */
	for(ai=tp;;ai=ai->next) if(ai->next==NULL) break;
	if((ai->next=CA_get_authinfo(uname,pwd,uid,gid,grant,NULL))==NULL) goto done;
	
	if(CA_write_authinfo(tp,buf)) goto done;
	
	ok = 0;
done:
	if(ok) printf("cancel user operation.\n");
	CA_ai_free_all(tp);
	return ok;
}


int CA_user_addop(CA *ca){
	printf("-------\n");
	printf("Add a new CA operator to this CA.\n\n");

	if(*keypwd) OK_set_passwd(keypwd);

	if(CA_add_operator(ca,0)){
		printf("cannot add a new operator.\n");
		return -1;
	}
	return 0;
}

int CA_user_addraadm(CA *ca){
	printf("-------\n");
	printf("Issuing a new RA operator(admin) certificate.\n\n");

	if(*keypwd) OK_set_passwd(keypwd);

	if(CA_add_operator(ca,1)){
		printf("cannot add a new operator.\n");
		return -1;
	}
	return 0;
}

int ca_ask_grant(char *txt,int def){
	char *cp,*t,buf[128]="";
	int ret = def,i;

	printf("%s [0x%x]: ",txt,def);
	fgets(buf,64,stdin);

	if((*buf==0)||(*buf=='\n')){
		ret=def;
	}else if((buf[0]=='0')&&(buf[1]=='x')){
		ret=strtol(buf,&cp,16);
	}else{
		for(ret=0,cp=buf; *cp ; cp++){
			switch(*cp){
			case 'B': ret|=LCMP_GR_BIND; break;
			case 'S': ret|=LCMP_GR_SIGN; break;
			case 'L': ret|=LCMP_GR_LIST; break;
			case 'A': ret|=LCMP_GR_PFLIST; break;
			case 'U': ret|=LCMP_GR_USEROP; break;
			case 'W': ret|=LCMP_GR_CHANGEPW; break;
			case 'X': ret|=LCMP_GR_EXTOP; break;
			case 'P':
				for(i=0,t=cp+1; *t ; t++){
					switch(*t){
					case 'v': ret|=LCMP_GR_PFVIEW; break;
					case 'a': ret|=LCMP_GR_PFADD; break;
					case 'd': ret|=LCMP_GR_PFDEL; break;
					case 'm': ret|=LCMP_GR_PFMOD; break;
					default: i=-1;
					}
					if(i<0) break;
				}
				if(t==(cp+1)) ret|=0x00000078;
				cp=t-1;
				break;
			case 'E':
				for(i=0,t=cp+1; *t ; t++){
					switch(*t){
					case 'v': ret|=LCMP_GR_EXVIEW; break;
					case 'a': ret|=LCMP_GR_EXADD; break;
					case 'd': ret|=LCMP_GR_EXDEL; break;
					case 'm': ret|=LCMP_GR_EXMOD; break;
					default: i=-1;
					}
					if(i<0) break;
				}
				if(t==(cp+1)) ret|=0x00000780;
				cp=t-1;
				break;
			case 'C':
				for(i=0,t=cp+1; *t ; t++){
					switch(*t){
					case 'u': ret|=LCMP_GR_CTUPDT; break;
					case 'r': ret|=LCMP_GR_CTREV; break;
					case 'n': ret|=LCMP_GR_CTUNREV; break;
					case 'e': ret|=LCMP_GR_CTEXP; break;
					default: i=-1;
					}
					if(i<0) break;
				}
				if(t==(cp+1)) ret|=0x0000f000;
				cp=t-1;
				break;
			case 'K':
				for(i=0,t=cp+1; *t ; t++){
					switch(*t){
					case 'i': ret|=LCMP_GR_KEYIMP; break;
					case 'e': ret|=LCMP_GR_KEYEXP; break;
					case 'd': ret|=LCMP_GR_KEYDEL; break;
					default: i=-1;
					}
					if(i<0) break;
				}
				if(t==(cp+1)) ret|=0x00070000;
				cp=t-1;
				break;
			case 'Q':
				for(i=0,t=cp+1; *t ; t++){
					switch(*t){
					case 'p': ret|=LCMP_GR_CSRPOST; break;
					case 'e': ret|=LCMP_GR_CSREXP; break;
					case 'd': ret|=LCMP_GR_CSRDEL; break;
					case 'j': ret|=LCMP_GR_CSRJUDGE; break;
					default: i=-1;
					}
					if(i<0) break;
				}
				if(t==(cp+1)) ret|=0x00f00000;
				cp=t-1;
				break;
			case 'R':
				for(i=0,t=cp+1; *t ; t++){
					switch(*t){
					case 'i': ret|=LCMP_GR_CRLISS; break;
					case 'e': ret|=LCMP_GR_CRLEXP; break;
					default: i=-1;
					}
					if(i<0) break;
				}
				if(t==(cp+1)) ret|=0x03000000;
				cp=t-1;
				break;
			}
		}
	}
	return ret;
}

/*-----------------------------------------------*/
int CA_user_del(CA *ca){
	char uname[256],buf[256];
	AuthInfo *tp=NULL,*ai,*pv=NULL;
	int ok=-1;

	if (set_path(buf, 256,
		     ca->ca_path, "/ca.passwd", NULL) == -1) {
		return -1;
	}

	printf("-------\n");
	printf("Delete a CA user from this CA.\n\n");

	/* get current authinfo */
	if((ai=tp=CA_read_authinfo(buf))==NULL){
		printf("cannot open ca.passwd file. ");
		goto done;
	}

	/* input user name */
	if(ca_ask_comment("Enter delete user name",uname,256)) goto done;

	/* check and delete */
	while(ai){
		if(!strcmp(ai->name,uname)){
			if(pv){
				pv->next=ai->next;
			}else{
				tp=ai->next;
			}
			CA_ai_free(ai);
			break;
		}
		pv=ai; ai=ai->next;
	}
	if(ai==NULL){
		printf("unknown user name. ");
		goto done;
	}

	/* update user info */
	if(CA_write_authinfo(tp,buf)) goto done;
	
	ok = 0;
done:
	if(ok) printf("cancel user operation.\n");
	CA_ai_free_all(tp);
	return ok;
}

/*-----------------------------------------------*/
int CA_user_mod(CA *ca,int pwdmode){
	char uname[256],buf[256],tb[128],pwd[PWD_BUFLEN];
	AuthInfo *tp=NULL,*ai,*pv=NULL,*tmp;
	int uid,gid,grant,ok=-1;

	if (set_path(buf, 256,
		     ca->ca_path, "/ca.passwd", NULL) == -1) {
		return -1;
	}

	printf("-------\n");
	if(pwdmode){
		printf("Change CA user password.\n\n");
	}else{
		printf("Modify a CA user information.\n\n");
	}

	/* get current authinfo */
	if((ai=tp=CA_read_authinfo(buf))==NULL){
		printf("cannot open ca.passwd file. ");
		goto done;
	}

	/* input user name */
	if(ca_ask_comment("Enter user name",uname,256)) goto done;
	if(*uname==0) goto done;

	/* check and modify */
	while(ai){
		if(!strcmp(ai->name,uname)){
			if(pwdmode){
				/* input user passwd */
				OK_get_passwd("Old password: ",pwd,M_NO_CHECK_LEN);

				if(CA_cmp_md5pwd(pwd,ai->passwd)){
					printf("password failed. ");
					goto done;
				}

				OK_get_passwd("New password: ",pwd,1);
				if(CA_get_md5pwd(pwd,tb,128)) goto done;
				if(ai->passwd){ free(ai->passwd); ai->passwd=NULL;}
				if ((ai->passwd = strdup(tb)) == NULL){
					/* system error */
					goto done;
				}
			}else{
				/* input user & group id */
				if((uid=ca_ask_num("Enter user ID (Serial Number)",ai->uid))<0) goto done;
				if((gid=ca_ask_num("Enter group ID (Profile Number)",ai->gid))<0) goto done;
				if((grant=ca_ask_grant("Enter user Grant",ai->grant))<0) goto done;

				if((tmp=CA_lcmp_authinfo(uname,ai->passwd,NULL,uid,gid,grant,NULL))==NULL)
					goto done;
				if(pv){
					pv->next=tmp; tmp->next=ai->next;
				}else{
					tp=tmp; tmp->next=ai->next;
				}
				CA_ai_free(ai);
			}

			break;
		}
		pv=ai; ai=ai->next;
	}
	if(ai==NULL){
		printf("unknown user name. ");
		goto done;
	}
	
	/* update user info */
	if(CA_write_authinfo(tp,buf)) goto done;
	
	ok = 0;
done:
	if(ok) printf("cancel user operation.\n");
	CA_ai_free_all(tp);
	return ok;
}
