/* aica_setext.c */
/*
 * Copyright (c) 2004-2014 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */
/*
 * Copyright (C) 1998-2002
 * Akira Iwata & Takuto Okuno
 * Akira Iwata Laboratory,
 * Nagoya Institute of Technology in Japan.
 *
 * All rights reserved.
 *
 * This software is written by Takuto Okuno(usapato@anet.ne.jp)
 * And if you want to contact us, send an email to Kimitake Wakayama
 * (wakayama@elcom.nitech.ac.jp)
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * 3. All advertising materials mentioning features or use of this software must
 *    display the following acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *    Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *     Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 *   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *   AKIRA IWATA LABORATORY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 *   SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 *   IN NO EVENT SHALL AKIRA IWATA LABORATORY BE LIABLE FOR ANY SPECIAL,
 *   INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
 *   FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 *   NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION
 *   WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <aicrypto/ok_asn1.h>

#include "ok_aica.h"

int ca_ask_add_or_delete(){
	char buf[128] = "";
	int ret = 1;

	for(;;){
		printf("Add or delete X.509 extension for profile.\n");
		printf("Select operation (a..add/d..delete/c..cancel)[a]: ");
		fgets(buf,64,stdin);

		if((*buf==0)||(*buf=='\n')||(*buf=='a')){ ret=1; break; }
		if(*buf=='d'){ ret=0; break; }
		if(*buf=='c'){ ret=-1; break; }

		printf("Invalid operation! Please input again.\n");
	}
	return ret;
}

int ca_ask_onoff(char *txt,int on){
	char buf[128] = "";
	int ret = 1;

	for(;;){
		printf("%s (on/off)[%s]: ",txt,(on)?("on"):("off"));
		fgets(buf,64,stdin);

		if(strstr(buf,"on")){ ret=1; break; }
		if(strstr(buf,"off")){ ret=0; break; }
		if((*buf==0)||(*buf=='\n')){ ret=on; break; }

		printf("Invalid operation! Please input again.\n");
	}
	return ret;
}

int ca_ask_yesno(char *txt,int yes){
	char buf[128] = "";
	int ret = 1;

	for(;;){
		printf("%s (y/n)[%s]: ",txt,(yes)?("y"):("n"));
		fgets(buf,64,stdin);

		if(strstr(buf,"y")){ ret=1; break; }
		if(strstr(buf,"n")){ ret=0; break; }
		if((*buf==0)||(*buf=='\n')){ ret=yes; break; }

		printf("Invalid operation! Please input again.\n");
	}
	return ret;
}

int ca_ask_num(char *txt,int num){
	char buf[128] = "";
	int ret = num;

	printf("%s [%d]: ",txt,num);
	fgets(buf,64,stdin);

	if((*buf==0)||(*buf=='\n')) ret=num;
	else ret=atoi(buf);

	return ret;
}

int ca_ask_comment(char *txt,char *buf, int max){
	char *cp;
	printf("%s : ",txt);
	fgets(buf,max,stdin);
	if((cp=strchr(buf,'\n')) != NULL) *cp=0;
	return 0;
}

/*--------------------------------------------
	ask extensions
--------------------------------------------*/
CertExt *ca_ask_basiccons(CA *ca){
	CertExt *ret;
	int caf=0,path=-1,crit=1;

	printf("------\n");
	printf("Configure detail information for BasicConstraints extension.\n");

	crit = ca_ask_yesno("set critical flag",1);
	caf  = ca_ask_yesno("set CA flag ",0);
	path = ca_ask_num("set pathLength (-1 means 'NULL')",-1);

	if((ret=Extnew_basic_cons(caf,path))==NULL) return NULL;
	ret->critical = crit;
	return ret;
}

CertExt *ca_ask_keyusage(CA *ca){
	CertExt *ret;
	int crit=1;
	unsigned char flag=0;

	printf("------\n");
	printf("Configure detail information for KeyUsage extension.\n");

	crit = ca_ask_yesno("set critical flag",1);
	flag |= (ca_ask_yesno("set digitalSignature flag",1))?(0x80):(0);
	flag |= (ca_ask_yesno("set nonRepudiation flag",1))?(0x40):(0);
	flag |= (ca_ask_yesno("set keyEncipherment flag",1))?(0x20):(0);
	flag |= (ca_ask_yesno("set dataEncipherment flag",1))?(0x10):(0);
	flag |= (ca_ask_yesno("set keyAgreement flag",0))?(0x08):(0);
	flag |= (ca_ask_yesno("set keyCertSign flag",0))?(0x04):(0);
	flag |= (ca_ask_yesno("set cRLSign flag",0))?(0x02):(0);

	if((ret=Extnew_keyusage(flag))==NULL) return NULL;
	ret->critical = crit;
	return ret;
}

CertExt *ca_ask_extkeyusage(CA *ca){
	char *cp[16],buf[16][128];
	int i;

	printf("------\n");
	printf("Configure detail information for ExtendedKeyUsage extension.\n");
	memset(buf,0,16*128);
	memset(cp,0,16*sizeof(char*));

	for(i=0;i<16;i++){
	  if(ca_ask_comment("Set Ext KeyUsage OID",&buf[i][0],128)) return NULL;
	  cp[i] = &buf[i][0];

	  printf("\n");
	  if(ca_ask_yesno("Do you continue ?",0)==0) break;
	  printf("------\n");
	}

	return Extnew_extkeyusage(cp);
}

CertExt *ca_ask_authkeyid(CA *ca){
	int flag=0;

	printf("------\n");
	printf("Configure detail information for AuthKeyID extension.\n");
	flag |= (ca_ask_yesno("set key identifier",1))?(0x04):(0);
	flag |= (ca_ask_yesno("set issuer DN",0))?(0x02):(0);
	flag |= (ca_ask_yesno("set serial number",0))?(0x01):(0);
	
	return Extnew_authkey_id(ca->cert,flag);
}

CertExt *ca_ask_issaltname(CA *ca){
	ExtGenNames *gen = NULL;

	printf("------\n");
	printf("Configure detail information for IssuerAltName extension.\n");
	if((gen=input_gennames(NULL))==NULL) return NULL;

	return Extnew_altname(OBJ_X509v3_IssAltName,gen);
}

CertExt *ca_ask_sbjaltname(CA *ca){
	ExtGenNames *gen = NULL;

	if((gen=ExtGN_set_url("http://dummy/sbj/"))==NULL) return NULL;

	return Extnew_altname(OBJ_X509v3_SbjAltName,gen);
}

CertExt *ca_ask_extcomment(CA *ca,int id,char *txt){
	char buf[256]="";

	printf("------\n");
	printf("Configure detail information for %s extension.\n",txt);
	if(ca_ask_comment("input text",buf,256)) return NULL;
	
	return Extnew_comment(id,buf);
}

CertExt *ca_ask_nstype(CA *ca){
	unsigned char flag=0;

	printf("------\n");
	printf("Configure detail information for NetscapeCertType extension.\n");

	flag |= (ca_ask_yesno("set SSL Client flag",1))?(0x80):(0);
	flag |= (ca_ask_yesno("set SSL Server flag",0))?(0x40):(0);
	flag |= (ca_ask_yesno("set S/MIME flag",1))?(0x20):(0);
	flag |= (ca_ask_yesno("set Object Signing flag",1))?(0x10):(0);
	flag |= (ca_ask_yesno("set SSL CA flag",0))?(0x04):(0);
	flag |= (ca_ask_yesno("set S/MIME CA flag",0))?(0x02):(0);
	flag |= (ca_ask_yesno("set Object Signing CA flag",0))?(0x01):(0);

	return Extnew_ns_flag(flag);
}


CertExt *ca_ask_certpol(CA *ca){
	ExtCertPol *pol,*hd,*top;
	CertExt *ret = NULL;
	char buf[256],b2[256];
	int i,crit;

	printf("------\n");
	printf("Configure detail information for CertificatePolicies extension.\n");
	crit = ca_ask_yesno("set critical flag",0);

	for(top=hd=NULL;;){
	  if((pol=ExtCP_new())==NULL) return NULL;
	  
	  if(ca_ask_comment("Set Policy ID (ex. \"1.2.33\")",buf,256)) return NULL;
	  if ((pol->policyID = strdup(buf)) == NULL) return NULL;

	  printf("Select field ID ...");
	  for(;;){
	    i = ca_ask_num("(1.CPS Uri, 2.User Notice, 0.Quit)",1);
	    if((0<=i)&&(i<3)) break;
	    printf("invalid value ... please input again\n");
	  }

	  switch(i){
	  case 1:
	    if(ca_ask_comment("CPS Uri",buf,256)) return NULL;
	    if((pol->info=ExtPI_get_cps("1.3.6.1.5.5.7.2.1",buf))==NULL) return NULL;
	    break;

	  case 2:
	    if(ca_ask_comment("Organization",buf,256)) return NULL;
	    i = ca_ask_num("noticeNumber",0);
	    if(ca_ask_comment("explicitText",b2,256)) return NULL;
	    if((pol->info=ExtPI_get_unotice("1.3.6.1.5.5.7.2.2",buf,i,b2))==NULL) return NULL;
	    break;

	  case 0:
	    break;
	  }

	  if(top){
	    hd=hd->next=pol;
	  }else{
	    hd=top=pol;
	  }

	  printf("\n");
	  if(ca_ask_yesno("Do you continue ?",0)==0) break;
	  printf("------\n");
	}

	if((ret=Extnew_cert_policy(OBJ_X509v3_CERT_Pol,top))==NULL) return NULL;
	ret->critical = crit;
	return ret;

	return Extnew_cert_policy(OBJ_X509v3_CERT_Pol,top);
}

CertExt *ca_ask_polmap(CA *ca){
	char b1[256],b2[256];

	printf("------\n");
	printf("Configure detail information for PolicyMappings extension.\n\n");

	if(ca_ask_comment("Set issuerDomainPolicy ",b1,256)) return NULL;
	if(ca_ask_comment("Set subjectDomainPolicy",b2,256)) return NULL;

	return Extnew_policy_map(b1,b2);
}

CertExt *ca_ask_authinfo(CA *ca){
	ExtGenNames *gen = NULL;
	char *meth[5] = {
	  "1.3.6.1.5.5.7.48.1", "1.3.6.1.5.5.7.48.2","1.3.6.1.5.5.7.48.3",
	  "1.3.6.1.5.5.7.48.4", "1.3.6.1.5.5.7.48.5"};
	int i;

	printf("------\n");
	printf("Configure detail information for AuthorityInformationAccess extension.\n\n");

	printf("Set Access Method\n");
	for(;;){
	  i = ca_ask_num("(1.OCSP, 2.CA Issuers 3.Time Stamping, 4.DVCS, 5.CA Repository)",1);
	  if((0<i)&&(i<6)){ i--; break; }
	  printf("invalid value ... please input again\n");
	}

	printf("\nSet Access Location\n");
	if((gen=input_gennames(NULL))==NULL) return NULL;

	return Extnew_pkix_aia(meth[i],gen);
}


CertExt *ca_ask_crldp(CA *ca){
	struct distpoint distp[8];
	unsigned char flg[2];
	int i;

	printf("------\n");
	printf("Configure detail information for CRL Distribution Point extension.\n");

	for(i=0; i<8; i++){
		memset(flg,0,2);
		memset(&distp[i],0,sizeof(struct distpoint));

		if(ca_ask_yesno("Do you set Distribution Point ?",1)){
			distp[i].distp.fullName = input_gennames(NULL);
			distp[i].distp.FullorRDN = 1;
		}
		if(ca_ask_yesno("Do you set ReasonFlags ?",0)){
			flg[0] |= (ca_ask_yesno("set unused flag",0))?(0x80):(0);
			flg[0] |= (ca_ask_yesno("set keyCompromise flag",0))?(0x40):(0);
			flg[0] |= (ca_ask_yesno("set cACompromise flag",0))?(0x20):(0);
			flg[0] |= (ca_ask_yesno("set affiliationChanged flag",0))?(0x10):(0);
			flg[0] |= (ca_ask_yesno("set superseded flag",0))?(0x08):(0);
			flg[0] |= (ca_ask_yesno("set cessationOfOperation flag",0))?(0x04):(0);
			flg[0] |= (ca_ask_yesno("set certificateHold flag",0))?(0x02):(0);
			flg[0] |= (ca_ask_yesno("set privilegeWithdrawn flag",0))?(0x01):(0);
			flg[1] |= (ca_ask_yesno("set aACompromise flag",0))?(0x80):(0);
			memcpy(distp[i].flag,flg,2);
		}
		if(ca_ask_yesno("Do you set cRLIssuer ?",0)){
			distp[i].cRLIssuer = input_gennames("NULL");
		}

		printf("\n");
		if(ca_ask_yesno("Do you continue ?",0)==0) break;
		printf("------\n");
	}

	if(i==8) i--;
	return Extnew_crl_distpoint_(distp,i+1);
}

CertExt *ca_ask_issdp(CA *ca){
	CertExt *ret = NULL;
	ExtGenNames *gen = NULL;
	unsigned char flg[2],*cp = NULL;
	int crit = 0, bflg = 0;

	printf("------\n");
	printf("Configure detail information for Issuing Distribution Point extension.\n");

	crit = ca_ask_yesno("set critical flag",0);

	memset(flg,0,2);

	if(ca_ask_yesno("Do you set Distribution Point ?",0)){
		gen = input_gennames(NULL);
	}

	bflg |= (ca_ask_yesno("Do you set onlyContainsUserCerts ?",0))?(EXT_IDP_UCert):(0);
	bflg |= (ca_ask_yesno("Do you set onlyContainsCACerts ?",0))?(EXT_IDP_CACert):(0);

	if(ca_ask_yesno("Do you set ReasonFlags ?",0)){
		flg[0] |= (ca_ask_yesno("set unused flag",0))?(0x80):(0);
		flg[0] |= (ca_ask_yesno("set keyCompromise flag",0))?(0x40):(0);
		flg[0] |= (ca_ask_yesno("set cACompromise flag",0))?(0x20):(0);
		flg[0] |= (ca_ask_yesno("set affiliationChanged flag",0))?(0x10):(0);
		flg[0] |= (ca_ask_yesno("set superseded flag",0))?(0x08):(0);
		flg[0] |= (ca_ask_yesno("set cessationOfOperation flag",0))?(0x04):(0);
		flg[0] |= (ca_ask_yesno("set certificateHold flag",0))?(0x02):(0);
		flg[0] |= (ca_ask_yesno("set privilegeWithdrawn flag",0))?(0x01):(0);
		flg[1] |= (ca_ask_yesno("set aACompromise flag",0))?(0x80):(0);
		cp = flg;
	}

	bflg |= (ca_ask_yesno("Do you set indirectCRL ?",0))?(EXT_IDP_indCRL):(0);

	if((ret = Extnew_crl_issdistpt(gen,cp,bflg))==NULL) return NULL;
	ret->critical = crit;
	return ret;
}

/*--------------------------------------------
	set profile extensions
--------------------------------------------*/
int CA_set_extensions(CA *ca,int extoid){
	CertProf *cpf = ca->cprof;
	CRLProf *lpf = ca->lprof;
	CertExt  *ext;
	int add=0,change=0;
	char *name = (cpf)?(cpf->name):(lpf->name);

	/* ask add or delete a extension, or cancel */
	if((add = ca_ask_add_or_delete())<0){
		printf("\nCancel to modify a certificate extension!\n");
		return 0;
	}
	/* delete current extension if exist */
	if(cpf) Prof_delete_ext(cpf,extoid);
	else    Prof_delete_crlext(lpf,extoid);

	if(add){
		if((ext = CA_get_newext(ca,extoid))==NULL) goto error;
		if(cpf){
			ext->next=cpf->ext; cpf->ext=ext;
		}else{
			ext->next=lpf->ext; lpf->ext=ext;
		}
		printf("an extension is added to '%s' profile.\n",name);
	}else{
		printf("an extension is deleted from '%s' profile.\n",name);
	}
	change++;

	return change;
error:
	return -1;
}

/*--------------------------------------------
	get new extensions
--------------------------------------------*/
CertExt *CA_get_newext(CA *ca, int extoid){
	CertExt *ret=NULL;
	char *txt;

	/* add new extension */
	switch(extoid){
	case OBJ_NS_CERT_CRLURL:
		txt = "Netscape CrlUrl";
		if((ret = ca_ask_extcomment(ca,extoid,txt))==NULL) goto error;
		break;

	case OBJ_NS_CERT_COMMENT:
		txt = "Netscape Comment";
		if((ret = ca_ask_extcomment(ca,extoid,txt))==NULL) goto error;
		break;

	case OBJ_NS_CERT_TYPE:
		txt = "Netscape CertType";
		if((ret = ca_ask_nstype(ca))==NULL) goto error;
		break;

	case OBJ_X509v3_KEY_Usage:
		txt = "KeyUsage";
		if((ret = ca_ask_keyusage(ca))==NULL) goto error;
		break;

	case OBJ_X509v3_ExtKeyUsage:
		txt = "ExtKeyUsage";
		if((ret = ca_ask_extkeyusage(ca))==NULL) goto error;
		break;

	case OBJ_X509v3_BASIC:
		txt = "BasicConstraints";
		if((ret = ca_ask_basiccons(ca))==NULL) goto error;
		break;

	case OBJ_X509v3_AuthKeyIdt:
		txt = "AuthorityKeyIdentifier";
		if((ret = ca_ask_authkeyid(ca))==NULL) goto error;
		break;

	case OBJ_X509v3_SbjKeyIdt:
		txt = "SubjectKeyIdentifier";
		if((ret = Extnew_sbjkey_id(ca->cert))==NULL) goto error;
		break;

	case OBJ_X509v3_IssAltName:
		txt = "IssuerAltName";
		if((ret = ca_ask_issaltname(ca))==NULL) goto error;
		break;

	case OBJ_X509v3_SbjAltName:
		txt = "SubjectAltName";
		if((ret = ca_ask_sbjaltname(ca))==NULL) goto error;
		break;

	case OBJ_X509v3_CERT_Pol:
		txt = "CertificatePolicies";
		if((ret = ca_ask_certpol(ca))==NULL) goto error;
		break;

	case OBJ_X509v3_CertPolMap:
		txt = "PolicyMappings";
		if((ret = ca_ask_polmap(ca))==NULL) goto error;
		break;

	case OBJ_PKIX_IDPE_AIA:
		txt = "AuthorityInformationAccess";
		if((ret = ca_ask_authinfo(ca))==NULL) goto error;
		break;

	case OBJ_PKIX_OCSP_NOCHECK:
		txt = "OCSPNoCheck";
		if((ret = Extnew_ocsp_nocheck())==NULL) goto error;
		break;

	case OBJ_X509v3_CRL_Point:
		txt = "CRLDistributionPoint";
		if((ret = ca_ask_crldp(ca))==NULL) goto error;
		break;

	case OBJ_X509v3_CRLNumber:
		txt = "CRLNumber";
		if((ret = Extnew_crl_number(0))==NULL) goto error;
		break;

	case OBJ_X509v3_IssDistPoint:
		txt = "IssuingDistributionPoint";
		if((ret = ca_ask_issdp(ca))==NULL) goto error;
		break;

	case OBJ_X509v3_CRLReason:
		txt = "CRLReasonCode";
		if((ret = Extnew_reason_code(0))==NULL) goto error;
		break;
	}
	return ret;
error:
	return NULL;
}

