/* aica_print.c */
/*
 * Copyright (c) 2004-2014 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */
/*
 * Copyright (C) 1998-2004
 * Akira Iwata & Takuto Okuno
 * Akira Iwata Laboratory,
 * Nagoya Institute of Technology in Japan.
 *
 * All rights reserved.
 *
 * This software is written by Takuto Okuno(usapato@anet.ne.jp)
 * And if you want to contact us, send an email to Kimitake Wakayama
 * (wakayama@elcom.nitech.ac.jp)
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * 3. All advertising materials mentioning features or use of this software must
 *    display the following acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *    Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *     Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 *   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *   AKIRA IWATA LABORATORY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 *   SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 *   IN NO EVENT SHALL AKIRA IWATA LABORATORY BE LIABLE FOR ANY SPECIAL,
 *   INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
 *   FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 *   NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION
 *   WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <aicrypto/ok_x509.h>

#include "ok_ca.h"

/* XXX: aicrypto/x509/cert_print.c */
void print_sig_algo(int sig);
void print_v3_extensions(CertExt *top);

/* aica_pol.c */
void CA_print_profpolicy(unsigned char *flag);
void CA_print_profdnpolicy(unsigned char *flag);

void print_ca_policy(unsigned char *pol);

void CA_print(CA *ca,char *pfname,int pfall){
	CertProf *cpf;
	CRLProf *lpf;
	int i,flg=0;
	char *tmp=NULL;

	printf("Issuer  :\n  %s\n",ca->issuer);
	printf("Subject :\n  %s\n",ca->subject);

	cpf=Prof_find(ca,pfname);
	lpf=Prof_crl_find(ca,pfname);

	flg = ((cpf==NULL)&&(lpf==NULL))||(pfall);
	if(flg){ cpf=ca->profList; lpf=ca->crlpList; }

	/* print cert profile */
	for(; cpf ;cpf=cpf->next){
		ca->cprof = cpf;
		if(Prof_reload_ctinfo(ca)) break; /* error */

		printf("------------------------------------\n");
		printf("Certificate Profile : %s\n",cpf->name);
		printf("  certificate version  : %d\n",cpf->cert_ver+1);
		printf("  current serial number: %d\n",cpf->serialNum);
		printf("  signature algorithm  : ");
		print_sig_algo(cpf->sigtype); /* cert_print.c */
		printf("  certificate begin    : ");
		if(cpf->bgtype==0){
		    printf("at signing time\n");
		}else if(cpf->bgtype==1){
		    printf("%s\n",stm2str(&cpf->ct_begin,0));
		}else if(cpf->bgtype==2){
		    printf("%s\n",stm2str(&cpf->ct_begin,2));
		}
		printf("  certificate end      : ");
		if(cpf->edtype==0){
		    i = cpf->cert_sec;
		    printf("%d days (%d sec)\n",i/(24*3600),i);
		}else if(cpf->edtype==1){
		    printf("%s\n",stm2str(&cpf->ct_end,0));
		}else if(cpf->edtype==2){
		    printf("%s\n",stm2str(&cpf->ct_end,2));
		}
		printf("  renewal period       : ");
		if(cpf->updtype==0){
		    i = cpf->upd_sec;
		    printf("%d days prior to expiration\n",i/(24*3600));
		}

		printf("  subject template     : ");
		if((tmp=Cert_subject_str(&cpf->sbj_tmpl))==NULL){
			printf("null\n");
		}else{
			printf("\n    %s\n",tmp);
			free(tmp); tmp=NULL;
		}
		CA_print_profpolicy(cpf->pol_flag);

		CA_print_profdnpolicy(cpf->pol_flag);

		printf("  certificate extensions :\n");
		print_v3_extensions(cpf->ext);
		if(!flg) break;
	}
	/* print CRL profile */
	for(; lpf ;lpf=lpf->next){
		ca->lprof = lpf;
		if(Prof_reload_clinfo(ca)) break; /* error */

		printf("------------------------------------\n");
		printf("CRL Profile : %s\n",lpf->name);
		printf("  CRL version : %d\n",lpf->crl_ver+1);
		printf("  CRL number  : %d\n",lpf->crlNum);
		printf("  signature   : ");
		print_sig_algo(lpf->sigtype); /* cert_print.c */
		printf("  CRL begin   : ");
		if(lpf->bgtype==0){
		    printf("at signing time\n");
		}else{
		    printf("%s\n",stm2str(&lpf->cl_begin,0));
		}
		i = lpf->crl_sec;
		printf("  CRL end     : ");
		printf("%d days (%d sec)\n",i/(24*3600),i);
		
		print_v3_extensions(lpf->ext);
		if(!flg) break;
	}
}

void print_ca_policy(unsigned char *pol){
	char cp[3][16]={"matched","supplied","option"};
	/* int kd[] ={0,1,2,3,4,5,9}; *//* XXX:currently unused */

	printf("CA policy : ");
	printf("C=%s:",cp[pol[0]]);
	printf("ST=%s:",cp[pol[1]]);
	printf("L=%s:",cp[pol[2]]);
	printf("O=%s:",cp[pol[3]]);
	printf("OU=%s:",cp[pol[4]]);
	printf("CN=%s:",cp[pol[5]]);
	printf("Email=%s\n",cp[pol[9]]);
}

void ca_stat_print(CertStat *stat,char *pfname,int sn){
	char	s[8],p1[64],*p2;
	int csrm = (!strcmp(pfname,"CSR"));
	CertStat *st;

	if(csrm){
		printf("CSR list (posted,issued or rejected)\n");
		printf(" state  accept  serial    subject            postedData           completeData\n");
	}else{
		printf("certificate list [profile : %s]\n",pfname);
		printf(" state  serial    subject             notBefore      notAfter      revokedDate\n");
	}
	memset(s,0,8);
	for(st=stat; st ;st=st->next){
		if(csrm){
			if((sn>0)&&(st->acceptID!=sn)) continue;

			(st->state&CSR_STAT_WAIT)?(s[0]='W'):(s[0]='-');
			(st->state&CSR_STAT_SIGNED)?(s[1]='S'):(s[1]='-');
			(st->state&CSR_STAT_REJECT)?(s[2]='R'):(s[2]='-');

			if((p2=stm2str(&st->notBefore,1))==NULL) p2="--";
			strcpy(p1,p2);
			if(st->notAfter.tm_year){
				if((p2=stm2str(&st->notAfter,1))==NULL)  p2="--";
			}else{
				p2="";
			}

			printf(" %s,  %4d,  %5d,  \"%s\", %s, %s\n",s,st->acceptID,st->serialNum,st->subject,p1,p2);
		}else{
			if((sn>0)&&(st->serialNum!=sn)) continue;

			(st->state&STAT_CA)?(s[0]='C'):(s[0]='-');
			(st->state&STAT_EXPIRED)?(s[1]='E'):(s[1]='-');
			(st->state&STAT_REVOKED)?(s[2]='R'):(s[2]='-');
			(st->state&STAT_HAVEKEY)?(s[3]='K'):(s[3]='-');

			if((p2=stm2str(&st->notBefore,1))==NULL) p2="--";
			strcpy(p1,p2);
			if((p2=stm2str(&st->notAfter,1))==NULL)  p2="--";

			printf("  %s,  %5d, \"%s\", %s, %s, ",s,st->serialNum,st->subject,p1,p2);

			if(st->revokedDate.tm_year){
				if((p2=stm2str(&st->revokedDate,1))==NULL) p2="--";
			}else{
				p2="";
			}
			printf("%s\n",p2);
		}
	}
}

void CA_certstat_print(CA *ca,char *pfname,int sn,char *query){
	int csrmode = (!strcmp(pfname,"CSR"));
	CertStat *hd, *st, *top = NULL;
	CertProf *cpf;

	if(csrmode){
		if(Prof_reload_csrinfo(ca)) return; /* error */
		top = ca->csrProf->stat;
	}else if(!strcmp(pfname,"*")){
		for(cpf=ca->profList; cpf ; cpf=cpf->next){
			if(strcmp(cpf->name,"Operators") && strcmp(cpf->name,"Cross Cert")){
				ca->cprof = cpf;
				if(Prof_reload_ctinfo(ca)) return; /* error */
				Prof_expire_check(ca->cprof);

				if(query[0]){
					st = Prof_find_sbjquery(cpf->stat,query);
				}else{
					st = cpf->stat; if(top) cpf->stat = NULL;
				}

				if(top){
					hd->next = st; 
				}else{
					top = hd = st;
				}
				while(hd && hd->next){ hd = hd->next; }
			}
		}
	}else{
		if((ca->cprof=cpf=Prof_find(ca,pfname))==NULL){
			printf("unknown profile...cannot list certificates\n");
			return;
		}
		if(Prof_reload_ctinfo(ca)) return; /* error */
		Prof_expire_check(ca->cprof);

		if(query[0]){
			top = Prof_find_sbjquery(ca->cprof->stat,query);
		}else{
			top = ca->cprof->stat;
		}
	}
	ca_stat_print(top,pfname,sn);
	if(query[0]) CertStat_free_all(top);
}

