/* aica_pol.c */
/*
 * Copyright (c) 2004-2014 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/index.html.
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */
/*
 * Copyright (C) 1998-2004
 * Akira Iwata & Takuto Okuno
 * Akira Iwata Laboratory,
 * Nagoya Institute of Technology in Japan.
 *
 * All rights reserved.
 *
 * This software is written by Takuto Okuno(usapato@anet.ne.jp)
 * And if you want to contact us, send an email to Kimitake Wakayama
 * (wakayama@elcom.nitech.ac.jp)
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * 3. All advertising materials mentioning features or use of this software must
 *    display the following acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *    Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *     Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 *   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *   AKIRA IWATA LABORATORY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 *   SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 *   IN NO EVENT SHALL AKIRA IWATA LABORATORY BE LIABLE FOR ANY SPECIAL,
 *   INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
 *   FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 *   NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION
 *   WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <aicrypto/ok_err.h>
#include <aicrypto/ok_asn1.h>

#include "ok_caerr.h"
#include "ok_aica.h"

char sbj_t[10][32]={
	"Country","STate or province","Locality",
	"Organization","Organization Unit","Domain Component"};

/*-----------------------------------------
  set CA policy
-----------------------------------------*/
int CA_set_policy(CA *ca,char *in){
	int i,j;
	int kd[] ={0,1,2,3,4,5,9};

	for(i=0;i<7;i++,in++){
		switch(*in){
		case 'm':
		case 'M':
			j=0;
			break;
		case 's':
		case 'S':
			j=1;
			break;
		case 'o':
		case 'O':
			j=2;
			break;
		case ':':
			continue;
		default:
			goto error;
			break;
		}
		ca->policy[kd[i]] = j;
		in++;
		if((i<6)&&(*in != ':')) goto error;
	}
	return 0;
error:
	OK_set_error(ERR_ST_BADFORMAT,ERR_LC_CA,ERR_PT_CAPOL+1,NULL);    
	return -1;
}

/*-----------------------------------------
  input subject template DN
-----------------------------------------*/
int CA_input_sbjtmpl(CertDN *dn){
	CertDN tmp;
	char buf[128],*tag;
	int i,j,k,l,kind;

	cert_dn_init(&tmp);
	printf("-----\n");
	printf("input Distinguished Name (DN) for subject template.\n");

	for(i=j=0;j<RDN_MAX;){
		if(i<dn->num){
		  if(dn->rdn[i].tagoid==OBJ_DIR_DC) k=5;
		  else k = dn->rdn[i].tagoid - OBJ_DIR_C;
		}else{
		  k=6;
		}

		printf("select directory tag (input number)\n");
		printf("(1.C, 2.ST, 3.L, 4.O, 5.OU, 6.DN, 7.Quit)[%d]:",k+1);
		fgets(buf,64,stdin);
		if((l = atoi(buf))==0) l = k + 1;

		if(l==7) break;
		else if((l<1)||(7<l)) continue;

		kind = l - 1 + OBJ_DIR_C;
		if(l==6) kind = OBJ_DIR_DC;

		if((tag=Cert_find_dn(dn,kind,&k,0))==NULL) tag = "";

		printf("%s [%s]: ",sbj_t[l-1],tag);
		fgets(buf,64,stdin);
		k = strlen(buf);
		buf[k-1]=0;		/* clean return code */

		if(k==1){
			if(strcmp(tag,"")){
				if ((tmp.rdn[j].tag = strdup(tag)) == NULL) goto error;
			}else{
				continue;
			}
		}else{
			if ((tmp.rdn[j].tag = strdup(buf)) == NULL) goto error;
		}

		tmp.rdn[j].tagoid  = kind;
		tmp.rdn[j].derform = (kind==OBJ_DIR_C)?(ASN1_PRINTABLE_STRING):(asn1_str_type(tmp.rdn[j].tag));
		if(kind>=dn->rdn[i].tagoid) i++;
		j++;
	}
	tmp.num = j;

	/* replace DN */
	cert_dn_free(dn);
	if(Cert_dncopy(&tmp,dn)) goto error;
	cert_dn_free(&tmp);

	return 0;
error:
	OK_set_error(ERR_ST_STRDUP,ERR_LC_CA,ERR_PT_CAPOL+2,NULL);    
	cert_dn_free(&tmp);
	return -1;
}

/*-----------------------------------------
  input profile working policy
-----------------------------------------*/
int CA_input_profpolicy(unsigned char *flag){
	unsigned char tmp[8];
	
	printf("-----\n");
	printf("input profile working policy.\n");

	memset(tmp,0,8);
	tmp[0] |= (ca_ask_yesno("reuse same subject DN ?", flag[0]&CPF_WP0_allowSameSbjDN))?(CPF_WP0_allowSameSbjDN):(0);
	tmp[0] |= (ca_ask_yesno("reuse expired subject DN ?", flag[0]&CPF_WP0_allowExpdSbjDN))?(CPF_WP0_allowExpdSbjDN):(0);
	tmp[0] |= (ca_ask_yesno("reuse revoked subject DN ?", flag[0]&CPF_WP0_allowRvkdSbjDN))?(CPF_WP0_allowRvkdSbjDN):(0);
	tmp[0] |= (ca_ask_yesno("reuse subject DN in renewal period ?", flag[0]&CPF_WP0_allowInUpdSbjDN))?(CPF_WP0_allowInUpdSbjDN):(0);

	tmp[0] |= (ca_ask_yesno("reuse same public key ?", flag[0]&CPF_WP0_allowSameKey))?(CPF_WP0_allowSameKey):(0);
	tmp[0] |= (ca_ask_yesno("reuse expired public key ?", flag[0]&CPF_WP0_allowExpdKey))?(CPF_WP0_allowExpdKey):(0);
	/* tmp[0] |= (ca_ask_yesno("reuse revoked public key ?", flag[0]&CPF_WP0_allowRvkdKey))?(CPF_WP0_allowRvkdKey):(0); */
	tmp[0] |= (ca_ask_yesno("reuse public key in renewal period ?", flag[0]&CPF_WP0_allowInUpdKey))?(CPF_WP0_allowInUpdKey):(0);

	tmp[1] |= (ca_ask_yesno("replace subject DN with template ?", flag[1]&CPF_WP1_replaceWithTmplDN))?(CPF_WP1_replaceWithTmplDN):(0);
	if(tmp[1]&CPF_WP1_replaceWithTmplDN){
	  tmp[1] |= (ca_ask_yesno("replace subject DN except OU ?", flag[1]&CPF_WP1_replaceDNWithoutOU))?(CPF_WP1_replaceDNWithoutOU):(0);
	}
	memcpy(flag,tmp,4);

	return 0;
}

/*-----------------------------------------
  input CSR subject matching policy
-----------------------------------------*/
int CA_input_profdnpolicy(unsigned char *flag){
	int i,j=0,k=(flag[4]<<8)|(flag[5]);

	printf("-----\n");
	printf("input CSR subject matching policy.\n");

	i = ca_ask_num("C  : (0.option, 1.supplied, 2.matched)",(k>>14)&3);
	j |= (i&3)<<14;
	i = ca_ask_num("ST : (0.option, 1.supplied, 2.matched)",(k>>12)&3);
	j |= (i&3)<<12;
	i = ca_ask_num("L  : (0.option, 1.supplied, 2.matched)",(k>>10)&3);
	j |= (i&3)<<10;
	i = ca_ask_num("O  : (0.option, 1.supplied, 2.matched)",(k>>8)&3);
	j |= (i&3)<<8;
	i = ca_ask_num("OU : (0.option, 1.supplied, 2.matched)",(k>>6)&3);
	j |= (i&3)<<6;
	i = ca_ask_num("CN : (0.option, 1.supplied, 2.matched)",(k>>4)&3);
	j |= (i&3)<<4;
	i = ca_ask_num("UID: (0.option, 1.supplied, 2.matched)",(k>>2)&3);
	j |= (i&3)<<2;
	i = ca_ask_num("Em : (0.option, 1.supplied, 2.matched)",k&3);
	j |= (i&3);

	flag[4] = (j>>8)&0xff;
	flag[5] = j&0xff;
	return 0;
}

/*-----------------------------------------
  print profile working policy
-----------------------------------------*/
void CA_print_profpolicy(unsigned char *flag){
	printf("  profile working policy :\n");

	printf("    reuse same subject DN ... %s\n",
		   (flag[0]&CPF_WP0_allowSameSbjDN) ? "allowed" : "prohibited");
	printf("    reuse expired subject DN ... %s\n",
		   (flag[0]&CPF_WP0_allowExpdSbjDN) ? "allowed" : "prohibited");
	printf("    reuse revoked subject DN ... %s\n",
		   (flag[0]&CPF_WP0_allowRvkdSbjDN) ? "allowed" : "prohibited");
	printf("    reuse subject DN in renewal period ... %s\n",
		   (flag[0]&CPF_WP0_allowInUpdSbjDN) ? "allowed" : "prohibited");
	printf("    reuse same public key ... %s\n",
		   (flag[0]&CPF_WP0_allowSameKey) ? "allowed" : "prohibited");
	printf("    reuse expired public key ... %s\n",
		   (flag[0]&CPF_WP0_allowExpdKey) ? "allowed" : "prohibited");
	/*
	printf("    reuse revoked public key ... %s\n",
		   (flag[0]&CPF_WP0_allowRvkdKey) ? "allowed" : "prohibited");
	*/
	printf("    reuse public key in renewal period ... %s\n",
		   (flag[0]&CPF_WP0_allowInUpdKey) ? "allowed" : "prohibited");
	printf("    replace subject DN with template ... %s\n",
		   (flag[1]&CPF_WP1_replaceWithTmplDN) ? "allowed" : "prohibited");
	printf("    replace subject DN mode except OU ... %s\n",
		   (flag[1]&CPF_WP1_replaceDNWithoutOU) ? "allowed" : "prohibited");
}

/*-----------------------------------------
  print CSR subject matching policy
-----------------------------------------*/
void CA_print_profdnpolicy(unsigned char *flag){
	char p[4][16]={"option","supplied","matched",""};
	int k = (flag[4]<<8)|(flag[5]);
	
	printf("  CSR subject matching policy :\n");
	printf("    C:%s, ST:%s, L:%s, O:%s\n",p[(k>>14)&3],p[(k>>12)&3],p[(k>>10)&3],p[(k>>8)&3]);
	printf("    OU:%s, CN:%s, UID:%s, E:%s\n",p[(k>>6)&3],p[(k>>4)&3],p[(k>>2)&3],p[k&3]);
}
