/* aica_conf.c */
/*
 * Copyright (c) 2004-2016 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */
/*
 * Copyright (C) 1998-2004
 * Akira Iwata & Takuto Okuno
 * Akira Iwata Laboratory,
 * Nagoya Institute of Technology in Japan.
 *
 * All rights reserved.
 *
 * This software is written by Takuto Okuno(usapato@anet.ne.jp)
 * And if you want to contact us, send an email to Kimitake Wakayama
 * (wakayama@elcom.nitech.ac.jp)
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * 3. All advertising materials mentioning features or use of this software must
 *    display the following acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *    Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *     Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 *   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *   AKIRA IWATA LABORATORY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 *   SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 *   IN NO EVENT SHALL AKIRA IWATA LABORATORY BE LIABLE FOR ANY SPECIAL,
 *   INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
 *   FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 *   NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION
 *   WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <aicrypto/ok_err.h>

#include "ok_caerr.h"
#include "ok_aica.h"
#include "ok_conf.h"

/* prefix for CA directory that includes ca.{cai,cer}, cert, crl, and req. */
#ifndef CAPREFIX
#define CAPREFIX "."
#endif

/* general info */
char ctstore[256]= "";

char capath[256] = ".";
char svpath[256] = "";
char clcert[256] = "";
char clctpw[PWD_BUFLEN*2] = "";

char certid[32]  = "";
char userid[32]  = "";
char pwd[PWD_BUFLEN*2] = "";

int usessl = 0;
int caport = 11411;
int vfycert= 0;

/*-----------------------------------------
  set CA configure
-----------------------------------------*/
int CA_read_config(char *fname){
	char *buf;
	int err=-1;

	/* get store information */
	if((buf=conf_get_section(fname,"[general info]","[general info end]"))==NULL) goto done;
	if(conf_getstr(buf,"store_dir",ctstore,254)) goto done;
	free(buf); buf=NULL;
	
	/* get CA information */
	if((buf=conf_get_section(fname,"[default CA]","[default CA end]"))==NULL) goto done;
	conf_clear_comment(buf);

	err = ca_set_config(buf);
done:
	if(buf) free(buf);
	return err;
}

/**
 * Get the plain string from an encrypted string.
 *
 * @param[in,out] s The string encrypted by aica_encry_passwd().
 * @note this function will be replaced with topaz-ccr:common/aiconf.c.
 */
#define BEGIN_CSTR	"$aicry${"
#define END_CSTR	"}"
static void conf_decstr(char *s)
{
	if (s == NULL) {
		return ;
	} else {
		char *sp = strstr(s, BEGIN_CSTR);
		size_t prfx_len = strlen(BEGIN_CSTR);

		if (sp == NULL) {
			return ;
		} else {
			char *ep;
			sp += prfx_len;
			ep = strstr(sp, END_CSTR);
			if (ep == NULL) {
				/* maybe, wrong encrypted string value. */
				fprintf(stderr, "missing character '%s'",
					END_CSTR);
				return ;
			} else {
				char *tmp;
				*ep = '\0';
				tmp = aica_decry_passwd(sp);
				if (tmp == NULL) {
					/* decription error */
					return ;
				} else {
					(void)strcpy(s, tmp);
					free(tmp);
				}
			}
		}
	}
}

int ca_set_config(char *buf){
	int v1=0,v2=0;

	if(conf_getstr(buf,"ca_dir",capath,254)) goto error;	
	if(conf_getstr(buf,"ca_uid",userid,30)) goto error;
	if(conf_getstr(buf,"ca_pwd",pwd,PWD_BUFLEN)) goto error;
	conf_decstr(pwd);
	if(conf_getint(buf,"ca_port",&caport)) goto error;

	if(conf_getbool(buf,"f_ssl_use",&usessl)) goto error;
	if(conf_getbool(buf,"f_ssl_novfy",&v1)) goto error;
	if(conf_getbool(buf,"f_ssl_novfycrl",&v2)) goto error;

	if(v2) vfycert = IF_NO_CRL_DONT_CHECK_REVOKED | DONT_VERIFY_CRL;
	if(v1) vfycert = DONT_VERIFY;

	if(conf_getstr(buf,"cl_id",certid,32)) goto error;
	if(conf_getstr(buf,"cl_id_pwd",clctpw,PWD_BUFLEN)) goto error;
	conf_decstr(clctpw);
	if(conf_getstr(buf,"cl_p12",clcert,254)) goto error;
	if(conf_getstr(buf,"cl_p12_pwd",clctpw,PWD_BUFLEN)) goto error;

	if(strstr(capath,":")) strncpy(svpath,capath,254);

	return 0;
error:
	return -1;
}
